/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.io.Serializable;
import java.util.Enumeration;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.table.ColumnDefinitionSupport;
import oracle.dms.table.Row;
import oracle.dms.table.RowSupport;
import oracle.dms.table.SchemaSupport;
import oracle.dms.table.TableSupport;
import oracle.dms.table.ValueType;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.PlatformSupportFactory;
import oracle.dms.util.Time;

public class TableGroup
implements Serializable {
    private TableSupport[][] m_tables;
    private String m_id;
    private String m_host;
    private String m_name;
    private long m_timestamp;
    private static final String SERVER_NAME;
    private static final long serialVersionUID = -1231371690971L;

    public TableGroup(TableSupport[][] tables) {
        this.m_tables = tables == null ? (TableSupport[][])null : (TableSupport[][])tables.clone();
        this.m_timestamp = Time.currentTimeMillis();
        this.m_host = DMSUtil.getLocalHostname();
        this.m_id = DMSUtil.getProcessID();
        this.m_name = DMSConsole.getConsole().getName();
        this._init();
    }

    public TableSupport[][] getTables() {
        return this.m_tables == null ? (TableSupport[][])null : (TableSupport[][])this.m_tables.clone();
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public String getID() {
        return this.m_id;
    }

    public String getHost() {
        return this.m_host;
    }

    public String getName() {
        return this.m_name;
    }

    private void _init() {
        if (this.m_tables == null || this.m_tables.length == 0 || SERVER_NAME == null) {
            return;
        }
        for (TableSupport[] tables : this.m_tables) {
            if (tables == null || tables.length == 0) continue;
            for (TableSupport table : tables) {
                if (table == null) continue;
                SchemaSupport schema = (SchemaSupport)table.getSchema();
                if (schema != null && !schema.containsColumn("ServerName")) {
                    new ColumnDefinitionSupport(schema, "ServerName", null, null);
                    table.setColumnType("ServerName", ValueType.STRING);
                }
                Enumeration<? extends Row> iter = table.enumerateRows();
                while (iter.hasMoreElements()) {
                    RowSupport row = (RowSupport)iter.nextElement();
                    if (row.getValue("ServerName") != null) continue;
                    row.updateValue("ServerName", (Serializable)((Object)SERVER_NAME));
                }
                if (table.reportingServerNameCount() != 0) continue;
                table.addReportingServerName(SERVER_NAME);
            }
        }
    }

    static {
        String dpsId = PlatformSupportFactory.getPlatformSupport().getServerName();
        SERVER_NAME = dpsId != null && dpsId.trim().length() > 0 && !"UNKNOWN".equals(dpsId) ? dpsId : null;
    }
}

