/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.dump;

import java.io.FileReader;
import java.util.EnumSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriter;
import oracle.dfw.dump.DumpWriterException;
import oracle.dfw.resource.DiagnosticTranslation;
import oracle.dms.config.paramscopedmetrics.ParamScopedMetricsConfig;
import oracle.dms.context.ContextParameterDescriptor;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.internal.ContextParameterDescriptorInternal;
import oracle.dms.event.EventConfigManager;
import oracle.dms.event.EventSystem;
import oracle.dms.instrument.ActivationParameterDescriptor;
import oracle.dms.instrument.ActivationParameterFactory;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.util.JSONUtils;
import oracle.dms.util.PlatformSupport;
import oracle.dms.util.PlatformSupportFactory;

public class DMSConfigDump
extends ComponentDiagnosticDump {
    private static final String DFW_MESSAGES = DiagnosticTranslation.class.getName();

    @Override
    public String getName() {
        return "configuration";
    }

    @Override
    public String getOwner() {
        return "dms";
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return EnumSet.of(DiagnosticsCategory.CONFIGURATION);
    }

    @Override
    public String getDumpDescription() {
        return this.getMsg("DFW_DMS_CONFIGURATION_DESCRIPTION", null);
    }

    @Override
    public String getDumpDescription(Locale locale) {
        return this.getMsg("DFW_DMS_CONFIGURATION_DESCRIPTION", locale);
    }

    private String getMsg(String key, Locale locale) {
        try {
            if (locale != null) {
                return ResourceBundle.getBundle(DFW_MESSAGES, locale).getString(key);
            }
            return ResourceBundle.getBundle(DFW_MESSAGES).getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    @Override
    public DumpResult executeDump(DumpContext context) throws DumpExecutionException, DumpWriterException {
        DumpWriter dw = new DumpWriter(context);
        PlatformSupport ps = PlatformSupportFactory.getPlatformSupport();
        String dmsConfigFileName = ps.getConfigFilename();
        dw.dumpln("DMSConfigFileName:");
        dw.dumpln(dmsConfigFileName);
        if (dmsConfigFileName != null) {
            try {
                int charCount;
                FileReader fr = new FileReader(dmsConfigFileName);
                StringBuilder sb = new StringBuilder(1024);
                char[] buf = new char[1024];
                while ((charCount = fr.read(buf)) > 0) {
                    sb.append(buf, 0, charCount);
                }
                dw.dumpln("DMSConfigFile:");
                dw.dumpln(sb.toString());
                fr.close();
            }
            catch (Exception e) {
                dw.dump("DMSConfigFile-Error:");
                dw.dumpln(e.toString());
            }
        }
        dw.dumpln();
        dw.dumpln("CurrentlyExecutingEventConfiguration:");
        EventConfigManager ecm = EventSystem.getEventConfigManager();
        if (ecm == null) {
            dw.dumpln(null);
        } else {
            dw.dumpln(ecm.toString());
        }
        dw.dumpln();
        dw.dumpln("CurrentlyExecutingParameterScopedMetricsConfiguration:");
        ParamScopedMetricsConfig psmc = ParamScopedMetricsConfig.getCurrentParamScopedMetricsConfig();
        if (psmc == null) {
            dw.dumpln(null);
        } else {
            dw.dumpln(psmc.toString());
        }
        dw.dumpln();
        dw.dumpln("ActivationParameters:");
        ActivationParameterFactory apf = DMSConsole.getActivationParameterFactory();
        Set<String> actParams = apf.getDescriptorNames();
        if (actParams != null) {
            for (String paramName : actParams) {
                ActivationParameterDescriptor activationParameterDescriptor = apf.findDescriptor(paramName);
                if (activationParameterDescriptor == null) continue;
                dw.dumpln(activationParameterDescriptor.toString());
            }
        }
        dw.dumpln();
        dw.dumpln("ContextParameters:");
        Set<ContextParameterDescriptorInternal> ctxParams = DMSContextManager.getDomainContextManager().getContextParameterDescriptors();
        if (ctxParams != null) {
            for (ContextParameterDescriptor contextParameterDescriptor : ctxParams) {
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                JSONUtils.appendNameValuePair(sb, "name", contextParameterDescriptor.getName());
                sb.append(',');
                JSONUtils.appendNameValuePair(sb, "valueSetSize", contextParameterDescriptor.getValueSetSize());
                sb.append(',');
                JSONUtils.appendNameValuePair(sb, "valueSet", contextParameterDescriptor.getValueSet());
                sb.append('}');
                dw.dumpln(sb.toString());
            }
        }
        dw.dumpln();
        DumpResult result = dw.getDumpResult();
        return result;
    }
}

