/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event;

import java.util.LinkedList;
import java.util.List;

public enum EventActionType {
    CREATE,
    UPDATE,
    DELETE,
    METRIC_SELECTION_CHANGED,
    TYPE_CHANGE,
    START,
    STOP,
    ABORT,
    CONTEXT_CHANGED,
    SUSPEND,
    RESUME;

    private int mExactTypeBit = 0;
    private int mAllTypeBits = 0;
    private EventActionType mSuperType = null;
    private List<EventActionType> mSubTypeList = new LinkedList<EventActionType>();

    private void setSuperType(EventActionType superType) {
        this.mSuperType = superType;
        this.mAllTypeBits |= this.mSuperType.mAllTypeBits;
        this.mSuperType.mSubTypeList.add(this);
    }

    public boolean isTypeOf(EventActionType querySourceType) {
        return (this.mAllTypeBits & querySourceType.mExactTypeBit) != 0;
    }

    List<EventActionType> getSubTypeList() {
        return this.mSubTypeList;
    }

    boolean in(EventActionType[] eventActionTypes) {
        boolean retVal = false;
        if (eventActionTypes != null) {
            for (EventActionType eventActionType : eventActionTypes) {
                if (eventActionType != this) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    static {
        if (EventActionType.values().length > 31) {
            throw new RuntimeException("Too many EventActionTypes, not enough bits");
        }
        for (EventActionType e : EventActionType.values()) {
            e.mAllTypeBits = e.mExactTypeBit = 1 << e.ordinal();
        }
        START.setSuperType(UPDATE);
        STOP.setSuperType(UPDATE);
        ABORT.setSuperType(UPDATE);
    }
}

