/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import oracle.core.ojdl.logging.ODLLogger;
import oracle.dms.event.EventResourceBundle;
import oracle.dms.event.config.DestinationDescription;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.JSONUtils;
import oracle.dms.util.Time;

@JSONUtils.JSONFormatToString
public class Destination
implements Serializable {
    private static final int SEED = 400;
    private int m_hashCode;
    private Map<String, String> m_property = new HashMap<String, String>();
    private String m_DestinationClassName;
    private String m_DestinationName;
    private String m_DestinationId;
    private String m_DestinationClassNameDescription;
    private String m_asString;
    private transient ODLLogger m_logger;
    private static String LOGGER_NAME = "oracle.dms.event";
    private static final String CLASS_NAME = Destination.class.getName();
    private static final long serialVersionUID = 0L;
    private AtomicLong mLastModified = new AtomicLong(0L);

    public static Destination from(CompositeData cd) {
        Destination d = new Destination((String)cd.get("destinationId"), (String)cd.get("destinationClassName"));
        d.setDestinationName((String)cd.get("destinationName"));
        TabularData td = (TabularData)cd.get("properties");
        for (Object row : td.values()) {
            CompositeData tcd = (CompositeData)row;
            d.setProperty((String)tcd.get("key"), (String)tcd.get("value"));
        }
        return d;
    }

    public Destination(String destinationId, String destinationClassName) {
        this.m_logger = ODLLogger.getODLLogger((String)LOGGER_NAME, (String)EventResourceBundle.class.getName());
        if (!DMSUtil.isLegalIdentifier(destinationId) || !DMSUtil.isLegalIdentifier(destinationClassName)) {
            throw new IllegalArgumentException("invalid arguments to Destination; destinationId=" + destinationId + " destinationClassName=" + destinationClassName + ". " + "The following are valid identifiers, starting with a letter: \nLetters: a-z, A-Z, and other alphabetic characters from other languages. \nDigits: 0-9 \nSpecial: _ (underscore) and - (dash)");
        }
        this.m_DestinationId = destinationId;
        this.m_DestinationClassName = destinationClassName;
        this.mLastModified = new AtomicLong(Time.currentTimeMillis());
        this.setHashCode();
    }

    public void setDestinationClassName(String destinationClassName) {
        if (!DMSUtil.isLegalIdentifier(destinationClassName)) {
            throw new IllegalArgumentException("invalid destinationClassName " + destinationClassName + ". " + "The following are valid identifiers, starting with a letter: \nLetters: a-z, A-Z, and other alphabetic characters from other languages. \nDigits: 0-9 \nSpecial: _ (underscore) and - (dash)");
        }
        this.m_DestinationClassName = destinationClassName;
        this.m_DestinationClassNameDescription = null;
        this.setLastModified();
        this.setHashCode();
        this.m_asString = null;
    }

    public String getDestinationClassNameDescription() {
        String METHOD_NAME = "getDestinationClassNameDescription";
        Class<?> destinationClass = null;
        String destinationClassNameDescription = null;
        if (this.m_DestinationClassNameDescription == null) {
            block12: {
                block10: {
                    try {
                        destinationClass = Class.forName(this.m_DestinationClassName);
                    }
                    catch (Throwable e) {
                        String classMsg = "class name " + this.m_DestinationClassName + " in destination " + this.m_DestinationId + " does not exist";
                        if (!this.m_logger.isLoggable(Level.FINER)) break block10;
                        this.m_logger.logp(Level.FINE, CLASS_NAME, "getDestinationClassNameDescription", classMsg);
                    }
                }
                if (destinationClass != null && destinationClass.isAnnotationPresent(DestinationDescription.class)) {
                    DestinationDescription destinationDescriptionAnnotation = destinationClass.getAnnotation(DestinationDescription.class);
                    String nlsDescriptionResourceBundle = null;
                    String nlsDescriptionID = null;
                    DestinationDescription destDescription = destinationDescriptionAnnotation;
                    nlsDescriptionResourceBundle = destDescription.nlsDescriptionResourceBundle();
                    nlsDescriptionID = destDescription.nlsDescriptionID();
                    if (nlsDescriptionResourceBundle.compareTo("Oracle DMS Event Tracing NULL") != 0) {
                        String msg;
                        ResourceBundle bundle;
                        block11: {
                            bundle = null;
                            try {
                                bundle = ResourceBundle.getBundle(nlsDescriptionResourceBundle);
                            }
                            catch (Exception e) {
                                msg = "resource bundle " + nlsDescriptionResourceBundle + " specified in destination class" + this.m_DestinationClassName + " for destination " + this.m_DestinationId + " does not exist";
                                if (!this.m_logger.isLoggable(Level.FINER)) break block11;
                                this.m_logger.logp(Level.FINE, CLASS_NAME, "getDestinationClassNameDescription", msg);
                            }
                        }
                        if (bundle != null) {
                            try {
                                destinationClassNameDescription = bundle.getString(nlsDescriptionID);
                            }
                            catch (Exception e) {
                                msg = nlsDescriptionID + " not found in resource bundle " + nlsDescriptionResourceBundle + " for destination class " + this.m_DestinationClassName + ". Destination " + this.m_DestinationId;
                                if (!this.m_logger.isLoggable(Level.FINER)) break block12;
                                this.m_logger.logp(Level.FINE, CLASS_NAME, "getDestinationClassNameDescription", msg);
                            }
                        }
                    }
                }
            }
            this.m_DestinationClassNameDescription = destinationClassNameDescription;
        }
        return this.m_DestinationClassNameDescription;
    }

    public void setDestinationName(String destinationName) {
        this.m_DestinationName = destinationName;
        this.setLastModified();
        this.setHashCode();
        this.m_asString = null;
    }

    public String getDestinationName() {
        return this.m_DestinationName;
    }

    public String getDestinationId() {
        return this.m_DestinationId;
    }

    public String getDestinationClassName() {
        return this.m_DestinationClassName;
    }

    public void removeProperty(String propertyName) {
        this.m_property.remove(propertyName);
        this.setLastModified();
        this.setHashCode();
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.m_property.put(propertyName, propertyValue);
        this.setLastModified();
        this.setHashCode();
        this.m_asString = null;
    }

    public String getProperty(String propertyName) {
        return this.m_property.get(propertyName);
    }

    public Map<String, String> getProperties() {
        return this.m_property;
    }

    public long getLastModified() {
        return this.mLastModified.get();
    }

    private void setLastModified() {
        this.mLastModified.set(Time.currentTimeMillis());
        this.setHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination destination = (Destination)obj;
        boolean getDestinationId = this.getDestinationId() == null && destination.getDestinationId() == null ? true : (this.getDestinationId() == null && destination.getDestinationId() != null ? false : (this.getDestinationId() != null && destination.getDestinationId() == null ? false : this.getDestinationId().equals(destination.getDestinationId())));
        boolean getDestinationName = this.getDestinationName() == null && destination.getDestinationName() == null ? true : (this.getDestinationName() == null && destination.getDestinationName() != null ? false : (this.getDestinationName() != null && destination.getDestinationName() == null ? false : this.getDestinationName().equals(destination.getDestinationName())));
        boolean getDestinationClassName = this.getDestinationClassName() == null && destination.getDestinationClassName() == null ? true : (this.getDestinationClassName() == null && destination.getDestinationClassName() != null ? false : (this.getDestinationClassName() != null && destination.getDestinationClassName() == null ? false : this.getDestinationClassName().equals(destination.getDestinationClassName())));
        boolean getProperties = this.getProperties() == null && destination.getProperties() == null ? true : (this.getProperties() == null && destination.getProperties() != null ? false : (this.getProperties() != null && destination.getProperties() == null ? false : this.getProperties().equals(destination.getProperties())));
        return getDestinationId && getDestinationName && getDestinationClassName && getProperties;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    private void setHashCode() {
        int retVal = 400;
        if (this.getDestinationId() != null) {
            retVal = retVal * 400 + this.getDestinationId().hashCode();
        }
        if (this.getDestinationName() != null) {
            retVal = retVal * 400 + this.getDestinationName().hashCode();
        }
        if (this.getDestinationClassName() != null) {
            retVal = retVal * 400 + this.getDestinationClassName().hashCode();
        }
        if (this.getProperties() != null) {
            retVal = retVal * 400 + this.getProperties().hashCode();
        }
        this.m_hashCode = retVal;
    }

    public String toString() {
        if (this.m_asString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            JSONUtils.appendNameValuePair(sb, "destinationId", this.m_DestinationId);
            if (this.m_property != null && this.m_property.size() > 0) {
                sb.append(',');
                JSONUtils.appendNameValuePair(sb, "properties", this.m_property);
            }
            sb.append('}');
            this.m_asString = sb.toString();
        }
        return this.m_asString;
    }
}

