/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.dms.ParameterDescriptor;
import oracle.dms.context.ContextParameterDescriptor;
import oracle.dms.context.ContextParameterFactory;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.internal.ContextParameterFactoryImpl;
import oracle.dms.context.internal.ContextParameterListener;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.event.Destination;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventSystem;
import oracle.dms.event.EventType;
import oracle.dms.event.EventTypeEnthusiast;
import oracle.dms.event.NullFilterWithEventTypeProxy;
import oracle.dms.instrument.ActivationParameter;
import oracle.dms.instrument.ActivationParameterDescriptor;
import oracle.dms.instrument.ActivationParameterFactory;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.NounLifecycleWalker;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.internal.ActivationParameterFactoryImpl;
import oracle.dms.instrument.internal.ActivationParameterListener;
import oracle.dms.instrument.internal.EventSensorCoreData;
import oracle.dms.instrument.internal.ParamScopedMetricsConfig;
import oracle.dms.instrument.internal.ParamScopedMetricsConfigBuilder;
import oracle.dms.instrument.internal.ParamScopedMetricsConfigManager;
import oracle.dms.instrument.internal.ParamScopedMetricsRuntimeManager;
import oracle.dms.instrument.internal.PhaseSensorCoreData;
import oracle.dms.instrument.internal.SensorCoreData;
import oracle.dms.jmx.ParameterScopedMetricsRule;
import oracle.dms.util.ClientObjectKey;
import oracle.dms.util.ClientObjectKeyManager;
import oracle.dms.util.ObjectUtils;
import oracle.dms.util.Validatable;

public class ParamScopedMetricsSystem {
    private static final ClientObjectKey NOUN_DESCRIPTOR_CLIENT_OBJECT_KEY = ClientObjectKeyManager.requestClientObjectKey(ClientObjectKeyManager.ClientObjectHolderType.NOUN_DESCRIPTOR, "oracle.dms.instrument.internal.ParamScopedMetricsSystem:MetricScopingRules");
    private static final ClientObjectKey SCOPED_SENSOR_DATA_CLIENT_KEY = ClientObjectKeyManager.requestClientObjectKey(ClientObjectKeyManager.ClientObjectHolderType.SENSOR, "oracle.dms.instrument.internal.ParamScopedMetricsSystem:scopedMetricData");
    private static volatile ParamScopedMetricsRuntimeManagerImpl sRuntimeManager = new ParamScopedMetricsRuntimeManagerImpl();
    private static ParamScopedMetricsConfigManagerImpl sConfigManager = new ParamScopedMetricsConfigManagerImpl();

    public static ParamScopedMetricsRuntimeManager getRuntimeManager() {
        return sRuntimeManager;
    }

    static void clearRuntimeManager() {
        sRuntimeManager = null;
    }

    static void setRuntimeManager() {
        if (sRuntimeManager == null) {
            sRuntimeManager = new ParamScopedMetricsRuntimeManagerImpl();
        }
    }

    public static ParamScopedMetricsConfigManager getConfigManager() {
        return sConfigManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParamScopedMetricsConfigBuilder getConfigBuilder() {
        ParamScopedMetricsConfigBuilderImpl retVal = null;
        if (sConfigManager != null) {
            ParamScopedMetricsConfigManagerImpl paramScopedMetricsConfigManagerImpl = sConfigManager;
            synchronized (paramScopedMetricsConfigManagerImpl) {
                ProposedParamScopedMetricsConfig config = new ProposedParamScopedMetricsConfig(sConfigManager);
                retVal = new ParamScopedMetricsConfigBuilderImpl(config);
            }
        }
        return retVal;
    }

    static class ParamDescriptorListenerImpl
    implements ContextParameterListener,
    ActivationParameterListener {
        ParamScopedMetricsConfigManagerImpl mConfigMgr;

        ParamDescriptorListenerImpl(ParamScopedMetricsConfigManagerImpl configMgr) {
            this.mConfigMgr = configMgr;
        }

        @Override
        public void parameterDescriptorCreated(ContextParameterDescriptor descriptor) {
            this.mConfigMgr.reactivateProposedConfig(true, true);
        }

        @Override
        public void parameterDescriptorCreated(ActivationParameterDescriptor descriptor) {
            this.mConfigMgr.reactivateProposedConfig(true, false);
        }
    }

    static class IndirectParamDescriptor {
        private final String mParameterName;
        private final Class<? extends ParameterDescriptor> mDescriptorClass;
        private ParameterDescriptor mParameterDescriptor;

        IndirectParamDescriptor(String parameterName, Class<? extends ParameterDescriptor> descriptorClass) {
            this.mParameterName = parameterName;
            this.mDescriptorClass = descriptorClass;
        }

        ParameterDescriptor getParameterDescriptor() {
            ParameterDescriptor retVal = this.mParameterDescriptor;
            if (retVal == null) {
                DomainContextManager dcm;
                if (this.mDescriptorClass == ActivationParameterDescriptor.class) {
                    ActivationParameterFactory apf = DMSConsole.getActivationParameterFactory();
                    if (apf != null) {
                        retVal = apf.findDescriptor(this.mParameterName);
                    }
                } else if (this.mDescriptorClass == ContextParameterDescriptor.class && (dcm = DMSContextManager.getDomainContextManager()) != null) {
                    retVal = dcm.findContextParameterDescriptor(this.mParameterName);
                }
                this.mParameterDescriptor = retVal;
            }
            return retVal;
        }

        String getParameterName() {
            return this.mParameterName;
        }

        Class<? extends ParameterDescriptor> getDescriptorClass() {
            return this.mDescriptorClass;
        }

        public int hashCode() {
            return this.mParameterName.hashCode() ^ this.mDescriptorClass.hashCode();
        }

        public boolean equals(Object o) {
            boolean retVal = false;
            if (o instanceof IndirectParamDescriptor) {
                IndirectParamDescriptor that = (IndirectParamDescriptor)o;
                retVal = this.mParameterName.equals(that.mParameterName) && this.mDescriptorClass.equals(that.mDescriptorClass);
            }
            return retVal;
        }
    }

    static class ProposedParamScopedMetricsConfig
    implements ParamScopedMetricsConfig {
        private final ParamScopedMetricsConfigManagerImpl mConfigManager;
        private final Map<ParameterScopedMetricsRule.NounTypePattern, Map<IndirectParamDescriptor, ParameterValueConfigImpl>> mProposedNTNtoIPDMap = new HashMap<ParameterScopedMetricsRule.NounTypePattern, Map<IndirectParamDescriptor, ParameterValueConfigImpl>>();

        ProposedParamScopedMetricsConfig(ParamScopedMetricsConfigManagerImpl cfgMgr) {
            this.mConfigManager = cfgMgr;
        }

        void addProposedNounDescToValueConfigMap(ParameterScopedMetricsRule.NounTypePattern nounTypePattern, Map<IndirectParamDescriptor, ParameterValueConfigImpl> IPDtoPVC) {
            this.mProposedNTNtoIPDMap.put(nounTypePattern, IPDtoPVC);
        }

        Map<IndirectParamDescriptor, ParameterValueConfigImpl> getProposedParamDescToValueConfigMap(ParameterScopedMetricsRule.NounTypePattern nounTypePattern) {
            return this.mProposedNTNtoIPDMap.get(nounTypePattern);
        }

        public Map<String, ParameterValueConfigImpl> getActParamConfigForNounType(String nounTypeName) {
            Map<String, ParameterValueConfigImpl> retVal = this.getActParamConfigForNounType(nounTypeName, ActivationParameterDescriptor.class);
            return retVal;
        }

        public Map<String, ParameterValueConfigImpl> getCtxParamConfigForNounType(String nounTypeName) {
            Map<String, ParameterValueConfigImpl> retVal = this.getActParamConfigForNounType(nounTypeName, ContextParameterDescriptor.class);
            return retVal;
        }

        private Map<String, ParameterValueConfigImpl> getActParamConfigForNounType(String nounTypeName, Class<? extends ParameterDescriptor> descriptorClass) {
            HashMap<String, ParameterValueConfigImpl> retVal = null;
            HashMap<String, ParameterValueConfigImpl> partialParamResult = new HashMap<String, ParameterValueConfigImpl>();
            for (Map.Entry<ParameterScopedMetricsRule.NounTypePattern, Map<IndirectParamDescriptor, ParameterValueConfigImpl>> entry : this.mProposedNTNtoIPDMap.entrySet()) {
                if (!entry.getKey().isMatch(nounTypeName)) continue;
                for (Map.Entry<IndirectParamDescriptor, ParameterValueConfigImpl> entry2 : entry.getValue().entrySet()) {
                    if (entry2.getKey().getDescriptorClass() != descriptorClass) continue;
                    partialParamResult.put(entry2.getKey().getParameterName(), entry2.getValue());
                }
            }
            if (partialParamResult.size() > 0) {
                retVal = partialParamResult;
            }
            return retVal;
        }

        @Override
        public boolean isEmpty() {
            return this.mProposedNTNtoIPDMap.isEmpty();
        }

        @Override
        public void activate() {
            this.mConfigManager.activateConfiguration(this);
        }

        ValidParamScopedMetricsConfig deriveValidConfiguration() {
            ValidParamScopedMetricsConfig retVal = null;
            HashMap<ParameterScopedMetricsRule.NounTypePattern, Map<ParameterDescriptor, ParameterValueConfigImpl>> validNTNtoPDMap = new HashMap<ParameterScopedMetricsRule.NounTypePattern, Map<ParameterDescriptor, ParameterValueConfigImpl>>();
            for (Map.Entry<ParameterScopedMetricsRule.NounTypePattern, Map<IndirectParamDescriptor, ParameterValueConfigImpl>> e1 : this.mProposedNTNtoIPDMap.entrySet()) {
                ParameterScopedMetricsRule.NounTypePattern nounTypePattern = e1.getKey();
                Map<IndirectParamDescriptor, ParameterValueConfigImpl> m1 = e1.getValue();
                HashMap<ParameterDescriptor, ParameterValueConfigImpl> m2 = new HashMap<ParameterDescriptor, ParameterValueConfigImpl>();
                for (Map.Entry<IndirectParamDescriptor, ParameterValueConfigImpl> e2 : m1.entrySet()) {
                    IndirectParamDescriptor ipd = e2.getKey();
                    ParameterValueConfigImpl pvci = e2.getValue();
                    if (ipd.getParameterDescriptor() == null) continue;
                    m2.put(ipd.getParameterDescriptor(), pvci);
                }
                validNTNtoPDMap.put(nounTypePattern, m2);
            }
            if (!validNTNtoPDMap.isEmpty()) {
                retVal = new ValidParamScopedMetricsConfig(validNTNtoPDMap);
            }
            return retVal;
        }
    }

    static class ValidParamScopedMetricsConfig {
        private final Map<ParameterScopedMetricsRule.NounTypePattern, Map<ParameterDescriptor, ParameterValueConfigImpl>> mValidNTNtoPDMap;
        private Set<String> mNounTypesProcessed = Collections.newSetFromMap(new ConcurrentHashMap());

        ValidParamScopedMetricsConfig(Map<ParameterScopedMetricsRule.NounTypePattern, Map<ParameterDescriptor, ParameterValueConfigImpl>> validNTNtoPDMap) {
            this.mValidNTNtoPDMap = validNTNtoPDMap;
        }

        ValidParamScopedMetricsConfig() {
            this.mValidNTNtoPDMap = new HashMap<ParameterScopedMetricsRule.NounTypePattern, Map<ParameterDescriptor, ParameterValueConfigImpl>>();
        }

        boolean hasProcessedNounType(String mNounType) {
            boolean retVal = this.mNounTypesProcessed.contains(mNounType);
            return retVal;
        }

        void addProcessedNounType(String mNounType) {
            this.mNounTypesProcessed.add(mNounType);
        }

        Map<ParameterDescriptor, ParameterValueConfigImpl> getValidParamDescToValueConfigMap(String nounTypeName) {
            HashMap<ParameterDescriptor, ParameterValueConfigImpl> retVal = null;
            for (Map.Entry<ParameterScopedMetricsRule.NounTypePattern, Map<ParameterDescriptor, ParameterValueConfigImpl>> entry : this.mValidNTNtoPDMap.entrySet()) {
                if (!entry.getKey().isMatch(nounTypeName)) continue;
                if (retVal == null) {
                    retVal = new HashMap<ParameterDescriptor, ParameterValueConfigImpl>();
                }
                retVal.putAll(entry.getValue());
            }
            return retVal;
        }

        <T extends ParameterDescriptor> Set<DescriptorAndValueConfigTuple<T>> getValidParamConfigForNounType(String nounTypeName, Class<? extends ParameterDescriptor> descriptorClass) {
            HashSet<DescriptorAndValueConfigTuple<ParameterDescriptor>> tmpVal = new HashSet<DescriptorAndValueConfigTuple<ParameterDescriptor>>();
            Map<ParameterDescriptor, ParameterValueConfigImpl> PDtoPVCMap = this.getValidParamDescToValueConfigMap(nounTypeName);
            if (PDtoPVCMap != null) {
                for (Map.Entry<ParameterDescriptor, ParameterValueConfigImpl> entry : PDtoPVCMap.entrySet()) {
                    ParameterDescriptor pd;
                    if (!descriptorClass.isInstance(entry.getKey()) || (pd = entry.getKey()) == null) continue;
                    DescriptorAndValueConfigTuple<ParameterDescriptor> tuple = new DescriptorAndValueConfigTuple<ParameterDescriptor>(pd, entry.getValue());
                    tmpVal.add(tuple);
                }
            }
            HashSet<DescriptorAndValueConfigTuple<ParameterDescriptor>> retVal = null;
            if (tmpVal.size() > 0) {
                retVal = new HashSet<DescriptorAndValueConfigTuple<ParameterDescriptor>>(tmpVal.size(), 1.0f);
                retVal.addAll(tmpVal);
            }
            return retVal;
        }

        boolean isEmpty() {
            return this.mValidNTNtoPDMap.isEmpty();
        }

        static ValidParamScopedMetricsConfig[] diff(ValidParamScopedMetricsConfig configLH, ValidParamScopedMetricsConfig configRH) {
            ValidParamScopedMetricsConfig configOnlyInRH;
            ValidParamScopedMetricsConfig configInBoth;
            ValidParamScopedMetricsConfig configOnlyInLH;
            if (configLH == null && configRH == null) {
                configOnlyInLH = null;
                configInBoth = null;
                configOnlyInRH = null;
            } else if (configLH != null && configRH == null) {
                configOnlyInLH = configLH;
                configInBoth = null;
                configOnlyInRH = null;
            } else if (configLH == null && configRH != null) {
                configOnlyInLH = null;
                configInBoth = null;
                configOnlyInRH = configRH;
            } else {
                configOnlyInLH = new ValidParamScopedMetricsConfig();
                configInBoth = new ValidParamScopedMetricsConfig();
                configOnlyInRH = new ValidParamScopedMetricsConfig();
                HashSet<ParameterScopedMetricsRule.NounTypePattern> commonNounTypePatterns = new HashSet<ParameterScopedMetricsRule.NounTypePattern>();
                for (ParameterScopedMetricsRule.NounTypePattern lhNounTypePattern : configLH.mValidNTNtoPDMap.keySet()) {
                    if (configRH.mValidNTNtoPDMap.containsKey(lhNounTypePattern)) {
                        commonNounTypePatterns.add(lhNounTypePattern);
                        continue;
                    }
                    configOnlyInLH.mValidNTNtoPDMap.put(lhNounTypePattern, configLH.mValidNTNtoPDMap.get(lhNounTypePattern));
                }
                for (ParameterScopedMetricsRule.NounTypePattern rhNounTypePattern : configRH.mValidNTNtoPDMap.keySet()) {
                    if (configLH.mValidNTNtoPDMap.containsKey(rhNounTypePattern)) {
                        commonNounTypePatterns.add(rhNounTypePattern);
                        continue;
                    }
                    configOnlyInRH.mValidNTNtoPDMap.put(rhNounTypePattern, configRH.mValidNTNtoPDMap.get(rhNounTypePattern));
                }
                for (ParameterScopedMetricsRule.NounTypePattern commonNounTypePattern : commonNounTypePatterns) {
                    Map<ParameterDescriptor, ParameterValueConfigImpl> lhIPD2PVC = configLH.mValidNTNtoPDMap.get(commonNounTypePattern);
                    Map<ParameterDescriptor, ParameterValueConfigImpl> rhIPD2PVC = configRH.mValidNTNtoPDMap.get(commonNounTypePattern);
                    HashSet<ParameterDescriptor> allPDs = new HashSet<ParameterDescriptor>();
                    allPDs.addAll(lhIPD2PVC.keySet());
                    allPDs.addAll(rhIPD2PVC.keySet());
                    for (ParameterDescriptor pd : allPDs) {
                        boolean addToLH = false;
                        boolean addToRH = false;
                        if (lhIPD2PVC.containsKey(pd) && rhIPD2PVC.containsKey(pd)) {
                            ParameterValueConfigImpl rhPVC;
                            ParameterValueConfigImpl lhPVC = lhIPD2PVC.get(pd);
                            if (lhPVC.equals(rhPVC = rhIPD2PVC.get(pd))) {
                                Map<ParameterDescriptor, ParameterValueConfigImpl> common = configInBoth.mValidNTNtoPDMap.get(commonNounTypePattern);
                                if (common == null) {
                                    common = new HashMap<ParameterDescriptor, ParameterValueConfigImpl>();
                                    configInBoth.mValidNTNtoPDMap.put(commonNounTypePattern, common);
                                }
                                common.put(pd, rhIPD2PVC.get(pd));
                            } else {
                                addToLH = true;
                                addToRH = true;
                            }
                        }
                        if (lhIPD2PVC.containsKey(pd) && !rhIPD2PVC.containsKey(pd) || addToLH) {
                            Map<ParameterDescriptor, ParameterValueConfigImpl> lhm = configOnlyInLH.mValidNTNtoPDMap.get(commonNounTypePattern);
                            if (lhm == null) {
                                lhm = new HashMap<ParameterDescriptor, ParameterValueConfigImpl>();
                                configOnlyInLH.mValidNTNtoPDMap.put(commonNounTypePattern, lhm);
                            }
                            lhm.put(pd, lhIPD2PVC.get(pd));
                        }
                        if ((lhIPD2PVC.containsKey(pd) || !rhIPD2PVC.containsKey(pd)) && !addToRH) continue;
                        Map<ParameterDescriptor, ParameterValueConfigImpl> rhm = configOnlyInRH.mValidNTNtoPDMap.get(commonNounTypePattern);
                        if (rhm == null) {
                            rhm = new HashMap<ParameterDescriptor, ParameterValueConfigImpl>();
                            configOnlyInRH.mValidNTNtoPDMap.put(commonNounTypePattern, rhm);
                        }
                        rhm.put(pd, rhIPD2PVC.get(pd));
                    }
                }
            }
            ValidParamScopedMetricsConfig[] retVal = new ValidParamScopedMetricsConfig[]{configOnlyInLH, configInBoth, configOnlyInRH};
            return retVal;
        }
    }

    static class ParameterValueConfigImpl
    implements ParamScopedMetricsConfig.ParameterValueConfig {
        private final Set<String> mValueSet;
        private final String mDefaultValue;
        private final int mMaxSizeOfSet;
        private final int mHashCode;

        ParameterValueConfigImpl(int maxSizeOfSet, Set<String> valueSet, String defaultValue) {
            int hashCode = 0;
            if (valueSet != null && !valueSet.isEmpty()) {
                this.mValueSet = valueSet;
                this.mMaxSizeOfSet = this.mValueSet.size();
            } else {
                this.mValueSet = null;
                this.mMaxSizeOfSet = maxSizeOfSet;
            }
            hashCode ^= this.mMaxSizeOfSet;
            this.mDefaultValue = defaultValue;
            if (this.mDefaultValue != null) {
                hashCode ^= this.mDefaultValue.hashCode();
            }
            if (this.mValueSet != null) {
                for (String s : this.mValueSet) {
                    hashCode ^= s.hashCode();
                }
            }
            this.mHashCode = hashCode;
        }

        @Override
        public String getDefaultValue() {
            return this.mDefaultValue;
        }

        @Override
        public Set<String> getValueSet() {
            return this.mValueSet;
        }

        @Override
        public int getMaxSizeOfSet() {
            return this.mMaxSizeOfSet;
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object o) {
            boolean retVal = false;
            if (o instanceof ParameterValueConfigImpl) {
                ParameterValueConfigImpl that = (ParameterValueConfigImpl)o;
                retVal = this.mMaxSizeOfSet == that.mMaxSizeOfSet && ObjectUtils.areEqual(this.mDefaultValue, that.mDefaultValue) && ObjectUtils.areEqual(this.mValueSet, that.mValueSet);
            }
            return retVal;
        }
    }

    static class ParamScopedMetricsConfigBuilderImpl
    implements ParamScopedMetricsConfigBuilder {
        private final ProposedParamScopedMetricsConfig mConfig;
        private boolean mEditable;
        private Exception mBuildException;

        ParamScopedMetricsConfigBuilderImpl(ProposedParamScopedMetricsConfig config) {
            this.mConfig = config;
            this.mEditable = true;
        }

        @Override
        public ParamScopedMetricsConfig getConfig() {
            if (this.mBuildException != null) {
                throw new IllegalStateException("The configuration object under construction can not be retrieved because an exception was encountered during one of the building steps.", this.mBuildException);
            }
            this.mEditable = false;
            return this.mConfig;
        }

        @Override
        public void addRule(String parameterName, Class<? extends ParameterDescriptor> parameterDescriptorClass, Set<ParameterScopedMetricsRule.NounTypePattern> nounTypePatternSet, Set<String> valueSet, int maxSizeOfSet, String defaultValue) {
            if (!this.mEditable) {
                throw new IllegalStateException("Can not addParameterDescriptorRule - Builder instance is no longer editable.");
            }
            if (nounTypePatternSet != null) {
                for (ParameterScopedMetricsRule.NounTypePattern nt : nounTypePatternSet) {
                    this.addRule(parameterName, parameterDescriptorClass, nt, valueSet, maxSizeOfSet, defaultValue);
                }
            }
        }

        @Override
        public void addRule(String parameterName, Class<? extends ParameterDescriptor> parameterDescriptorClass, ParameterScopedMetricsRule.NounTypePattern nounTypePattern, Set<String> valueSet, int maxSizeOfSet, String defaultValue) {
            if (!this.mEditable) {
                throw new IllegalStateException("Can not addParameterDescriptorRule - Builder instance is no longer editable.");
            }
            Map<IndirectParamDescriptor, ParameterValueConfigImpl> IPDtoValueConfigMap = this.mConfig.getProposedParamDescToValueConfigMap(nounTypePattern);
            if (IPDtoValueConfigMap == null) {
                IPDtoValueConfigMap = new HashMap<IndirectParamDescriptor, ParameterValueConfigImpl>();
                this.mConfig.addProposedNounDescToValueConfigMap(nounTypePattern, IPDtoValueConfigMap);
            }
            IndirectParamDescriptor ipd = new IndirectParamDescriptor(parameterName, parameterDescriptorClass);
            ParameterValueConfigImpl oldValueConfig = IPDtoValueConfigMap.get(ipd);
            ParameterValueConfigImpl newValueConfig = new ParameterValueConfigImpl(maxSizeOfSet, valueSet, defaultValue);
            if (oldValueConfig == null) {
                IPDtoValueConfigMap.put(ipd, newValueConfig);
            } else if (!newValueConfig.equals(oldValueConfig)) {
                IllegalArgumentException re = new IllegalArgumentException("This configuration already has a rule for the collection of parameter scoped metrics for nouns matchin patterrn " + nounTypePattern + ", based on the " + parameterDescriptorClass.getName() + " with name " + parameterName + ".");
                this.setBuildStepError(re);
                throw re;
            }
        }

        private void setBuildStepError(Exception e) {
            this.mEditable = false;
            this.mBuildException = e;
        }
    }

    static class DMSEventDestination
    implements Destination,
    EventTypeEnthusiast {
        private final ParamScopedMetricsConfigManagerImpl mConfigManager;
        private final ValidParamScopedMetricsConfig mFullConfig;
        private final ValidParamScopedMetricsConfig mConfigToAdd;
        private final ValidParamScopedMetricsConfig mConfigToRemove;
        private final boolean mOperateOnNewObjects;
        private final String mId;
        EventType[] sEventTypes = EventType.parseList("PHASE_SENSOR:CREATE, EVENT_SENSOR:CREATE, NOUN:CREATE");

        DMSEventDestination(ParamScopedMetricsConfigManagerImpl configManager, ValidParamScopedMetricsConfig fullConfig, ValidParamScopedMetricsConfig configToAdd, ValidParamScopedMetricsConfig configToRemove, boolean operateOnNewObjects, String id) {
            this.mConfigManager = configManager;
            this.mFullConfig = fullConfig;
            this.mConfigToAdd = configToAdd;
            this.mConfigToRemove = configToRemove;
            this.mOperateOnNewObjects = operateOnNewObjects;
            this.mId = id;
        }

        @Override
        public void handleEvent(oracle.dms.event.Event event) {
            if (this.mOperateOnNewObjects) {
                if (event.getActionType() == EventActionType.CREATE) {
                    switch (event.getSourceType()) {
                        case EVENT_SENSOR: 
                        case PHASE_SENSOR: {
                            this.mConfigManager.processNewSensor((Sensor)event.getSource(), this.mFullConfig);
                            break;
                        }
                        case NOUN: {
                            this.mConfigManager.processNewOrExistingNoun((Noun)event.getSource(), this.mFullConfig);
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (event.getActionType() == EventActionType.CREATE) {
                switch (event.getSourceType()) {
                    case EVENT_SENSOR: 
                    case PHASE_SENSOR: {
                        break;
                    }
                    case NOUN: {
                        Sensor[] sensors;
                        NounDescriptor nd;
                        Noun noun = (Noun)event.getSource();
                        if (noun == null || (nd = noun.getDescriptor()) == null) break;
                        this.mConfigManager.processNewOrExistingNoun(noun, this.mFullConfig);
                        for (Sensor sensor : sensors = noun.getSensors()) {
                            if (!(sensor instanceof PhaseEvent) && !(sensor instanceof Event)) continue;
                            this.mConfigManager.processExistingSensor(sensor, this.mFullConfig, this.mConfigToAdd, this.mConfigToRemove);
                        }
                        break;
                    }
                }
            }
        }

        @Override
        public boolean needsContext() {
            return false;
        }

        @Override
        public void initDestination() {
        }

        @Override
        public void shutdownDestination() {
        }

        @Override
        public String getId() {
            return this.mId;
        }

        @Override
        public String getName() {
            return this.mId;
        }

        @Override
        public void validate(Set<Validatable.ValidationLevel> validationLevels) {
        }

        @Override
        public EventType[] getEventTypesOfInterest() {
            return this.sEventTypes;
        }
    }

    private static class DescriptorAndValueConfigTuple<T extends ParameterDescriptor> {
        private final Set<String> mValueSet;
        private final String mDefaultValue;
        private final T mParameterDescriptor;
        private final int mMaxValueSetSize;

        DescriptorAndValueConfigTuple(T paramDescriptor, ParameterValueConfigImpl valueConfig) {
            this.mParameterDescriptor = paramDescriptor;
            if (valueConfig.getValueSet() != null && valueConfig.getValueSet().size() > 0) {
                this.mValueSet = new HashSet<String>(valueConfig.getValueSet().size(), 1.0f);
                this.mValueSet.addAll(valueConfig.mValueSet);
            } else {
                this.mValueSet = null;
            }
            this.mDefaultValue = valueConfig.mDefaultValue;
            this.mMaxValueSetSize = valueConfig.mMaxSizeOfSet;
        }

        public T getParameterDescriptor() {
            return this.mParameterDescriptor;
        }

        public Set<String> getValueSet() {
            return this.mValueSet;
        }

        public String getDefaultValue() {
            return this.mDefaultValue;
        }

        public int getMaxValueSetSize() {
            return this.mMaxValueSetSize;
        }
    }

    static class ParamScopedMetricsConfigManagerImpl
    implements ParamScopedMetricsConfigManager {
        private volatile ProposedParamScopedMetricsConfig mProposedConfig;
        private volatile ValidParamScopedMetricsConfig mValidConfig;
        private static final String FILTER_ID = "$ParamScopedMetricsSystem.Filter";
        private static final String DESTINATION_ID = "$ParamScopedMetricsSystem.Destination";
        private ParamDescriptorListenerImpl mContextParameterListener = null;

        ParamScopedMetricsConfigManagerImpl() {
        }

        synchronized void activateConfiguration(ParamScopedMetricsConfig newProposedConfig) {
            this.deregisterParameterDescriptorListener();
            if (newProposedConfig == null || newProposedConfig.isEmpty()) {
                this.mProposedConfig = null;
                this.mValidConfig = null;
                ParamScopedMetricsSystem.clearRuntimeManager();
                this.activateConfigForNewObjects(null);
                this.activateConfigForCurrentObjects(null, null);
            } else {
                this.mProposedConfig = (ProposedParamScopedMetricsConfig)newProposedConfig;
                ValidParamScopedMetricsConfig newValidConfig = this.mProposedConfig.deriveValidConfiguration();
                this.activateConfigForNewObjects(newValidConfig);
                this.activateConfigForCurrentObjects(this.mValidConfig, newValidConfig);
                this.mValidConfig = newValidConfig;
                this.registerParameterListener(new ParamDescriptorListenerImpl(this));
                ParamScopedMetricsSystem.setRuntimeManager();
            }
        }

        synchronized void reactivateProposedConfig(boolean applyToNewObjects, boolean applyToExistingObjects) {
            if (this.mProposedConfig != null) {
                ValidParamScopedMetricsConfig newValidConfig = this.mProposedConfig.deriveValidConfiguration();
                if (applyToNewObjects) {
                    this.activateConfigForNewObjects(newValidConfig);
                }
                if (applyToExistingObjects) {
                    this.activateConfigForCurrentObjects(this.mValidConfig, newValidConfig);
                }
                this.mValidConfig = newValidConfig;
                ParamScopedMetricsSystem.setRuntimeManager();
            }
        }

        private void activateConfigForNewObjects(ValidParamScopedMetricsConfig newConfig) {
            if (newConfig == null) {
                EventSystem.getEventConfigManager().disassociateFilterAndDestination(FILTER_ID, DESTINATION_ID);
            } else {
                DMSEventDestination d = new DMSEventDestination(this, newConfig, null, null, true, DESTINATION_ID);
                NullFilterWithEventTypeProxy f = new NullFilterWithEventTypeProxy(FILTER_ID, FILTER_ID, d);
                EventSystem.getEventConfigManager().associateInternalFilterWithDestination(f, d);
            }
        }

        private void activateConfigForCurrentObjects(ValidParamScopedMetricsConfig oldConfig, ValidParamScopedMetricsConfig newConfig) {
            DMSEventDestination d = null;
            if (newConfig == null) {
                d = new DMSEventDestination(this, null, null, null, false, "$ParamScopedMetricsSystem.DisablingDestination");
            } else if (oldConfig == null) {
                d = new DMSEventDestination(this, newConfig, newConfig, null, false, "$ParamScopedMetricsSystem.NewConfigDestination");
            } else {
                ValidParamScopedMetricsConfig[] configs = ValidParamScopedMetricsConfig.diff(newConfig, oldConfig);
                d = new DMSEventDestination(this, newConfig, configs[0], configs[2], false, "$ParamScopedMetricsSystem.DiffConfigDestination");
            }
            NounLifecycleWalker nlfw = new NounLifecycleWalker(d);
            nlfw.walk(Noun.getRoot());
        }

        void processNewSensor(Sensor sensor, ValidParamScopedMetricsConfig config) {
            NounDescriptor nd;
            if (sensor != null && sensor.getParent() != null && (nd = sensor.getParent().getDescriptor()) != null) {
                if (config == null) {
                    sensor.setClientObject(SCOPED_SENSOR_DATA_CLIENT_KEY, null);
                } else {
                    NounDescriptorScopedMetricsConfig configForNounDesc = (NounDescriptorScopedMetricsConfig)nd.getClientObject(NOUN_DESCRIPTOR_CLIENT_OBJECT_KEY);
                    if (configForNounDesc != null) {
                        Set<DescriptorAndValueConfigTuple<? extends ParameterDescriptor>> allParamConfig = configForNounDesc.getAllParamConfig();
                        HashMap sco = new HashMap(allParamConfig.size(), 1.0f);
                        for (DescriptorAndValueConfigTuple<? extends ParameterDescriptor> davt : allParamConfig) {
                            int mapSize = 16;
                            float mapCapacity = 0.75f;
                            if (davt.getValueSet() != null && davt.getValueSet().size() > 0) {
                                mapSize = davt.getValueSet().size();
                                mapCapacity = 1.0f;
                                if (((DescriptorAndValueConfigTuple)davt).mDefaultValue != null) {
                                    ++mapSize;
                                }
                            }
                            ConcurrentHashMap mapForPerValueData = new ConcurrentHashMap(mapSize, mapCapacity);
                            sco.put(davt.getParameterDescriptor(), mapForPerValueData);
                        }
                        sensor.setClientObject(SCOPED_SENSOR_DATA_CLIENT_KEY, sco);
                    } else {
                        sensor.setClientObject(SCOPED_SENSOR_DATA_CLIENT_KEY, null);
                    }
                }
            }
        }

        void processNewOrExistingNounDescriptor(NounDescriptor nd, ValidParamScopedMetricsConfig config) {
            if (nd != null) {
                String nounType = nd.getName();
                if (config == null) {
                    nd.setClientObject(NOUN_DESCRIPTOR_CLIENT_OBJECT_KEY, null);
                } else if (!config.hasProcessedNounType(nounType)) {
                    Set<DescriptorAndValueConfigTuple<ActivationParameterDescriptor>> actParamConfigForNounType = config.getValidParamConfigForNounType(nounType, ActivationParameterDescriptor.class);
                    Set<DescriptorAndValueConfigTuple<ContextParameterDescriptor>> ctxParamConfigForNounType = config.getValidParamConfigForNounType(nounType, ContextParameterDescriptor.class);
                    if (actParamConfigForNounType != null || ctxParamConfigForNounType != null) {
                        NounDescriptorScopedMetricsConfig newConfigForNounDesc = new NounDescriptorScopedMetricsConfig(actParamConfigForNounType, ctxParamConfigForNounType);
                        nd.setClientObject(NOUN_DESCRIPTOR_CLIENT_OBJECT_KEY, newConfigForNounDesc);
                    }
                    config.addProcessedNounType(nounType);
                }
            }
        }

        void processNewOrExistingNoun(Noun noun, ValidParamScopedMetricsConfig config) {
            NounDescriptor nd;
            if (noun != null && (nd = noun.getDescriptor()) != null) {
                this.processNewOrExistingNounDescriptor(nd, config);
            }
        }

        void processExistingSensor(Sensor sensor, ValidParamScopedMetricsConfig fullConfig, ValidParamScopedMetricsConfig configToAdd, ValidParamScopedMetricsConfig configToRemove) {
            NounDescriptor nd;
            if (sensor != null && sensor.getParent() != null && (nd = sensor.getParent().getDescriptor()) != null) {
                String nounType = nd.getName();
                NounDescriptorScopedMetricsConfig configForNounDesc = (NounDescriptorScopedMetricsConfig)nd.getClientObject(NOUN_DESCRIPTOR_CLIENT_OBJECT_KEY);
                if (configForNounDesc != null) {
                    Map originalSco = (Map)sensor.getClientObject(SCOPED_SENSOR_DATA_CLIENT_KEY);
                    HashMap newSco = new HashMap();
                    if (originalSco != null) {
                        newSco.putAll(originalSco);
                    }
                    if (configToRemove != null && !configToRemove.isEmpty() && configToRemove.getValidParamDescToValueConfigMap(nounType) != null) {
                        Set<ParameterDescriptor> paramDescSet = configToRemove.getValidParamDescToValueConfigMap(nounType).keySet();
                        ParamScopedMetricsConfigManagerImpl.removeMapEntriesByParameterDescriptor(paramDescSet, newSco);
                    }
                    if (configToAdd != null && !configToAdd.isEmpty() && configToAdd.getValidParamDescToValueConfigMap(nounType) != null) {
                        Map<ParameterDescriptor, ParameterValueConfigImpl> descriptorsToAdd = configToAdd.getValidParamDescToValueConfigMap(nounType);
                        Set<DescriptorAndValueConfigTuple<? extends ParameterDescriptor>> allParamConfigFromNounType = configForNounDesc.getAllParamConfig();
                        for (DescriptorAndValueConfigTuple<? extends ParameterDescriptor> davt : allParamConfigFromNounType) {
                            ParameterValueConfigImpl descriptorToAdd = descriptorsToAdd.get(davt.getParameterDescriptor());
                            if (descriptorToAdd == null) continue;
                            int mapSize = 16;
                            float mapCapacity = 0.75f;
                            if (davt.getValueSet() != null && davt.getValueSet().size() > 0) {
                                mapSize = davt.getValueSet().size();
                                mapCapacity = 1.0f;
                                if (((DescriptorAndValueConfigTuple)davt).mDefaultValue != null) {
                                    ++mapSize;
                                }
                            }
                            ConcurrentHashMap mapForPerValueData = new ConcurrentHashMap(mapSize, mapCapacity);
                            newSco.put(davt.getParameterDescriptor(), mapForPerValueData);
                        }
                    }
                    sensor.setClientObject(SCOPED_SENSOR_DATA_CLIENT_KEY, newSco);
                } else {
                    sensor.setClientObject(SCOPED_SENSOR_DATA_CLIENT_KEY, null);
                }
            }
        }

        static <T> void removeMapEntriesByParameterDescriptor(Set<ParameterDescriptor> paramDescSet, Map<ParameterDescriptor, T> map) {
            if (paramDescSet != null && map != null) {
                for (ParameterDescriptor paramValCfgTup : paramDescSet) {
                    map.remove(paramValCfgTup);
                }
            }
        }

        @Override
        public ParamScopedMetricsConfig getCurrentConfiguration() {
            return this.mProposedConfig;
        }

        private void registerParameterListener(ParamDescriptorListenerImpl listener) {
            this.deregisterParameterDescriptorListener();
            this.mContextParameterListener = listener;
            if (this.mContextParameterListener != null) {
                ActivationParameterFactory afactory;
                ContextParameterFactory factory = DMSContextManager.getContextParameterFactory();
                if (factory instanceof ContextParameterFactoryImpl) {
                    ((ContextParameterFactoryImpl)factory).registerListener(this.mContextParameterListener, false);
                }
                if ((afactory = DMSConsole.getActivationParameterFactory()) instanceof ActivationParameterFactoryImpl) {
                    ((ActivationParameterFactoryImpl)afactory).registerListener(this.mContextParameterListener);
                }
            }
        }

        private void deregisterParameterDescriptorListener() {
            if (this.mContextParameterListener != null) {
                ActivationParameterFactory afactory;
                ContextParameterFactory cfactory = DMSContextManager.getContextParameterFactory();
                if (cfactory instanceof ContextParameterFactoryImpl) {
                    ((ContextParameterFactoryImpl)cfactory).deregisterListener(this.mContextParameterListener);
                }
                if ((afactory = DMSConsole.getActivationParameterFactory()) instanceof ActivationParameterFactoryImpl) {
                    ((ActivationParameterFactoryImpl)afactory).deregisterListener(this.mContextParameterListener);
                }
                this.mContextParameterListener = null;
            }
        }
    }

    static class NounDescriptorScopedMetricsConfig {
        private final DescriptorAndValueConfigTuple<ActivationParameterDescriptor>[] mActParamTuples;
        private final DescriptorAndValueConfigTuple<ContextParameterDescriptor>[] mCtxParamTuples;
        private final int mNumTuples;

        NounDescriptorScopedMetricsConfig(Set<DescriptorAndValueConfigTuple<ActivationParameterDescriptor>> actParamTuples, Set<DescriptorAndValueConfigTuple<ContextParameterDescriptor>> ctxParamTuples) {
            int numTuples = 0;
            if (actParamTuples != null && actParamTuples.size() > 0) {
                this.mActParamTuples = actParamTuples.toArray(new DescriptorAndValueConfigTuple[actParamTuples.size()]);
                numTuples += actParamTuples.size();
            } else {
                this.mActParamTuples = null;
            }
            if (ctxParamTuples != null && ctxParamTuples.size() > 0) {
                this.mCtxParamTuples = ctxParamTuples.toArray(new DescriptorAndValueConfigTuple[ctxParamTuples.size()]);
                numTuples += ctxParamTuples.size();
            } else {
                this.mCtxParamTuples = null;
            }
            this.mNumTuples = numTuples;
        }

        DescriptorAndValueConfigTuple<ActivationParameterDescriptor>[] getActParamConfig() {
            return this.mActParamTuples;
        }

        DescriptorAndValueConfigTuple<ContextParameterDescriptor>[] getCtxParamConfig() {
            return this.mCtxParamTuples;
        }

        Set<DescriptorAndValueConfigTuple<? extends ParameterDescriptor>> getAllParamConfig() {
            HashSet<DescriptorAndValueConfigTuple<? extends ParameterDescriptor>> retVal = new HashSet<DescriptorAndValueConfigTuple<? extends ParameterDescriptor>>(this.mNumTuples, 1.0f);
            if (this.mActParamTuples != null && this.mActParamTuples.length > 0) {
                for (DescriptorAndValueConfigTuple<ParameterDescriptor> descriptorAndValueConfigTuple : this.mActParamTuples) {
                    retVal.add(descriptorAndValueConfigTuple);
                }
            }
            if (this.mCtxParamTuples != null && this.mCtxParamTuples.length > 0) {
                for (DescriptorAndValueConfigTuple<ParameterDescriptor> descriptorAndValueConfigTuple : this.mCtxParamTuples) {
                    retVal.add(descriptorAndValueConfigTuple);
                }
            }
            return retVal;
        }
    }

    static class ParamScopedMetricsRuntimeManagerImpl
    implements ParamScopedMetricsRuntimeManager {
        ParamScopedMetricsRuntimeManagerImpl() {
        }

        private NounDescriptorScopedMetricsConfig getScopedMetricConfigForSensor(Sensor sensor) {
            NounDescriptorScopedMetricsConfig retVal = null;
            if (sensor != null && sensor.getParent() != null && sensor.getParent().getDescriptor() != null) {
                NounDescriptor nounDescriptor = sensor.getParent().getDescriptor();
                retVal = (NounDescriptorScopedMetricsConfig)nounDescriptor.getClientObject(NOUN_DESCRIPTOR_CLIENT_OBJECT_KEY);
            }
            return retVal;
        }

        @Override
        public void handleEventSensorUpdate(Event eventSensor, long updateTimeStamp, ActivationParameter[] actParams) {
            NounDescriptorScopedMetricsConfig nounDescriptorScopedMetricsConfig = this.getScopedMetricConfigForSensor(eventSensor);
            if (nounDescriptorScopedMetricsConfig != null) {
                ExecutionContext ctx;
                if (nounDescriptorScopedMetricsConfig.getActParamConfig() != null && actParams != null) {
                    for (ActivationParameter actParam : actParams) {
                        if (actParam == null) continue;
                        for (DescriptorAndValueConfigTuple<ActivationParameterDescriptor> davt : nounDescriptorScopedMetricsConfig.getActParamConfig()) {
                            String actValue;
                            EventSensorCoreData ecd;
                            if (davt.getParameterDescriptor() != actParam.getDescriptor() || (ecd = this.findCoreData(davt, eventSensor, actValue = actParam.getValue(), EventSensorCoreData.class)) == null) continue;
                            ecd.occurred(updateTimeStamp);
                        }
                    }
                }
                if (nounDescriptorScopedMetricsConfig.getCtxParamConfig() != null && (ctx = DMSContextManager.getActiveContext()) != null) {
                    for (DescriptorAndValueConfigTuple<ContextParameterDescriptor> davt : nounDescriptorScopedMetricsConfig.getCtxParamConfig()) {
                        String ctxValue = ctx.getValue(davt.getParameterDescriptor().getName());
                        EventSensorCoreData ecd = this.findCoreData(davt, eventSensor, ctxValue, EventSensorCoreData.class);
                        if (ecd == null) continue;
                        ecd.occurred(updateTimeStamp);
                    }
                }
            }
        }

        @Override
        public void handlePhaseSensorStop(PhaseEvent phaseSensor, boolean wasStartedAnonymously, long updateTimeStamp, long phaseDuration, ActivationParameter[] actParams) {
            NounDescriptorScopedMetricsConfig nounDescriptorScopedMetricsConfig = this.getScopedMetricConfigForSensor(phaseSensor);
            if (nounDescriptorScopedMetricsConfig != null) {
                ExecutionContext ctx;
                if (nounDescriptorScopedMetricsConfig.getActParamConfig() != null && actParams != null) {
                    for (ActivationParameter actParam : actParams) {
                        if (actParam == null) continue;
                        for (DescriptorAndValueConfigTuple<ActivationParameterDescriptor> davt : nounDescriptorScopedMetricsConfig.getActParamConfig()) {
                            String actValue;
                            PhaseSensorCoreData pcd;
                            if (davt.getParameterDescriptor() != actParam.getDescriptor() || (pcd = this.findCoreData(davt, phaseSensor, actValue = actParam.getValue(), PhaseSensorCoreData.class)) == null) continue;
                            pcd.stop(wasStartedAnonymously, updateTimeStamp, phaseDuration);
                        }
                    }
                }
                if (nounDescriptorScopedMetricsConfig.getCtxParamConfig() != null && (ctx = DMSContextManager.getActiveContext()) != null) {
                    for (DescriptorAndValueConfigTuple<ContextParameterDescriptor> davt : nounDescriptorScopedMetricsConfig.getCtxParamConfig()) {
                        String ctxValue = ctx.getValue(davt.getParameterDescriptor().getName());
                        PhaseSensorCoreData pcd = this.findCoreData(davt, phaseSensor, ctxValue, PhaseSensorCoreData.class);
                        if (pcd == null) continue;
                        pcd.stop(wasStartedAnonymously, updateTimeStamp, phaseDuration);
                    }
                }
            }
        }

        @Override
        public void handlePhaseSensorStart(PhaseEvent phaseSensor, long updateTimeStamp, ActivationParameter[] actParams) {
            NounDescriptorScopedMetricsConfig nounDescriptorScopedMetricsConfig = this.getScopedMetricConfigForSensor(phaseSensor);
            if (nounDescriptorScopedMetricsConfig != null) {
                ExecutionContext ctx;
                if (nounDescriptorScopedMetricsConfig.getActParamConfig() != null && actParams != null) {
                    for (ActivationParameter actParam : actParams) {
                        if (actParam == null) continue;
                        for (DescriptorAndValueConfigTuple<ActivationParameterDescriptor> davt : nounDescriptorScopedMetricsConfig.getActParamConfig()) {
                            String actValue;
                            PhaseSensorCoreData pcd;
                            if (davt.getParameterDescriptor() != actParam.getDescriptor() || (pcd = this.findCoreData(davt, phaseSensor, actValue = actParam.getValue(), PhaseSensorCoreData.class)) == null) continue;
                            pcd.start(updateTimeStamp);
                        }
                    }
                }
                if (nounDescriptorScopedMetricsConfig.getCtxParamConfig() != null && (ctx = DMSContextManager.getActiveContext()) != null) {
                    for (DescriptorAndValueConfigTuple<ContextParameterDescriptor> davt : nounDescriptorScopedMetricsConfig.getCtxParamConfig()) {
                        String ctxValue = ctx.getValue(davt.getParameterDescriptor().getName());
                        PhaseSensorCoreData pcd = this.findCoreData(davt, phaseSensor, ctxValue, PhaseSensorCoreData.class);
                        if (pcd == null) continue;
                        pcd.start(updateTimeStamp);
                    }
                }
            }
        }

        private <T extends SensorCoreData> T findCoreData(DescriptorAndValueConfigTuple davt, Sensor sensor, String paramValue, Class<T> coreDataClass) {
            Map thisParamsMap;
            Map allParamsMap;
            Set<String> valueSet;
            SensorCoreData retVal = null;
            if (paramValue == null) {
                paramValue = davt.getDefaultValue();
            }
            if (paramValue != null && ((valueSet = davt.getValueSet()) != null && valueSet.contains(paramValue) || valueSet == null) && (allParamsMap = (Map)sensor.getClientObject(SCOPED_SENSOR_DATA_CLIENT_KEY)) != null && (thisParamsMap = (Map)allParamsMap.get(davt.getParameterDescriptor())) != null && (retVal = (SensorCoreData)thisParamsMap.get(paramValue)) == null && (thisParamsMap.size() < davt.getMaxValueSetSize() || davt.getMaxValueSetSize() == -2)) {
                try {
                    retVal = (SensorCoreData)coreDataClass.newInstance();
                    thisParamsMap.put(paramValue, retVal);
                }
                catch (InstantiationException ie) {
                }
                catch (IllegalAccessException iae) {
                    // empty catch block
                }
            }
            return (T)retVal;
        }

        @Override
        public Map<ParameterDescriptor, Map<String, SensorCoreData>> getAllParameterScopedDataForSensor(Sensor sensor) {
            Map retVal = null;
            retVal = (Map)sensor.getClientObject(SCOPED_SENSOR_DATA_CLIENT_KEY);
            return retVal;
        }

        @Override
        public Set<ParameterDescriptor> getParameterDescriptors(String nounType) {
            Map<String, ? extends ParamScopedMetricsConfig.ParameterValueConfig> ctxParamConfig;
            HashSet<ParameterDescriptor> retVal = new HashSet<ParameterDescriptor>();
            ParameterDescriptor pd = null;
            ParamScopedMetricsConfig config = ParamScopedMetricsSystem.getConfigManager().getCurrentConfiguration();
            Map<String, ? extends ParamScopedMetricsConfig.ParameterValueConfig> actParamConfig = config.getActParamConfigForNounType(nounType);
            if (actParamConfig != null && actParamConfig.size() > 0) {
                for (String parameterName : actParamConfig.keySet()) {
                    pd = DMSConsole.getActivationParameterFactory().findDescriptor(parameterName);
                    if (pd == null) continue;
                    retVal.add(pd);
                }
            }
            if ((ctxParamConfig = config.getCtxParamConfigForNounType(nounType)) != null && ctxParamConfig.size() > 0) {
                for (String parameterName : ctxParamConfig.keySet()) {
                    pd = DMSContextManager.getDomainContextManager().findContextParameterDescriptor(parameterName);
                    if (pd == null) continue;
                    retVal.add(pd);
                }
            }
            if (retVal.size() == 0) {
                retVal = null;
            }
            return retVal;
        }

        @Override
        public Set<String> getParameterValues(String nounType, String parameterName, Class<? extends ParameterDescriptor> descriptorClass) {
            ParamScopedMetricsConfig config;
            Set<String> retVal = null;
            ParameterDescriptor pd = null;
            Map<String, ? extends ParamScopedMetricsConfig.ParameterValueConfig> param2paramConfigMap = null;
            if (descriptorClass == ActivationParameterDescriptor.class) {
                pd = DMSConsole.getActivationParameterFactory().findDescriptor(parameterName);
            }
            if (descriptorClass == ContextParameterDescriptor.class) {
                pd = DMSContextManager.getDomainContextManager().findContextParameterDescriptor(parameterName);
            }
            if (pd != null && (config = ParamScopedMetricsSystem.getConfigManager().getCurrentConfiguration()) != null) {
                ParamScopedMetricsConfig.ParameterValueConfig pvc;
                if (descriptorClass == ActivationParameterDescriptor.class) {
                    param2paramConfigMap = config.getActParamConfigForNounType(nounType);
                }
                if (descriptorClass == ContextParameterDescriptor.class) {
                    param2paramConfigMap = config.getCtxParamConfigForNounType(nounType);
                }
                if (param2paramConfigMap != null && (pvc = param2paramConfigMap.get(parameterName)) != null) {
                    if (pvc.getValueSet() != null) {
                        retVal = pvc.getValueSet();
                    }
                    if (retVal == null && pd.getValueSet() != null) {
                        retVal = pd.getValueSet();
                    }
                    if (retVal == null) {
                        retVal = this.findParameterValuesForNounType(pd, nounType);
                    }
                }
            }
            return retVal;
        }

        private Set<String> findParameterValuesForNounType(ParameterDescriptor pd, String nounType) {
            HashSet<String> retVal = null;
            Noun[] nouns = Noun.getNounsByType(nounType);
            if (nouns != null) {
                for (Noun noun : nouns) {
                    Sensor[] sensors = noun.getSensors();
                    if (sensors == null) continue;
                    for (Sensor sensor : sensors) {
                        Map<String, SensorCoreData> values2CoreDataMap;
                        Map<ParameterDescriptor, Map<String, SensorCoreData>> allCoreData = this.getAllParameterScopedDataForSensor(sensor);
                        if (allCoreData == null || (values2CoreDataMap = allCoreData.get(pd)) == null || values2CoreDataMap.size() <= 0) continue;
                        if (retVal == null) {
                            retVal = new HashSet<String>();
                        }
                        retVal.addAll(values2CoreDataMap.keySet());
                    }
                }
            }
            return retVal;
        }
    }
}

