/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.trace2.runtime;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.ODLTextFormatter;
import oracle.core.ojdl.logging.ODLHandler;
import oracle.core.ojdl.logging.ODLLogRecord;
import oracle.core.ojdl.logging.context.LoggingContext;
import oracle.core.ojdl.logging.impl.DMSLoggingContext;
import oracle.dms.event.Event;
import oracle.dms.event.EventResourceBundle;
import oracle.dms.event.LoadableDestination;
import oracle.dms.event.config.DestinationDescription;
import oracle.dms.event.config.DestinationProperty;
import oracle.dms.event.config.EventConfigException;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.Platform;
import oracle.dms.util.PlatformSupport;
import oracle.dms.util.PlatformSupportFactory;
import oracle.dms.util.Validatable;
import oracle.dms.util.ValidationException;

@DestinationDescription(nlsDescriptionResourceBundle="oracle.dms.event.EventResourceBundle", nlsDescriptionID="LOGGER_DESTINATION")
public class LoggerDestination
implements LoadableDestination {
    private Logger mTraceLogger = null;
    private Logger mDiagLogger = Logger.getLogger(DIAG_LOGGER_NAME, EventResourceBundle.class.getName());
    private String mName;
    private String mId;
    private Map mODLSupplementalAttributes = null;
    private static final String CLASS_NAME = LoggerDestination.class.getName();
    private static final String ENCODING = "UTF-8";
    private static String DIAG_LOGGER_NAME = "oracle.dms.event";
    private static final long MAXFILESIZE = 0xA00000L;
    private static final long MAXLOGSIZE = 0xA00000L;

    @Override
    public void handleEvent(Event event) {
        if (this.mTraceLogger != null && event != null) {
            ODLLogRecord logRecord = new ODLLogRecord(Level.FINER, event.toString());
            this.mODLSupplementalAttributes.put("EventTime", event.getTime());
            logRecord.setSupplAttributes(this.mODLSupplementalAttributes);
            DMSLoggingContext ctx = new DMSLoggingContext(event.getExecutionContext());
            logRecord.setLoggingContext((LoggingContext)ctx);
            logRecord.setLoggerName(this.mTraceLogger.getName());
            this.mTraceLogger.log((LogRecord)logRecord);
        }
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public void setId(String id) {
        this.mId = id;
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @DestinationProperty(isMandatory=true)
    public void setLoggerName(String loggerName) throws EventConfigException {
        String METHOD_NAME = "setLoggerName";
        String path = this.getLoggerPath(loggerName);
        if (path != null) {
            this.mTraceLogger = Logger.getLogger(loggerName);
            Handler[] handlers = this.mTraceLogger.getHandlers();
            if (handlers.length == 0) {
                this.mTraceLogger.setUseParentHandlers(false);
                ODLHandler handler = new ODLHandler((LogFormatter)new ODLTextFormatter(), path, 0xA00000L, 0xA00000L, ENCODING);
                handler.setUseSourceClassAndMethod(Level.ALL);
                handler.setLevel(Level.FINER);
                this.mTraceLogger.addHandler((Handler)handler);
                this.mTraceLogger.setLevel(Level.FINER);
                String diagLogMessage = "No handlers found for logger " + loggerName + ", so added a new ODLHandler with path=" + path;
                this.mDiagLogger.logp(Level.FINE, CLASS_NAME, "setLoggerName", diagLogMessage);
                this.mODLSupplementalAttributes = new HashMap(1);
            } else if (this.mTraceLogger != null) {
                this.mODLSupplementalAttributes = new HashMap(1);
                String diagLogMessage = "At least one hndler already exists logger " + loggerName + ", so will not create a new one";
                this.mDiagLogger.logp(Level.FINE, CLASS_NAME, "setLoggerName", diagLogMessage);
            }
        } else {
            String msg = "The trace log path " + path + " is unknown for logger " + loggerName + ", cannot log trace messages.";
            this.mDiagLogger.logp(Level.FINE, CLASS_NAME, "setLoggerName", msg);
            throw new EventConfigException(msg);
        }
    }

    @Override
    public boolean needsContext() {
        return true;
    }

    public String getLoggerPath(String loggerName) {
        String METHOD_NAME = "getLoggerPath";
        String FILE_EXTENSION = "-event.log";
        PlatformSupport platformSupport = PlatformSupportFactory.getPlatformSupport();
        Platform platform = platformSupport.getPlatform();
        String path = null;
        switch (platform) {
            case Default: {
                path = "." + File.separator + loggerName + "-event.log";
                break;
            }
            case Junit: {
                path = DMSProperties.getProperty("oracle.instance") + File.separator + loggerName + "-event.log";
                break;
            }
            case WebSphere: 
            case WebSphereAS: 
            case WebSphereND: 
            case WebLogic: {
                try {
                    path = platformSupport.getServerLogPath() + File.separator + loggerName + "-event.log";
                }
                catch (Exception e) {
                    String msg = "The platform " + (Object)((Object)platform) + " cannot be determined." + "Cannot derive the event log path.";
                    this.mDiagLogger.logp(Level.FINE, CLASS_NAME, "getLoggerPath", msg);
                }
                break;
            }
            case WebLogicAS: {
                String logDir = platformSupport.getServerLogPath();
                if (logDir != null) {
                    path = logDir + File.separator + loggerName + "-event.log";
                    break;
                }
                if (!this.mDiagLogger.isLoggable(Level.FINE)) break;
                String msg = "Cannot derive the event log path for platform " + (Object)((Object)platform);
                this.mDiagLogger.logp(Level.FINE, CLASS_NAME, "getLoggerPath", msg);
                break;
            }
            default: {
                String msg = "The platform " + (Object)((Object)platform) + " cannot be determined." + "Cannot derive the event log path.";
                this.mDiagLogger.logp(Level.FINE, CLASS_NAME, "getLoggerPath", msg);
            }
        }
        return path;
    }

    @Override
    public void initDestination() {
    }

    @Override
    public void shutdownDestination() {
    }

    @Override
    public void validate(Set<Validatable.ValidationLevel> validationLevels) throws ValidationException {
    }
}

