/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.trace2.runtime;

import java.util.StringTokenizer;
import oracle.dms.event.config.NounTypeOpType;
import oracle.dms.trace2.runtime.DataType;

public enum OpType {
    LT{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            boolean retVal = false;
            if (contextValue != null && configParam != null) {
                if (dataType == null) {
                    dataType = DataType.STRING;
                }
                Comparable v1 = null;
                Comparable v2 = null;
                if (dataType == DataType.STRING && ignorecase) {
                    v1 = dataType.getComparable(contextValue.toLowerCase());
                    v2 = dataType.getComparable(configParam.toLowerCase());
                } else {
                    v1 = dataType.getComparable(contextValue);
                    v2 = dataType.getComparable(configParam);
                }
                if (v1 != null && v2 != null) {
                    retVal = v1.compareTo(v2) < 0;
                }
            }
            return retVal;
        }
    }
    ,
    GT{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            boolean retVal = false;
            if (contextValue != null && configParam != null) {
                if (dataType == null) {
                    dataType = DataType.STRING;
                }
                Comparable v1 = null;
                Comparable v2 = null;
                if (dataType == DataType.STRING && ignorecase) {
                    v1 = dataType.getComparable(contextValue.toLowerCase());
                    v2 = dataType.getComparable(configParam.toLowerCase());
                } else {
                    v1 = dataType.getComparable(contextValue);
                    v2 = dataType.getComparable(configParam);
                }
                if (v1 != null && v2 != null) {
                    retVal = v1.compareTo(v2) > 0;
                }
            }
            return retVal;
        }
    }
    ,
    LE{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            boolean retVal = false;
            if (contextValue != null && configParam != null) {
                if (dataType == null) {
                    dataType = DataType.STRING;
                }
                Comparable v1 = null;
                Comparable v2 = null;
                if (dataType == DataType.STRING && ignorecase) {
                    v1 = dataType.getComparable(contextValue.toLowerCase());
                    v2 = dataType.getComparable(configParam.toLowerCase());
                } else {
                    v1 = dataType.getComparable(contextValue);
                    v2 = dataType.getComparable(configParam);
                }
                if (v1 != null && v2 != null) {
                    retVal = v1.compareTo(v2) <= 0;
                }
            }
            return retVal;
        }
    }
    ,
    GE{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            boolean retVal = false;
            if (contextValue != null && configParam != null) {
                if (dataType == null) {
                    dataType = DataType.STRING;
                }
                Comparable v1 = null;
                Comparable v2 = null;
                if (dataType == DataType.STRING && ignorecase) {
                    v1 = dataType.getComparable(contextValue.toLowerCase());
                    v2 = dataType.getComparable(configParam.toLowerCase());
                } else {
                    v1 = dataType.getComparable(contextValue);
                    v2 = dataType.getComparable(configParam);
                }
                if (v1 != null && v2 != null) {
                    retVal = v1.compareTo(v2) >= 0;
                }
            }
            return retVal;
        }
    }
    ,
    EQUALS{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            boolean retVal = false;
            Comparable v1 = null;
            Comparable v2 = null;
            if (dataType == null) {
                dataType = DataType.STRING;
            }
            if (dataType == DataType.STRING && contextValue != null && configParam != null) {
                if (ignorecase) {
                    v1 = dataType.getComparable(contextValue.toLowerCase());
                    v2 = dataType.getComparable(configParam.toLowerCase());
                } else {
                    v1 = dataType.getComparable(contextValue);
                    v2 = dataType.getComparable(configParam);
                }
            }
            if (dataType != DataType.STRING && contextValue != null && configParam != null) {
                v1 = dataType.getComparable(contextValue);
                v2 = dataType.getComparable(configParam);
            }
            if (v1 != null && v2 != null) {
                retVal = v1.compareTo(v2) == 0;
            }
            return retVal;
        }
    }
    ,
    EQ{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            return EQUALS.applyOperation(contextValue, configParam, dataType, ignorecase);
        }
    }
    ,
    STARTS_WITH{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            boolean retVal = false;
            if (dataType == null) {
                dataType = DataType.STRING;
            }
            if (dataType == DataType.STRING && contextValue != null && configParam != null) {
                retVal = ignorecase ? contextValue.toLowerCase().startsWith(configParam.toLowerCase()) : contextValue.startsWith(configParam);
            }
            return retVal;
        }
    }
    ,
    STARTSWITH{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            return STARTS_WITH.applyOperation(contextValue, configParam, dataType, ignorecase);
        }
    }
    ,
    SW{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            return STARTS_WITH.applyOperation(contextValue, configParam, dataType, ignorecase);
        }
    }
    ,
    CONTAINS{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            boolean retVal = false;
            if (dataType == null) {
                dataType = DataType.STRING;
            }
            if (dataType == DataType.STRING && contextValue != null && configParam != null) {
                retVal = ignorecase ? contextValue.toLowerCase().contains(configParam.toLowerCase()) : contextValue.contains(configParam);
            }
            return retVal;
        }
    }
    ,
    NOT_EQUALS{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            boolean retVal = false;
            if (dataType == null) {
                dataType = DataType.STRING;
            }
            if (dataType != DataType.STRING && contextValue != null && configParam != null || dataType == DataType.STRING) {
                Comparable v1 = null;
                Comparable v2 = null;
                if (dataType == DataType.STRING && ignorecase) {
                    v1 = dataType.getComparable(contextValue.toLowerCase());
                    v2 = dataType.getComparable(configParam.toLowerCase());
                } else {
                    v1 = dataType.getComparable(contextValue);
                    v2 = dataType.getComparable(configParam);
                }
                if (v1 != null && v2 != null) {
                    retVal = v1.compareTo(v2) != 0;
                }
            }
            return retVal;
        }
    }
    ,
    NOTEQUALS{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            return NOT_EQUALS.applyOperation(contextValue, configParam, dataType, ignorecase);
        }
    }
    ,
    NE{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            return NOT_EQUALS.applyOperation(contextValue, configParam, dataType, ignorecase);
        }
    }
    ,
    IS_NULL{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            return contextValue == null;
        }
    }
    ,
    ISNULL{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            return IS_NULL.applyOperation(contextValue, configParam, dataType, ignorecase);
        }
    }
    ,
    IS_NOT_NULL{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            return contextValue != null;
        }
    }
    ,
    ISNOTNULL{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            return IS_NOT_NULL.applyOperation(contextValue, configParam, dataType, ignorecase);
        }
    }
    ,
    IN{

        @Override
        public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
            boolean retVal = false;
            if (configParam != null) {
                StringTokenizer configParamParser = new StringTokenizer(configParam, ",");
                if (dataType == null) {
                    dataType = DataType.STRING;
                }
                Comparable v1 = null;
                v1 = dataType == DataType.STRING && ignorecase ? dataType.getComparable(contextValue.toLowerCase()) : dataType.getComparable(contextValue);
                while (configParamParser.hasMoreTokens()) {
                    Comparable v2 = null;
                    String nextToken = configParamParser.nextToken();
                    v2 = dataType == DataType.STRING && ignorecase && nextToken != null ? dataType.getComparable(nextToken.toLowerCase()) : dataType.getComparable(nextToken);
                    if (v1 == null || v2 == null || !(retVal = v1.compareTo(v2) == 0)) continue;
                    return retVal;
                }
            }
            return retVal;
        }
    };


    public boolean applyOperation(String contextValue, String configParam, DataType dataType, boolean ignorecase) {
        return false;
    }

    public static OpType decodeConfigOpType(oracle.dms.event.config.OpType opType) {
        switch (opType) {
            case CONTAINS: {
                return CONTAINS;
            }
            case EQ: 
            case EQUALS: {
                return EQUALS;
            }
            case IS_NULL: 
            case ISNULL: {
                return IS_NULL;
            }
            case ISNOTNULL: 
            case IS_NOT_NULL: {
                return IS_NOT_NULL;
            }
            case NOTEQUALS: 
            case NE: 
            case NOT_EQUALS: {
                return NOT_EQUALS;
            }
            case STARTSWITH: 
            case SW: 
            case STARTS_WITH: {
                return STARTS_WITH;
            }
            case LE: {
                return LE;
            }
            case GE: {
                return GE;
            }
            case LT: {
                return LT;
            }
            case GT: {
                return GT;
            }
            case IN: {
                return IN;
            }
        }
        return null;
    }

    public static OpType decodeConfigOpType(NounTypeOpType opType) {
        switch (opType) {
            case CONTAINS: {
                return CONTAINS;
            }
            case EQ: 
            case EQUALS: {
                return EQUALS;
            }
            case NOT_EQUALS: 
            case NE: 
            case NOTEQUALS: {
                return NOT_EQUALS;
            }
            case STARTS_WITH: 
            case STARTSWITH: 
            case SW: {
                return STARTS_WITH;
            }
        }
        return null;
    }
}

