/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Map;
import oracle.dms.util.NameValue;

public class JSONUtils {
    public static final char START_OBJECT = '{';
    public static final char END_OBJECT = '}';
    public static final char INTRA_NAME_VALUE_SEPARATOR = ':';
    public static final char INTER_NAME_VALUE_SEPARATOR = ',';
    public static final char INTRA_ARRAY_VALUE_SEPARATOR = ',';
    public static final char START_ARRAY = '[';
    public static final char END_ARRAY = ']';

    public static void appendName(StringBuilder sb, String name) {
        JSONUtils.escapeAndAppendString(sb, name);
    }

    public static void appendNameValuePair(StringBuilder sb, String name, Object value) {
        JSONUtils.appendName(sb, name);
        sb.append(':');
        JSONUtils.appendValue(sb, value);
    }

    public static void appendValue(StringBuilder sb, Object o) {
        if (o == null) {
            sb.append("null");
        } else if (o.getClass().isAnnotationPresent(JSONFormatToString.class)) {
            sb.append(o.toString());
        } else if (o instanceof Number) {
            sb.append(o);
        } else if (o instanceof Boolean) {
            if (((Boolean)o).booleanValue()) {
                sb.append("true");
            } else {
                sb.append("false");
            }
        } else if (o instanceof String) {
            JSONUtils.escapeAndAppendString(sb, (String)o);
        } else if (o instanceof NameValue) {
            NameValue nv = (NameValue)o;
            if (nv.getName() != null) {
                sb.append('{');
                JSONUtils.escapeAndAppendString(sb, nv.getName());
                sb.append(':');
                JSONUtils.appendValue(sb, nv.getValue());
                sb.append('}');
            }
        } else if (o instanceof Object[]) {
            Object[] arr = (Object[])o;
            boolean addComma = false;
            sb.append('[');
            for (Object a : arr) {
                if (addComma) {
                    sb.append(',');
                }
                addComma = true;
                JSONUtils.appendValue(sb, a);
            }
            sb.append(']');
        } else if (o instanceof Collection) {
            Collection collection = (Collection)o;
            boolean addComma = false;
            sb.append('[');
            for (Object a : collection) {
                if (addComma) {
                    sb.append(',');
                }
                addComma = true;
                JSONUtils.appendValue(sb, a);
            }
            sb.append(']');
        } else if (o instanceof Map) {
            sb.append('{');
            Map map = (Map)o;
            boolean appendComma = false;
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getKey() == null) continue;
                if (appendComma) {
                    sb.append(',');
                }
                JSONUtils.appendNameValuePair(sb, entry.getKey().toString(), entry.getValue());
                appendComma = true;
            }
            sb.append('}');
        } else {
            JSONUtils.escapeAndAppendString(sb, o.toString());
        }
    }

    private static void escapeAndAppendString(StringBuilder sb, String s) {
        if (s == null) {
            sb.append("null");
        } else {
            sb.append('\"');
            block10: for (int i = 0; i < s.length(); ++i) {
                char thisChar = s.charAt(i);
                switch (thisChar) {
                    case '\"': {
                        sb.append("\\\"");
                        continue block10;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        continue block10;
                    }
                    case '/': {
                        sb.append("\\/");
                        continue block10;
                    }
                    case '\b': {
                        sb.append("\\b");
                        continue block10;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block10;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block10;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block10;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block10;
                    }
                    default: {
                        sb.append(thisChar);
                    }
                }
            }
            sb.append('\"');
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface JSONFormatToString {
    }
}

