/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event.config;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import oracle.dms.event.config.AndCondition;
import oracle.dms.event.config.Condition;
import oracle.dms.event.config.ContextCondition;
import oracle.dms.event.config.DataType;
import oracle.dms.event.config.EventConfigException;
import oracle.dms.event.config.NestedCondition;
import oracle.dms.event.config.NounTypeCondition;
import oracle.dms.event.config.NounTypeOpType;
import oracle.dms.event.config.OpType;
import oracle.dms.event.config.OrCondition;

public class ConditionParser {
    private StreamTokenizer m_tokenizer;
    private String m_stringCondition;

    public Condition parse(String condition) throws IllegalArgumentException {
        this.m_stringCondition = condition;
        this.m_tokenizer = this.initTokenizer(condition);
        this.advance();
        try {
            return this.Q();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Parser Error: unable to parse condition \"" + this.m_stringCondition + "\"", e);
        }
    }

    private Condition Q() throws IllegalArgumentException {
        Condition c = this.E();
        if (this.hasMoreTokens()) {
            throw new IllegalArgumentException("Parser Error:  unrecognized token \"" + this.peek() + "\" at end of " + "condition \"" + this.m_stringCondition + "\"");
        }
        return c;
    }

    private Condition E() throws IllegalArgumentException {
        String t = this.peek();
        if (t == null) {
            return null;
        }
        if (t.equalsIgnoreCase("(")) {
            this.advance();
            NestedCondition c1 = new NestedCondition(this.E());
            t = this.peek();
            if (t == null) {
                throw new IllegalArgumentException("Parser Error: missing closing bracket for condition \"" + this.m_stringCondition + "\"");
            }
            if (!t.equalsIgnoreCase(")")) {
                throw new IllegalArgumentException("Parser Error: found \"" + t + "\" expected a closing bracket, for condition \"" + this.m_stringCondition + "\"");
            }
            this.advance();
            return this.E1(c1);
        }
        return this.E1(this.F());
    }

    private Condition E1(Condition op1) throws IllegalArgumentException {
        String t = this.peek();
        if (t == null) {
            return op1;
        }
        if (t.equalsIgnoreCase("and")) {
            this.advance();
            return this.E1(new AndCondition(op1, this.E()));
        }
        if (t.equalsIgnoreCase("or")) {
            this.advance();
            return this.E1(new OrCondition(op1, this.E()));
        }
        return op1;
    }

    private Condition F() throws IllegalArgumentException {
        String conType = this.nextToken();
        if (conType == null) {
            throw new IllegalArgumentException("Parser Error: condition type not found for condition \"" + this.m_stringCondition + "\"");
        }
        if (conType.equalsIgnoreCase("nountype")) {
            return this.nounType();
        }
        if (conType.equalsIgnoreCase("context")) {
            return this.context();
        }
        throw new IllegalArgumentException("Parser Error:  unknown condition type \"" + conType + "\" for condition \"" + this.m_stringCondition + "\"");
    }

    private NounTypeCondition nounType() {
        String opType = this.nextToken();
        NounTypeOpType nounTypeOpType = NounTypeOpType.getOpType(opType.toUpperCase());
        if (nounTypeOpType == null) {
            throw new IllegalArgumentException("Parser Error: unknown operator \"" + nounTypeOpType.toString() + "\" in condition \"" + this.m_stringCondition + "\"");
        }
        String value = this.nextToken();
        NounTypeCondition nounTypeCondition = new NounTypeCondition(ConditionParser.stripSurroundingQuotes(value), nounTypeOpType);
        return nounTypeCondition;
    }

    private ContextCondition context() {
        String name = this.nextToken();
        if (ConditionParser.containsSurroundingQuotes(name)) {
            throw new IllegalArgumentException("Parser Error: double quotes is not supported around context name: " + name + " for condition " + "\"" + this.m_stringCondition + "\"");
        }
        OpType opType = OpType.getOpType(this.nextToken().toUpperCase());
        ContextCondition con = null;
        String value = null;
        if (opType != OpType.IS_NULL && opType != OpType.ISNULL && opType != OpType.IS_NOT_NULL && opType != OpType.ISNOTNULL) {
            value = this.nextToken();
            if (value == null || value.equalsIgnoreCase("null")) {
                throw new IllegalArgumentException("Parser Error: did not expect a null value for operator \"" + opType.toString() + "\" in condition \"" + this.m_stringCondition + "\"");
            }
            con = new ContextCondition(name, ConditionParser.stripSurroundingQuotes(value), opType);
            String ic = this.peek();
            if (ic == null) {
                return con;
            }
            boolean dataTypePresent = false;
            boolean ignoreCasePresent = false;
            DataType dataType = null;
            while (ic != null && (ic.equalsIgnoreCase("IGNORECASE") || ic.equalsIgnoreCase("DATATYPE"))) {
                if (ic.equalsIgnoreCase("IGNORECASE") && !ignoreCasePresent) {
                    con.setIgnoreCase(this.ignoreCase());
                    ignoreCasePresent = true;
                } else if (ic.equalsIgnoreCase("DATATYPE") && !dataTypePresent) {
                    try {
                        dataType = this.dataType(value, opType);
                        con.setDataType(dataType);
                        dataTypePresent = true;
                    }
                    catch (EventConfigException e) {
                        String dataTypeString = null;
                        if (dataType != null) {
                            dataTypeString = dataType.toString();
                        }
                        throw new IllegalArgumentException("Parser Error:  failed to set the dataType \"" + dataTypeString + "\" for condition \"" + this.m_stringCondition + "\"", e);
                    }
                }
                ic = this.peek();
            }
            if (!dataTypePresent) {
                dataType = this.dynamicallyAssignDataType(value, opType);
                try {
                    con.setDataType(dataType);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
            if (dataType != DataType.STRING && ignoreCasePresent) {
                throw new IllegalArgumentException("Parser Error: IGNORECASE is only valid when used with the \"string\" datatype.");
            }
        } else {
            con = new ContextCondition(name, value, opType);
        }
        return con;
    }

    private DataType dataType(String value, OpType opType) {
        if (value == null) {
            throw new IllegalArgumentException("Parser Error:  did not expect a null value for operator \"" + opType.toString() + "\" in condition \"" + this.m_stringCondition + "\"");
        }
        DataType dataType = null;
        String dt = this.peek();
        if (dt != null && dt.equalsIgnoreCase("DATATYPE")) {
            this.advance();
            String eq = this.nextToken();
            if (eq == null || !eq.equals("=")) {
                throw new IllegalArgumentException("Parser Error: expecting an equals sign for \"" + dt + "\" but got \"" + eq + "\" in condition \"" + this.m_stringCondition + "\"");
            }
            dataType = DataType.getDataType(this.nextToken().toUpperCase());
            return dataType;
        }
        return dataType;
    }

    private DataType dynamicallyAssignDataType(String value, OpType opType) {
        DataType dataType = DataType.STRING;
        if (opType == OpType.IN) {
            String[] tokens = value.split(",");
            boolean sflag = false;
            boolean lflag = false;
            boolean dflag = false;
            DataType inDataType = null;
            block4: for (int i = 0; i < tokens.length; ++i) {
                if (tokens[i].equalsIgnoreCase("null")) {
                    throw new IllegalArgumentException("Parser Error:  did not expect a null value for operator \"" + opType.toString() + "\" in condition \"" + this.m_stringCondition + "\"");
                }
                inDataType = this.getDataType(tokens[i]);
                switch (inDataType) {
                    case LONG: {
                        lflag = true;
                        continue block4;
                    }
                    case DOUBLE: {
                        dflag = true;
                        continue block4;
                    }
                    default: {
                        sflag = true;
                    }
                }
            }
            if (lflag && !dflag && !sflag) {
                dataType = DataType.LONG;
            } else if (!lflag && dflag && !sflag) {
                dataType = DataType.DOUBLE;
            }
        } else {
            dataType = this.getDataType(value);
        }
        return dataType;
    }

    private boolean ignoreCase() {
        boolean ignoreCase = true;
        this.advance();
        if (this.peek() != null && this.peek().equals("=")) {
            this.advance();
            String caseState = this.peek();
            if (caseState.equalsIgnoreCase("false")) {
                ignoreCase = false;
            } else if (!caseState.equalsIgnoreCase("true")) {
                throw new IllegalArgumentException("Parser Error: IGNORECASE expects a boolean, but got \"" + caseState + "\" in condition \"" + this.m_stringCondition + "\"");
            }
            this.advance();
        }
        return ignoreCase;
    }

    private boolean hasMoreTokens() {
        return this.m_tokenizer.ttype != -1;
    }

    private String nextToken() throws IllegalArgumentException {
        if (!this.hasMoreTokens()) {
            throw new IllegalArgumentException("Parser Error: unexpected end of expression for condition \"" + this.m_stringCondition + "\"");
        }
        return this.getToken(true);
    }

    private String peek() throws IllegalArgumentException {
        if (!this.hasMoreTokens()) {
            return null;
        }
        return this.getToken(false);
    }

    private void advance() {
        try {
            this.m_tokenizer.nextToken();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getToken(boolean advance) throws IllegalArgumentException {
        String tok = null;
        switch (this.m_tokenizer.ttype) {
            case -3: {
                tok = this.m_tokenizer.sval;
                break;
            }
            case 34: 
            case 39: {
                tok = "\"" + this.m_tokenizer.sval + "\"";
                break;
            }
            case 61: {
                tok = "=";
                break;
            }
            case 40: {
                tok = "(";
                break;
            }
            case 41: {
                tok = ")";
                break;
            }
            default: {
                if (this.m_tokenizer.ttype > 32) {
                    throw new IllegalArgumentException("Parser Error: invalid character \"" + (char)this.m_tokenizer.ttype + "\" for condition \"" + this.m_stringCondition + "\"");
                }
                throw new IllegalArgumentException("Parser Error: invalid characters for condition \"" + this.m_stringCondition + "\"");
            }
        }
        if (advance) {
            this.advance();
        }
        return tok;
    }

    private StreamTokenizer initTokenizer(String s) {
        StreamTokenizer st = new StreamTokenizer(new StringReader(s));
        st.ordinaryChars(48, 57);
        st.wordChars(33, Integer.MAX_VALUE);
        st.ordinaryChar(40);
        st.ordinaryChar(41);
        st.ordinaryChar(61);
        st.quoteChar(34);
        st.quoteChar(39);
        return st;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: ConditionParser <condition>");
        }
        System.out.println("Parsing condition \"" + args[0] + "\"");
        ConditionParser cp = new ConditionParser();
        Condition con = cp.parse(args[0]);
        System.out.println("Parsed Condition:\n");
        ConditionParser.dumpCondition(con, "  ");
    }

    private static void dumpCondition(Condition con, String indent) {
        if (con instanceof NounTypeCondition) {
            NounTypeCondition ntc = (NounTypeCondition)con;
            System.out.println(indent + "nounType name=" + ntc.getNounType() + " op=" + ntc.getOpType());
        } else if (con instanceof ContextCondition) {
            ContextCondition cc = (ContextCondition)con;
            System.out.println(indent + "context name=" + cc.getName() + " op=" + (Object)((Object)cc.getOpType()) + " value=" + cc.getValue() + " ignoreCase=" + cc.getIgnoreCase() + " dataType=" + (Object)((Object)cc.getDataType()));
        } else if (con instanceof OrCondition) {
            OrCondition orCon = (OrCondition)con;
            System.out.println(indent + "OrCondition LHS=");
            ConditionParser.dumpCondition(orCon.getLHCondition(), indent + "    ");
            System.out.println(indent + "            RHS=");
            ConditionParser.dumpCondition(orCon.getRHCondition(), indent + "    ");
        } else if (con instanceof AndCondition) {
            AndCondition andCon = (AndCondition)con;
            System.out.println(indent + "AndCondition LHS=");
            ConditionParser.dumpCondition(andCon.getLHCondition(), indent + "    ");
            System.out.println(indent + "             RHS=");
            ConditionParser.dumpCondition(andCon.getRHCondition(), indent + "    ");
        } else if (con instanceof NestedCondition) {
            NestedCondition nestedCondition = (NestedCondition)con;
            System.out.println(indent + "NestedCondition=");
            ConditionParser.dumpCondition(nestedCondition.getCondition(), indent + "    ");
        }
    }

    private DataType getDataType(String dataTypeValue) {
        DataType dataType = DataType.STRING;
        if (!dataTypeValue.startsWith("\"") && !dataTypeValue.startsWith("'")) {
            if (dataTypeValue.indexOf(46) != -1) {
                boolean allFloat = true;
                int period = 0;
                for (int i = 0; i < dataTypeValue.length(); ++i) {
                    if (Character.isDigit(dataTypeValue.charAt(i))) continue;
                    if (dataTypeValue.charAt(i) == '.') {
                        ++period;
                        continue;
                    }
                    allFloat = false;
                    break;
                }
                if (allFloat && period == 1) {
                    dataType = DataType.DOUBLE;
                }
            } else {
                boolean allInteger = true;
                for (int i = 0; i < dataTypeValue.length(); ++i) {
                    if (Character.isDigit(dataTypeValue.charAt(i))) continue;
                    allInteger = false;
                    break;
                }
                if (allInteger) {
                    dataType = DataType.LONG;
                }
            }
        }
        return dataType;
    }

    private static String stripSurroundingQuotes(String value) {
        if (value != null) {
            if (value.startsWith("\"")) {
                value = value.substring(1, value.length());
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        return value;
    }

    private static boolean containsSurroundingQuotes(String value) {
        boolean retVal = false;
        if (value != null && (value.startsWith("\"") || value.endsWith("\""))) {
            retVal = true;
        }
        return retVal;
    }
}

