/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.dfw.impl.common.MapUtils;

public class DumpSampleInfo
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String sampleName_;
    private String diagnosticDumpName_;
    private String appName_;
    private Long samplingInterval_;
    private Long rotationCount_;
    private Boolean dumpedImplicitly_;
    private Boolean toAppend_;
    private Map<String, String> dumpArguments_;
    public static final String TYPE_NAME = "DumpSampleInfo";
    private static String[] ITEM_NAMES = new String[]{"sampleName", "diagnosticDumpName", "appName", "samplingInterval", "rotationCount", "dumpedImplicitly", "toAppend", "dumpArguments"};
    private static CompositeType s_dumpArgumentType;
    private static final String DUMPARGUMENT_TYPE_NAME = "DumpArgument";
    private static final String[] DUMPARGUMENT_ITEM_NAMES;
    private static CompositeType s_compositeType;

    public DumpSampleInfo() {
    }

    public DumpSampleInfo(String sampleName, String diagnosticDumpName, String appName, Long samplingInterval, Long rotationCount, Boolean dumpedImplicitly, Boolean toAppend, Map<String, String> dumpArguments) {
        this.sampleName_ = sampleName;
        this.diagnosticDumpName_ = diagnosticDumpName;
        this.appName_ = appName;
        this.samplingInterval_ = samplingInterval;
        this.rotationCount_ = rotationCount;
        this.dumpedImplicitly_ = dumpedImplicitly;
        this.toAppend_ = toAppend;
        this.dumpArguments_ = dumpArguments;
    }

    public String getSampleName() {
        return this.sampleName_;
    }

    public void setSampleName(String sampleName) {
        this.sampleName_ = sampleName;
    }

    public String getDiagnosticDumpName() {
        return this.diagnosticDumpName_;
    }

    public void setDiagnosticDumpName(String diagnosticDumpName) {
        this.diagnosticDumpName_ = diagnosticDumpName;
    }

    public String getAppName() {
        return this.appName_;
    }

    public void setAppName(String appName) {
        this.appName_ = appName;
    }

    public Long getSamplingInterval() {
        return this.samplingInterval_;
    }

    public void setSamplingInterval(Long samplingInterval) {
        this.samplingInterval_ = samplingInterval;
    }

    public Long getRotationCount() {
        return this.rotationCount_;
    }

    public void setRotationCount(Long rotationCount) {
        this.rotationCount_ = rotationCount;
    }

    public Boolean canBeDumpedImplicitly() {
        return this.dumpedImplicitly_;
    }

    public void setToBeDumpedImplicitly(Boolean dumpedImplicitly) {
        this.dumpedImplicitly_ = dumpedImplicitly;
    }

    public Boolean isAppending() {
        return this.toAppend_;
    }

    public void setToAppend(Boolean toAppend) {
        this.toAppend_ = toAppend;
    }

    public Map<String, String> getDumpArguments() {
        if (this.dumpArguments_ == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>(this.dumpArguments_);
        return map;
    }

    public void setDumpArguments(Map<String, String> dumpArguments) {
        if (dumpArguments == null) {
            return;
        }
        if (this.dumpArguments_ == null) {
            this.dumpArguments_ = new HashMap<String, String>(1);
        } else {
            this.dumpArguments_.clear();
        }
        this.dumpArguments_.putAll(dumpArguments);
    }

    public boolean equalDiagnsticDump(DumpSampleInfo target) {
        boolean result = true;
        if (!(DumpSampleInfo.compareStrings(this.diagnosticDumpName_, target.diagnosticDumpName_) && DumpSampleInfo.compareStrings(this.appName_, target.appName_) && DumpSampleInfo.compareLongs(this.rotationCount_, target.rotationCount_) && DumpSampleInfo.compareLongs(this.samplingInterval_, target.samplingInterval_) && DumpSampleInfo.compareBooleans(this.toAppend_, target.toAppend_) && DumpSampleInfo.compareBooleans(this.dumpedImplicitly_, target.dumpedImplicitly_) && MapUtils.compare(this.dumpArguments_, target.dumpArguments_))) {
            result = false;
        }
        return result;
    }

    private static boolean compareStrings(String s1, String s2) {
        boolean result = true;
        if (s1 == null && s2 != null || s1 != null && s2 == null || s1 != null && s2 != null && !s1.equals(s2)) {
            result = false;
        }
        return result;
    }

    private static boolean compareBooleans(Boolean b1, Boolean b2) {
        boolean result = true;
        if (b1 == null && b2 != null || b1 != null && b2 == null || b1 != null && b2 != null && !b1.equals(b2)) {
            result = false;
        }
        return result;
    }

    private static boolean compareLongs(Long l1, Long l2) {
        boolean result = true;
        if (l1 == null && l2 != null || l1 != null && l2 == null || l1 != null && l2 != null && !l1.equals(l2)) {
            result = false;
        }
        return result;
    }

    private static boolean containsAttribute(CompositeType ct, String name) {
        return ct.containsKey(name) && (SimpleType.STRING.equals(ct.getType(name)) || SimpleType.LONG.equals(ct.getType(name)) || SimpleType.BOOLEAN.equals(ct.getType(name)));
    }

    public static DumpSampleInfo from(CompositeData cd) throws OpenDataException {
        CompositeType ct = cd.getCompositeType();
        if (!((TYPE_NAME.equals(ct.getTypeName()) || DumpSampleInfo.class.getName().equals(ct.getTypeName())) && DumpSampleInfo.containsAttribute(ct, "sampleName") && DumpSampleInfo.containsAttribute(ct, "diagnosticDumpName") && DumpSampleInfo.containsAttribute(ct, "appName") && DumpSampleInfo.containsAttribute(ct, "samplingInterval") && DumpSampleInfo.containsAttribute(ct, "rotationCount") && DumpSampleInfo.containsAttribute(ct, "dumpedImplicitly") && DumpSampleInfo.containsAttribute(ct, "toAppend"))) {
            throw new IllegalArgumentException();
        }
        DumpSampleInfo di = new DumpSampleInfo();
        di.setSampleName((String)cd.get("sampleName"));
        di.setDiagnosticDumpName((String)cd.get("diagnosticDumpName"));
        di.setAppName((String)cd.get("appName"));
        di.setSamplingInterval((Long)cd.get("samplingInterval"));
        di.setRotationCount((Long)cd.get("rotationCount"));
        di.setToBeDumpedImplicitly((Boolean)cd.get("dumpedImplicitly"));
        di.setToAppend((Boolean)cd.get("toAppend"));
        di.setDumpArguments(DumpSampleInfo.getProperties(cd));
        return di;
    }

    private static Map<String, String> getProperties(CompositeData cd) {
        Object o;
        if (cd.containsKey("dumpArguments") && (o = cd.get("dumpArguments")) != null && o instanceof CompositeData[]) {
            return DumpSampleInfo.getProperties((CompositeData[])o);
        }
        return null;
    }

    private static Map<String, String> getProperties(CompositeData[] cds) {
        if (cds == null) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>(cds.length);
        for (CompositeData cd : cds) {
            props.put((String)cd.get("name"), (String)cd.get("value"));
        }
        return props;
    }

    public CompositeData toCompositeData(CompositeType ct) throws OpenDataException {
        if (ct == null) {
            ct = DumpSampleInfo.toCompositeType();
        } else if (!DumpSampleInfo.toCompositeType().equals(ct)) {
            throw new IllegalArgumentException();
        }
        return new CompositeDataSupport(ct, ITEM_NAMES, new Object[]{this.sampleName_, this.diagnosticDumpName_, this.appName_, this.samplingInterval_, this.rotationCount_, this.dumpedImplicitly_, this.toAppend_, this.toCompositeData(this.dumpArguments_)});
    }

    public static CompositeType toCompositeType() throws OpenDataException {
        if (s_compositeType == null) {
            s_dumpArgumentType = new CompositeType(DUMPARGUMENT_TYPE_NAME, DUMPARGUMENT_TYPE_NAME, DUMPARGUMENT_ITEM_NAMES, DUMPARGUMENT_ITEM_NAMES, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
            s_compositeType = new CompositeType(TYPE_NAME, TYPE_NAME, ITEM_NAMES, ITEM_NAMES, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.BOOLEAN, SimpleType.BOOLEAN, new ArrayType(1, s_dumpArgumentType)});
        }
        return s_compositeType;
    }

    private CompositeData[] toCompositeData(Map<String, String> arguments) throws OpenDataException {
        if (arguments == null) {
            return null;
        }
        CompositeData[] r = new CompositeData[arguments.size()];
        int i = 0;
        for (Map.Entry<String, String> e : arguments.entrySet()) {
            r[i++] = new CompositeDataSupport(s_dumpArgumentType, DUMPARGUMENT_ITEM_NAMES, new Object[]{e.getKey(), e.getValue()});
        }
        return r;
    }

    static {
        DUMPARGUMENT_ITEM_NAMES = new String[]{"name", "value"};
    }
}

