/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.dump;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriterException;

public final class DumpWriter {
    private DumpContext m_context;
    private FileWriter m_fw;
    private PrintWriter m_pw;
    private String m_dumpFilename;
    private static final String NEW_LINE = "\n";

    public DumpWriter(DumpContext context) throws DumpWriterException {
        if (context == null) {
            throw new IllegalArgumentException("DumpContext cannot be null");
        }
        try {
            this.m_context = context;
            File dumpFile = context.generateUniqueFile(null);
            this.m_fw = DumpWriter.createFileWriter(dumpFile);
            this.m_pw = new PrintWriter(this.m_fw);
            this.m_dumpFilename = dumpFile.getName();
        }
        catch (IOException e) {
            throw new DumpWriterException("DFW-40009", e);
        }
    }

    public DumpWriter(DumpContext context, File dumpFile) throws IOException {
        if (context == null || dumpFile == null) {
            throw new IllegalArgumentException("Invalid arguments. context=" + context + ". dumpFile=" + dumpFile);
        }
        this.m_context = context;
        this.m_fw = DumpWriter.createFileWriter(dumpFile);
        this.m_pw = new PrintWriter(this.m_fw);
        this.m_dumpFilename = dumpFile.getName();
    }

    public DumpResult getDumpResult() {
        if (this.m_pw != null) {
            this.m_pw.close();
        }
        try {
            if (this.m_fw != null) {
                this.m_fw.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new DumpResult(this.m_context, this.m_dumpFilename);
    }

    public void dump(String s) {
        if (s == null) {
            return;
        }
        this.m_pw.write(s);
    }

    public void dumpln(String s) {
        this.dump(s);
        this.dump(NEW_LINE);
    }

    public void dumpln() {
        this.dump(NEW_LINE);
    }

    public void dump(char[] buf, int off, int len) {
        if (buf == null) {
            return;
        }
        this.m_pw.write(buf, off, len);
    }

    private static FileWriter createFileWriter(final File file) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileWriter>(){

                @Override
                public FileWriter run() throws IOException {
                    return new FileWriter(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }
}

