/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.dump;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dfw.common.ArgumentType;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriter;
import oracle.dfw.dump.DumpWriterException;

public class SystemPropertiesDump
extends ComponentDiagnosticDump {
    private static final String DESCRIPTION = "Dumps the set of Java system properties available to the component that the dump is executed against.";

    public SystemPropertiesDump() {
        this.defineArgument("prop", ArgumentType.STRING, false, "name of the Java System property to retrieve");
    }

    @Override
    public DumpResult executeDump(DumpContext context) throws DumpExecutionException, DumpWriterException {
        DumpWriter dw = new DumpWriter(context);
        try {
            Logger log = LoggerFactory.getDumpLogger(this, null);
            final String propName = context.getArguments().getString("prop");
            if (propName == null) {
                Properties sysProps = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

                    @Override
                    public Properties run() {
                        return System.getProperties();
                    }
                });
                TreeMap<Object, Object> sortedMap = new TreeMap<Object, Object>(sysProps);
                for (Map.Entry<Object, Object> prop : sortedMap.entrySet()) {
                    dw.dump(prop.getKey() + "=" + prop.getValue() + "\n");
                }
            } else {
                log.log(Level.FINER, "Property retrieved: " + propName);
                String value = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(propName, "Property \"" + propName + "\" not defined.");
                    }
                });
                dw.dump(value);
            }
        }
        catch (Exception e) {
            throw new DumpExecutionException("failed to access Java System properties", e);
        }
        return dw.getDumpResult();
    }

    @Override
    public String getName() {
        return "sysprops";
    }

    @Override
    public String getOwner() {
        return "java";
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return EnumSet.of(DiagnosticsCategory.CONFIGURATION);
    }

    @Override
    public String getDumpDescription() {
        return DESCRIPTION;
    }
}

