/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.text.ParsePosition;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

class DateFormat {
    private Calendar m_calendar = new GregorianCalendar();
    private int m_year = Integer.MIN_VALUE;
    private int m_month = Integer.MIN_VALUE;
    private int m_day = Integer.MIN_VALUE;
    private long m_baseTime = 0L;
    private static final long ERROR = Long.MIN_VALUE;

    public DateFormat() {
        this.m_calendar.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        this.m_calendar.setLenient(false);
    }

    public long parse(String str, ParsePosition pos) {
        return this.parse(str.toCharArray(), pos);
    }

    public long parse(String str) {
        return this.parse(str.toCharArray(), new ParsePosition(0));
    }

    public long parse(char[] chars, ParsePosition parsePos) {
        int tzOffset;
        int limit = chars.length;
        int pos = parsePos.getIndex();
        if (limit - pos < 20) {
            return Long.MIN_VALUE;
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int fraction = 0;
        int tzHour = 0;
        int tzMin = 0;
        int d0 = DateFormat.digit(chars[pos++]);
        int d1 = DateFormat.digit(chars[pos++]);
        int d2 = DateFormat.digit(chars[pos++]);
        int d3 = DateFormat.digit(chars[pos++]);
        if (d0 < 0 || d1 < 0 || d2 < 0 || d3 < 0) {
            return Long.MIN_VALUE;
        }
        year = d0 * 1000 + d1 * 100 + d2 * 10 + d3;
        if (chars[pos++] != '-') {
            return Long.MIN_VALUE;
        }
        d0 = DateFormat.digit(chars[pos++]);
        d1 = DateFormat.digit(chars[pos++]);
        if (d0 < 0 || d1 < 0) {
            return Long.MIN_VALUE;
        }
        month = d0 * 10 + d1;
        if (chars[pos++] != '-') {
            return Long.MIN_VALUE;
        }
        d0 = DateFormat.digit(chars[pos++]);
        d1 = DateFormat.digit(chars[pos++]);
        if (d0 < 0 || d1 < 0) {
            return Long.MIN_VALUE;
        }
        day = d0 * 10 + d1;
        if (chars[pos++] != ' ') {
            return Long.MIN_VALUE;
        }
        d0 = DateFormat.digit(chars[pos++]);
        d1 = DateFormat.digit(chars[pos++]);
        if (d0 < 0 || d1 < 0) {
            return Long.MIN_VALUE;
        }
        hour = d0 * 10 + d1;
        if (chars[pos++] != ':') {
            return Long.MIN_VALUE;
        }
        d0 = DateFormat.digit(chars[pos++]);
        d1 = DateFormat.digit(chars[pos++]);
        if (d0 < 0 || d1 < 0) {
            return Long.MIN_VALUE;
        }
        minute = d0 * 10 + d1;
        if (chars[pos++] != ':') {
            return Long.MIN_VALUE;
        }
        d0 = DateFormat.digit(chars[pos++]);
        d1 = DateFormat.digit(chars[pos++]);
        if (d0 < 0 || d1 < 0) {
            return Long.MIN_VALUE;
        }
        second = d0 * 10 + d1;
        if (pos >= limit) {
            return Long.MIN_VALUE;
        }
        fraction = 0;
        if (chars[pos] == '.') {
            d0 = 0;
            d1 = 0;
            d2 = 0;
            if (++pos < limit && (d0 = DateFormat.digit(chars[pos])) >= 0) {
                if (++pos < limit && (d1 = DateFormat.digit(chars[pos])) >= 0) {
                    if (++pos < limit && (d2 = DateFormat.digit(chars[pos])) >= 0) {
                        ++pos;
                    } else {
                        d2 = 0;
                    }
                } else {
                    d1 = 0;
                }
            } else {
                d0 = 0;
            }
            fraction = d0 * 100 + d1 * 10 + d2;
            while (pos < limit && DateFormat.digit(chars[pos]) >= 0) {
                ++pos;
            }
        }
        if (pos >= limit) {
            return Long.MIN_VALUE;
        }
        if (chars[pos++] != ' ') {
            return Long.MIN_VALUE;
        }
        if (chars[pos] == 'Z' || chars[pos] == 'z') {
            tzOffset = 0;
            ++pos;
        } else {
            if (limit - pos < 6) {
                return Long.MIN_VALUE;
            }
            int tzSign = 0;
            if (chars[pos] == '-') {
                tzSign = -1;
            } else if (chars[pos] == '+') {
                tzSign = 1;
            } else {
                return Long.MIN_VALUE;
            }
            int n = ++pos;
            d0 = DateFormat.digit(chars[n]);
            int n2 = ++pos;
            ++pos;
            d1 = DateFormat.digit(chars[n2]);
            if (d0 < 0 || d1 < 0) {
                return Long.MIN_VALUE;
            }
            tzHour = d0 * 10 + d1;
            if (tzHour > 23) {
                return Long.MIN_VALUE;
            }
            if (chars[pos++] != ':') {
                return Long.MIN_VALUE;
            }
            d0 = DateFormat.digit(chars[pos++]);
            d1 = DateFormat.digit(chars[pos++]);
            if (d0 < 0 || d1 < 0) {
                return Long.MIN_VALUE;
            }
            tzMin = d0 * 10 + d1;
            if (tzMin > 59) {
                return Long.MIN_VALUE;
            }
            tzOffset = tzSign * (tzHour * 60 + tzMin) * 60000;
        }
        parsePos.setIndex(pos);
        if (hour > 24 || minute > 59 || second > 59) {
            return Long.MIN_VALUE;
        }
        if (year != this.m_year || month != this.m_month || day != this.m_day) {
            this.m_calendar.clear();
            try {
                this.m_calendar.set(year, month - 1, day);
                this.m_baseTime = this.m_calendar.getTime().getTime();
            }
            catch (Exception e) {
                return Long.MIN_VALUE;
            }
            this.m_year = year;
            this.m_month = month;
            this.m_day = day;
        }
        return this.m_baseTime + (long)(((hour * 60 + minute) * 60 + second) * 1000) + (long)fraction - (long)tzOffset;
    }

    private static final int digit(char ch) {
        return ch >= '0' && ch <= '9' ? ch - 48 : -1;
    }
}

