/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DumpAction {
    private String m_dumpName;
    private boolean m_runSynchronously;
    private HashMap<String, String> m_factArguments;
    private HashMap<String, String> m_literalArguments;
    private HashMap<String, String> m_contextArguments;
    private List<String> m_mandatoryArguments;

    DumpAction(String dumpName, boolean runSynchronously) {
        this.m_dumpName = dumpName;
        this.m_runSynchronously = runSynchronously;
    }

    public String getDumpName() {
        return this.m_dumpName;
    }

    public boolean runSynchronously() {
        return this.m_runSynchronously;
    }

    public Map<String, String> getFactBasedArguments() {
        if (this.m_factArguments == null) {
            return Collections.emptyMap();
        }
        return this.m_factArguments;
    }

    public Map<String, String> getLiteralBasedArguments() {
        if (this.m_literalArguments == null) {
            return Collections.emptyMap();
        }
        return this.m_literalArguments;
    }

    public Map<String, String> getContextBasedArguments() {
        if (this.m_contextArguments == null) {
            return Collections.emptyMap();
        }
        return this.m_contextArguments;
    }

    void addFactBasedArgument(String name, String fact, boolean mandatory) {
        if (this.m_factArguments == null) {
            this.m_factArguments = new HashMap(1);
        }
        this.m_factArguments.put(name, fact);
        if (mandatory) {
            if (this.m_mandatoryArguments == null) {
                this.m_mandatoryArguments = new ArrayList<String>(1);
            }
            this.m_mandatoryArguments.add(name);
        }
    }

    void addLiteralBasedArgument(String name, String value) {
        if (this.m_literalArguments == null) {
            this.m_literalArguments = new HashMap(1);
        }
        this.m_literalArguments.put(name, value);
        if (this.m_mandatoryArguments == null) {
            this.m_mandatoryArguments = new ArrayList<String>(1);
        }
        this.m_mandatoryArguments.add(name);
    }

    void addContextBasedArgument(String name, String value, boolean mandatory) {
        if (this.m_contextArguments == null) {
            this.m_contextArguments = new HashMap(1);
        }
        this.m_contextArguments.put(name, value);
        if (mandatory) {
            if (this.m_mandatoryArguments == null) {
                this.m_mandatoryArguments = new ArrayList<String>(1);
            }
            this.m_mandatoryArguments.add(name);
        }
    }

    boolean isMandatory(String name) {
        return this.m_mandatoryArguments != null ? this.m_mandatoryArguments.contains(name) : false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[name=");
        buf.append(this.m_dumpName);
        buf.append(" literalArgs={");
        for (Map.Entry<String, String> arg : this.getLiteralBasedArguments().entrySet()) {
            buf.append(" ");
            buf.append(arg.getKey());
            buf.append("=");
            buf.append(arg.getValue());
        }
        buf.append("} factsArgs={");
        for (Map.Entry<String, String> arg : this.getFactBasedArguments().entrySet()) {
            buf.append(" ");
            buf.append(arg.getKey());
            buf.append("=");
            buf.append(arg.getValue());
            buf.append(" (mandatory=");
            buf.append(this.isMandatory(arg.getKey()));
            buf.append(")");
        }
        buf.append("} contextArgs={");
        for (Map.Entry<String, String> arg : this.getContextBasedArguments().entrySet()) {
            buf.append(" ");
            buf.append(arg.getKey());
            buf.append("=");
            buf.append(arg.getValue());
            buf.append(" (mandatory=");
            buf.append(this.isMandatory(arg.getKey()));
            buf.append(")");
        }
        buf.append("}]");
        return buf.toString();
    }
}

