/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.impl.incident.IncidentDump;
import oracle.dfw.incident.ErrorMessage;
import oracle.dfw.incident.Incident;
import oracle.dfw.incident.IncidentFacts;

public class IncidentImpl
implements Incident,
Serializable {
    private String m_description;
    private String m_problemKey;
    private String m_problemId;
    private String m_executionContextId;
    private String m_incidentPath;
    private ErrorMessage m_errorMessage;
    private String m_incidentId;
    private Incident.IncidentSource m_incidentSource;
    private boolean m_floodContolled = false;
    private String m_adrBase;
    private String m_productType;
    private String m_productId;
    private String m_instanceId;
    private String m_preFloodControlledIncidentId;
    private List<DiagnosticsCategory> m_problemImpacts;
    private Map<String, String> m_contextValues;
    private long m_incidentTime;
    private List<IncidentDump> m_incidentDumps = new ArrayList<IncidentDump>();
    private List<String> m_incidentFiles = new ArrayList<String>();
    private static final String MANUAL_INCIDENT = "[" + (Object)((Object)Incident.IncidentSource.MANUAL) + "]";
    private static final long serialVersionUID = 0L;

    public IncidentImpl(String incidentId, String incidentPath, String adrBase, String productType, String productId, String instanceId, String problemId, IncidentFacts facts) {
        if (incidentId == null || incidentId.length() == 0 || incidentPath == null || incidentPath.length() == 0) {
            throw new IllegalArgumentException("incidentId=" + incidentId + " incidentPath=" + incidentPath);
        }
        this.m_incidentId = incidentId;
        this.m_incidentPath = incidentPath;
        this.m_incidentTime = facts.getIncidentTime();
        this.m_errorMessage = facts.getErrorMessage();
        this.m_incidentSource = facts.getIncidentSource();
        this.m_executionContextId = facts.getExecutionContextId();
        this.m_description = facts.getDescription();
        this.m_problemKey = facts.getProblemKey();
        this.m_contextValues = new HashMap<String, String>(facts.getContextValues());
        this.m_adrBase = adrBase;
        this.m_productType = productType;
        this.m_productId = productId;
        this.m_instanceId = instanceId;
        this.m_problemId = problemId;
        List<String> impacts = facts.getIncidentFactPropertyValues(IncidentFacts.IncidentFactProperty.PROBLEM_IMPACT_PROP);
        if (impacts != null) {
            this.m_problemImpacts = new ArrayList<DiagnosticsCategory>(impacts.size());
            for (String impact : impacts) {
                DiagnosticsCategory category = DiagnosticsCategory.getDiagnosticsCategory(impact);
                if (category == null) continue;
                this.m_problemImpacts.add(category);
            }
        }
    }

    public IncidentImpl(String incidentId, String incidentPath, String adrBase, String productType, String productId, String instanceId, String problemId, String problemKey, String executionContextId, long incidentTime, ErrorMessage errorMessage) {
        if (incidentId == null || incidentId.length() == 0 || incidentPath == null || incidentPath.length() == 0) {
            throw new IllegalArgumentException("incidentId=" + incidentId + " incidentPath=" + incidentPath);
        }
        this.m_incidentId = incidentId;
        this.m_incidentPath = incidentPath;
        this.m_incidentTime = incidentTime;
        this.m_errorMessage = errorMessage;
        this.m_executionContextId = executionContextId;
        this.m_problemId = problemId;
        this.m_problemKey = problemKey;
        this.m_adrBase = adrBase;
        this.m_productType = productType;
        this.m_productId = productId;
        this.m_instanceId = instanceId;
        this.m_contextValues = new HashMap<String, String>(0);
        this.m_incidentSource = this.m_problemKey != null && this.m_problemKey.contains(MANUAL_INCIDENT) ? Incident.IncidentSource.MANUAL : Incident.IncidentSource.SYSTEM;
    }

    @Override
    public String getIncidentId() {
        return this.m_incidentId;
    }

    @Override
    public long getTimeOfIncident() {
        return this.m_incidentTime;
    }

    @Override
    public List<DiagnosticsCategory> getProblemImpacts() {
        return this.m_problemImpacts;
    }

    @Override
    public String getExecutionContextId() {
        return this.m_executionContextId;
    }

    @Override
    public Incident.IncidentSource getIncidentSource() {
        return this.m_incidentSource;
    }

    public void setIncidentSource(Incident.IncidentSource source) {
        this.m_incidentSource = source;
    }

    @Override
    public ErrorMessage getErrorMessage() {
        return this.m_errorMessage;
    }

    public List<IncidentDump> getIncidentDumps() {
        return this.m_incidentDumps;
    }

    @Override
    public boolean isFloodControlled() {
        return this.m_floodContolled;
    }

    @Override
    public String getFloodControlledLastIncidentId() {
        return this.m_preFloodControlledIncidentId;
    }

    public void setFloodContolled(String id) {
        this.m_floodContolled = true;
        this.m_preFloodControlledIncidentId = id;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public String getProblemId() {
        return this.m_problemId;
    }

    @Override
    public String getProblemKey() {
        return this.m_problemKey;
    }

    @Override
    public String getADRBase() {
        return this.m_adrBase;
    }

    @Override
    public String getProductType() {
        return this.m_productType;
    }

    @Override
    public String getProductId() {
        return this.m_productId;
    }

    @Override
    public String getInstanceId() {
        return this.m_instanceId;
    }

    @Override
    public String getIncidentDirectory() {
        return this.m_incidentPath;
    }

    @Override
    public Map<String, String> getContextValues() {
        return Collections.unmodifiableMap(this.m_contextValues);
    }

    @Override
    public List<String> getIncidentFiles() {
        return this.m_incidentFiles;
    }

    void addIncidentFiles(String ... files) {
        if (files != null) {
            for (String file : files) {
                this.m_incidentFiles.add(file);
            }
        }
    }

    void addIncidentDump(IncidentDump dump) {
        if (dump == null) {
            return;
        }
        this.m_incidentDumps.add(dump);
    }

    void setContextValue(String name, String value) {
        this.m_contextValues.put(name, value);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[Incident id=");
        buf.append(this.m_incidentId);
        buf.append("][Flood Controlled=");
        buf.append(this.m_floodContolled);
        buf.append("][Problem key=");
        buf.append(this.m_problemKey);
        buf.append("][Dump count=");
        buf.append(this.m_incidentDumps.size());
        buf.append("]");
        return buf.toString();
    }
}

