/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.query;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dfw.common.DiagnosticsException;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.impl.incident.ADRHelper;
import oracle.dfw.impl.incident.ADRInfo;
import oracle.dfw.impl.query.AndCondition;
import oracle.dfw.impl.query.Condition;
import oracle.dfw.impl.query.OrCondition;
import oracle.dfw.impl.query.SimpleCondition;

public class ADRQueryExecutor {
    private ADRHelper m_adrHelper;
    private Logger m_logger;
    private static final String PROBLEM_KEY = "PROBLEM_KEY";

    public ADRQueryExecutor(ADRHelper helper) {
        this.m_adrHelper = helper;
        this.m_logger = LoggerFactory.getFrameworkLogger();
    }

    public Set<String> execute(ADRInfo adrInfo, String originalQuery, Condition query) throws DiagnosticsException {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.finer("Preparing to optimize query expression \"" + query.toString() + "\"");
        }
        ADRCondition adrQuery = null;
        try {
            adrQuery = this.optimize(query);
        }
        catch (Exception e) {
            throw new DiagnosticsException("DFW-40129", originalQuery, e);
        }
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.finer("ADR Optimized query expression \"" + adrQuery.toString() + "\"");
        }
        return adrQuery.execute(adrInfo);
    }

    public void validate(String originalQuery, Condition query) throws DiagnosticsException {
        try {
            this.optimize(query);
        }
        catch (Exception e) {
            throw new DiagnosticsException("DFW-40129", originalQuery, e);
        }
    }

    private ADRCondition optimize(Condition query) {
        ADRCondition adrCondition = null;
        if (query instanceof SimpleCondition) {
            adrCondition = new ADRSimpleCondition(this.buildADRStatement((SimpleCondition)query, false));
        } else if (query instanceof AndCondition) {
            AndCondition andCon = (AndCondition)query;
            if (andCon.getLHCondition() instanceof SimpleCondition && andCon.getRHCondition() instanceof SimpleCondition) {
                adrCondition = this.optimize((SimpleCondition)andCon.getLHCondition(), (SimpleCondition)andCon.getRHCondition(), "and");
            }
            if (adrCondition == null) {
                adrCondition = new ADRAndCondition(this.optimize(andCon.getLHCondition()), this.optimize(andCon.getRHCondition()));
            }
        } else if (query instanceof OrCondition) {
            OrCondition orCon = (OrCondition)query;
            if (orCon.getLHCondition() instanceof SimpleCondition && orCon.getRHCondition() instanceof SimpleCondition) {
                adrCondition = this.optimize((SimpleCondition)orCon.getLHCondition(), (SimpleCondition)orCon.getRHCondition(), "or");
            }
            if (adrCondition == null) {
                adrCondition = new ADROrCondition(this.optimize(orCon.getLHCondition()), this.optimize(orCon.getRHCondition()));
            }
        } else {
            throw new IllegalArgumentException("Unrecognized Condition type: " + query);
        }
        return adrCondition;
    }

    private ADRCondition optimize(SimpleCondition lhCondition, SimpleCondition rhCondition, String logicalOp) {
        ADRSimpleCondition adrCondition = null;
        IncidentRelationAttributes lhAttr = IncidentRelationAttributes.getAttribute(lhCondition.getName());
        IncidentRelationAttributes rhAttr = IncidentRelationAttributes.getAttribute(rhCondition.getName());
        if (lhAttr != null && rhAttr != null) {
            String statement = "query (incident_id) incident -p \"";
            statement = statement + this.buildADRStatement(lhCondition, true) + " " + logicalOp + " " + this.buildADRStatement(rhCondition, true);
            statement = statement + "\" -type xml";
            adrCondition = new ADRSimpleCondition(statement);
        }
        return adrCondition;
    }

    private String buildADRStatement(SimpleCondition condition, boolean whereConditionOnly) {
        String name = condition.getName();
        IncidentRelationAttributes attribute = IncidentRelationAttributes.getAttribute(name);
        String statement = "";
        if (attribute != null) {
            if (!whereConditionOnly) {
                statement = "query (incident_id) incident -p \"";
            }
            statement = statement + this.buildExpression(name, attribute.getADRName(), condition.getOperator(), condition.getValue(), false, attribute.getDataType());
            if (!whereConditionOnly) {
                statement = statement + "\" -type xml";
            }
        } else if (name.equalsIgnoreCase(PROBLEM_KEY)) {
            if (!whereConditionOnly) {
                statement = "query (problem_id) problem -p \"";
            }
            statement = statement + this.buildExpression(name, PROBLEM_KEY, condition.getOperator(), condition.getValue(), false, IncidentRelationAttributes.DataType.STRING);
            if (!whereConditionOnly) {
                statement = statement + "\" -type xml";
            }
        } else {
            if (!whereConditionOnly) {
                statement = "query (incident_id) incckey -p \"";
            }
            statement = statement + this.buildExpression(name, condition.getName(), condition.getOperator(), condition.getValue(), true, IncidentRelationAttributes.DataType.STRING);
            if (!whereConditionOnly) {
                statement = statement + "\" -type xml";
            }
        }
        return statement;
    }

    private String buildExpression(String displayName, String name, SimpleCondition.Operator op, String value, boolean isIncckeyRelation, IncidentRelationAttributes.DataType datatype) {
        String expression = null;
        if (datatype == IncidentRelationAttributes.DataType.NUMBER && op != SimpleCondition.Operator.EQUALS && op != SimpleCondition.Operator.NOTEQUALS && op != SimpleCondition.Operator.ISNULL && op != SimpleCondition.Operator.NOTNULL) {
            throw new IllegalArgumentException("Attribute " + displayName + " is a numeric value and only supports the EQUALS, NOTEQUALS, ISNULL and NOTNULL operators");
        }
        if (datatype == IncidentRelationAttributes.DataType.DATE && op != SimpleCondition.Operator.FROM && op != SimpleCondition.Operator.TO) {
            throw new IllegalArgumentException("Attribute " + displayName + " is a date value and only supports the FROM and TO operators");
        }
        if (datatype != IncidentRelationAttributes.DataType.DATE && (op == SimpleCondition.Operator.FROM || op == SimpleCondition.Operator.TO)) {
            throw new IllegalArgumentException("Operator " + (Object)((Object)op) + " is only valid for date attributes");
        }
        expression = !isIncckeyRelation ? name + " " : "key_name='" + name + "' and key_value ";
        if (op == SimpleCondition.Operator.EQUALS || op == SimpleCondition.Operator.NOTEQUALS) {
            String opStr;
            String string = opStr = op == SimpleCondition.Operator.EQUALS ? "=" : "!=";
            if (datatype == IncidentRelationAttributes.DataType.STRING) {
                expression = expression + opStr + " '" + value + "'";
            } else {
                try {
                    Integer.parseInt(value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Attribute " + displayName + " is a numeric value but is being compared to a non-numeric value \"" + value + "\"");
                }
                expression = expression + opStr + " " + value;
            }
        } else if (op == SimpleCondition.Operator.CONTAINS) {
            expression = expression + "like '%" + value + "%'";
        } else if (op == SimpleCondition.Operator.STARTSWITH) {
            expression = expression + "like '" + value + "%'";
        } else if (op == SimpleCondition.Operator.ENDSWITH) {
            expression = expression + "like '%" + value + "'";
        } else if (op == SimpleCondition.Operator.FROM) {
            expression = expression + ">= '" + value + "'";
        } else if (op == SimpleCondition.Operator.TO) {
            expression = expression + "<= '" + value + "'";
        } else if (op == SimpleCondition.Operator.ISNULL) {
            expression = expression + "is null";
        } else if (op == SimpleCondition.Operator.NOTNULL) {
            expression = expression + "is not null";
        }
        return expression;
    }

    private static enum IncidentRelationAttributes {
        ECID("ecid", DataType.STRING),
        MSG_FACILITY("error_facility", DataType.STRING),
        MSG_NUMBER("error_number", DataType.NUMBER),
        TIMESTAMP("create_time", DataType.DATE);

        private String m_adrName;
        private DataType m_datatype;

        private IncidentRelationAttributes(String adrName, DataType datatype) {
            this.m_adrName = adrName;
            this.m_datatype = datatype;
        }

        String getADRName() {
            return this.m_adrName;
        }

        DataType getDataType() {
            return this.m_datatype;
        }

        static IncidentRelationAttributes getAttribute(String name) {
            try {
                return IncidentRelationAttributes.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        static enum DataType {
            STRING,
            NUMBER,
            DATE;

        }
    }

    private class ADROrCondition
    implements ADRCondition {
        private ADRCondition m_c1;
        private ADRCondition m_c2;

        ADROrCondition(ADRCondition c1, ADRCondition c2) {
            this.m_c1 = c1;
            this.m_c2 = c2;
        }

        @Override
        public Set<String> execute(ADRInfo adrInfo) throws DiagnosticsException {
            Set<String> rhIds;
            HashSet<String> ids = null;
            Set<String> lhIds = this.m_c1.execute(adrInfo);
            if (lhIds != null) {
                ids = new HashSet<String>(lhIds);
            }
            if ((rhIds = this.m_c2.execute(adrInfo)) != null) {
                if (ids == null) {
                    ids = new HashSet<String>(rhIds);
                } else {
                    ids.addAll(rhIds);
                }
            }
            return ids;
        }

        public String toString() {
            return "OR Condition:\n   LHQuery: " + this.m_c1.toString() + "\n" + "   RHQuery: " + this.m_c2.toString();
        }
    }

    private class ADRAndCondition
    implements ADRCondition {
        private ADRCondition m_c1;
        private ADRCondition m_c2;

        ADRAndCondition(ADRCondition c1, ADRCondition c2) {
            this.m_c1 = c1;
            this.m_c2 = c2;
        }

        @Override
        public Set<String> execute(ADRInfo adrInfo) throws DiagnosticsException {
            Set<String> rhIds;
            HashSet<String> ids = null;
            Set<String> lhIds = this.m_c1.execute(adrInfo);
            if (lhIds != null && (rhIds = this.m_c2.execute(adrInfo)) != null) {
                ids = new HashSet<String>();
                for (String lhId : lhIds) {
                    if (!rhIds.contains(lhId)) continue;
                    ids.add(lhId);
                }
            }
            return ids;
        }

        public String toString() {
            return "AND Condition:\n   LHQuery: " + this.m_c1.toString() + "\n" + "   RHQuery: " + this.m_c2.toString();
        }
    }

    private class ADRSimpleCondition
    implements ADRCondition {
        private String m_statement;
        private boolean m_isIncidentRelation;
        private boolean m_isProblemRelation;
        private boolean m_isIncKeyNullQuery;
        private static final String KEY_VALUE_IS_NULL = "key_value is null";
        private static final String KEY_VALUE_IS_NOT_NULL = "key_value is not null";
        private static final String QUERY_ALL_INCIDENTS = "query (incident_id) incident -type xml";

        ADRSimpleCondition(String statement) {
            this.m_statement = statement;
            boolean bl = this.m_isIncidentRelation = statement.indexOf("incident -p") > 0;
            if (!this.m_isIncidentRelation) {
                boolean bl2 = this.m_isProblemRelation = statement.indexOf("problem -p") > 0;
            }
            if (!this.m_isIncidentRelation && !this.m_isProblemRelation) {
                this.m_isIncKeyNullQuery = statement.indexOf(KEY_VALUE_IS_NULL) > 0;
            }
        }

        @Override
        public Set<String> execute(ADRInfo adrInfo) throws DiagnosticsException {
            if (ADRQueryExecutor.this.m_logger.isLoggable(Level.FINER)) {
                ADRQueryExecutor.this.m_logger.finer("Executing ADR query \"" + this.m_statement + "\"");
            }
            String statement = this.m_statement;
            boolean isIncRelation = this.m_isIncidentRelation;
            if (this.m_isProblemRelation) {
                Set<String> problemIds = ADRQueryExecutor.this.m_adrHelper.queryProblems(adrInfo, statement);
                if (problemIds != null && problemIds.size() > 0) {
                    StringBuffer query = new StringBuffer("query (incident_id) incident -p \"problem_id in (");
                    boolean first = true;
                    for (String id : problemIds) {
                        if (!first) {
                            query.append(",");
                        }
                        query.append(id);
                        first = false;
                    }
                    query.append(")\" -type xml");
                    statement = query.toString();
                    isIncRelation = true;
                } else {
                    return null;
                }
            }
            if (this.m_isIncKeyNullQuery) {
                Set<String> allIncidents = ADRQueryExecutor.this.m_adrHelper.queryIncidents(adrInfo, QUERY_ALL_INCIDENTS, true);
                if (allIncidents != null && allIncidents.size() > 0) {
                    String nullQuery = statement.replace(KEY_VALUE_IS_NULL, KEY_VALUE_IS_NOT_NULL);
                    Set<String> nullIncidents = ADRQueryExecutor.this.m_adrHelper.queryIncidents(adrInfo, nullQuery, false);
                    if (nullIncidents != null && nullIncidents.size() > 0) {
                        allIncidents.removeAll(nullIncidents);
                    }
                }
                return allIncidents;
            }
            return ADRQueryExecutor.this.m_adrHelper.queryIncidents(adrInfo, statement, isIncRelation);
        }

        public String toString() {
            return this.m_statement;
        }
    }

    private static interface ADRCondition {
        public Set<String> execute(ADRInfo var1) throws DiagnosticsException;
    }
}

