/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.spi.weblogic;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.impl.incident.WrapperException;
import oracle.dfw.incident.DiagnosticsDataExtractor;
import oracle.dfw.incident.ErrorMessage;
import oracle.dfw.incident.IncidentFacts;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;
import weblogic.diagnostics.watch.JMXWatchNotification;
import weblogic.diagnostics.watch.WatchNotification;

class JMXWatchNotificationListener
implements NotificationListener,
NotificationFilter {
    private DiagnosticsDataExtractor m_dde;
    private static final String DFW_NOTIF_TYPE = "oracle.dfw.wldfnotification";
    private static final String WATCH_MSGID = "MSGID";
    private static final String WATCH_MESSAGE = "MESSAGE";
    private static final String WATCH_CONTEXT_ID = "CONTEXTID";
    private static final String WATCH_APP_NAME = "[app:";
    private static final String WATCH_APP_NAME_2 = "appName:'";
    private static final String WATCH_THREAD_ID = "Thread '";
    private static final int DEADLOCKED_THREAD = 394;
    private static final int STUCK_THREAD = 337;
    private static final String BEA_802_MSG_TEXT = "ExecuteRequest failed";
    private static final String BEA_101017_MSG_TEXT = "Root cause of ServletException.";
    private static final String BEA_101020_MSG_TEXT = "Servlet failed with Exception";
    private static final String BEA_101020_1212_MSG_TEXT = "Servlet failed with an Exception";
    private static ThreadMXBean s_bean = ManagementFactory.getThreadMXBean();

    public JMXWatchNotificationListener(DiagnosticsDataExtractor dde) {
        this.m_dde = dde;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        WatchNotification watch = ((JMXWatchNotification)notification).getExtendedInfo();
        try {
            WrapperException wrappedException;
            Map<Object, Object> contextValues;
            String ecid;
            String moduleId;
            String componentId;
            String appName;
            ErrorMessage errMsg;
            Map watchData;
            block56: {
                Map<String, ExecutionContext> contexts;
                block54: {
                    String threadName;
                    block55: {
                        String[] messageId;
                        String watchName;
                        String[] values;
                        watchData = watch.getWatchData();
                        errMsg = null;
                        appName = null;
                        componentId = null;
                        moduleId = null;
                        ecid = null;
                        contextValues = null;
                        wrappedException = null;
                        if (watch.getWatchName() != null && (values = (watchName = watch.getWatchName()).split("#", 3)).length >= 2 && (messageId = values[0].split("-", 2)).length == 2) {
                            int id = -1;
                            try {
                                id = Integer.parseInt(messageId[1]);
                            }
                            catch (NumberFormatException e) {
                                LoggerFactory.getFrameworkLogger().log(Level.FINE, "Unable to parse " + messageId[1] + " as an integer");
                            }
                            if (id > -1) {
                                errMsg = new ErrorMessage(messageId[0], id);
                                if (values.length >= 3) {
                                    appName = values[1];
                                }
                            }
                        }
                        if (errMsg == null && watchData.get(WATCH_MSGID) != null) {
                            try {
                                errMsg = new ErrorMessage((String)watchData.get(WATCH_MSGID));
                            }
                            catch (Throwable t) {
                                LoggerFactory.getFrameworkLogger().log(Level.FINE, "Error message ID " + (String)watchData.get(WATCH_MSGID) + " could not be parsed", t);
                            }
                        }
                        if (errMsg == null) {
                            errMsg = new ErrorMessage("DFW", 99999);
                        }
                        if (!errMsg.getErrorFacility().equals("BEA") && !errMsg.getErrorFacility().equals("WLS") || errMsg.getErrorNumber() != 337 && errMsg.getErrorNumber() != 394) break block54;
                        threadName = null;
                        String messageText = (String)watchData.get(WATCH_MESSAGE);
                        if (messageText != null) {
                            int threadStart = 0;
                            if (errMsg.getErrorNumber() == 394) {
                                threadStart = messageText.indexOf(WATCH_THREAD_ID);
                            }
                            if (threadStart > 0 || errMsg.getErrorNumber() == 337) {
                                int len = 0;
                                int threadEnd = 0;
                                if (errMsg.getErrorNumber() == 337) {
                                    threadEnd = messageText.indexOf(" has been", 0);
                                } else {
                                    len = WATCH_THREAD_ID.length();
                                    threadEnd = messageText.indexOf("'", threadStart + len);
                                }
                                if (threadEnd > threadStart) {
                                    try {
                                        ExecutionContext ctx;
                                        threadName = messageText.substring(threadStart + len, threadEnd);
                                        long threadId = this.getThreadId(threadName);
                                        if (threadId > 0L && (ctx = DMSContextManager.getContext(threadId)) != null) {
                                            ecid = ctx.getECID();
                                            contextValues = ctx.getAllValues();
                                            if (contextValues != null) {
                                                componentId = (String)contextValues.get("ServletURI");
                                            }
                                        }
                                    }
                                    catch (Throwable e) {
                                        LoggerFactory.getFrameworkLogger().log(Level.FINE, "failure parsing thread id from WLDF watch event", e);
                                    }
                                }
                            }
                            if (componentId == null) {
                                int getPostIndex = messageText.indexOf("GET ");
                                int spaceIndex = 4;
                                if (getPostIndex <= 0) {
                                    getPostIndex = messageText.indexOf("POST ");
                                    spaceIndex = 5;
                                }
                                if (getPostIndex > 0 && messageText.length() > getPostIndex + spaceIndex) {
                                    int endOfURI = messageText.indexOf("?", getPostIndex += spaceIndex);
                                    if (endOfURI <= 0 && (endOfURI = messageText.indexOf(" ", getPostIndex)) <= 0) {
                                        endOfURI = messageText.indexOf("HTTP", getPostIndex);
                                    }
                                    if (endOfURI > 0) {
                                        componentId = messageText.substring(getPostIndex, endOfURI);
                                    }
                                }
                            }
                        }
                        if (errMsg.getErrorNumber() != 337) break block55;
                        errMsg.setErrorMessageText("stuck thread detected: " + threadName);
                        break block56;
                    }
                    if (errMsg.getErrorNumber() != 394) break block56;
                    errMsg.setErrorMessageText("deadlocked thread detected: " + threadName);
                    break block56;
                }
                if (watchData.get(WATCH_CONTEXT_ID) != null && ((String)watchData.get(WATCH_CONTEXT_ID)).length() > 0 && (contexts = DMSContextManager.getContexts(ecid = (String)watchData.get(WATCH_CONTEXT_ID))) != null && contexts.size() > 0) {
                    contextValues = new HashMap<String, String>(2);
                    for (ExecutionContext ctx : contexts.values()) {
                        contextValues.putAll(ctx.getAllValues());
                    }
                }
            }
            String messageText = (String)watchData.get(WATCH_MESSAGE);
            if (appName == null && messageText != null) {
                int end;
                int start = messageText.indexOf(WATCH_APP_NAME);
                if (start > 0) {
                    int len = WATCH_APP_NAME.length();
                    end = messageText.indexOf(32, start + len);
                    if (end > 0) {
                        appName = messageText.substring(start + len, end);
                    }
                } else {
                    int len;
                    start = messageText.indexOf(WATCH_APP_NAME_2);
                    if (start > 0 && (end = messageText.indexOf("'", start + (len = WATCH_APP_NAME_2.length()))) > 0) {
                        appName = messageText.substring(start + len, end);
                    }
                }
            }
            if (messageText != null) {
                String stackTrace = null;
                String errorId = errMsg.getErrorFacilityAndNumber();
                if (errorId.equals("BEA-101017") || errorId.equals("WL-101017") || errorId.equals("BEA-802") || errorId.equals("WL-802")) {
                    int idx1;
                    String beaMsgText = BEA_101017_MSG_TEXT;
                    if (errorId.equals("BEA-802") || errorId.equals("WL-802")) {
                        beaMsgText = BEA_802_MSG_TEXT;
                    }
                    if ((idx1 = messageText.indexOf(beaMsgText)) > 0) {
                        int len = beaMsgText.length();
                        if (messageText.charAt(idx1 + len) == '\r') {
                            ++len;
                        }
                        int idx2 = messageText.indexOf(":", idx1 + len + 1);
                        int idx3 = messageText.indexOf("\n", idx1 + len + 1);
                        if (idx3 > 0 && idx3 < idx2) {
                            idx2 = idx3;
                        }
                        if (idx2 > idx1) {
                            moduleId = messageText.substring(idx1 + len + 1, idx2);
                            stackTrace = messageText.substring(idx1 + len);
                        }
                    }
                } else if (errorId.equals("BEA-101020") || errorId.equals("WL-101020")) {
                    int idx1 = messageText.indexOf(BEA_101020_MSG_TEXT);
                    int len = BEA_101020_MSG_TEXT.length();
                    if (idx1 <= 0) {
                        idx1 = messageText.indexOf(BEA_101020_1212_MSG_TEXT);
                        len = BEA_101020_1212_MSG_TEXT.length();
                    }
                    if (idx1 > 0) {
                        if (messageText.charAt(idx1 + len) == '\r') {
                            ++len;
                        }
                        int idx2 = messageText.indexOf(":", idx1 + len + 1);
                        int idx3 = messageText.indexOf("\n", idx1 + len + 1);
                        if (idx3 > 0 && idx3 < idx2) {
                            idx2 = idx3;
                        }
                        if (idx2 > idx1) {
                            moduleId = messageText.substring(idx1 + len + 1, idx2);
                            stackTrace = messageText.substring(idx1 + len);
                        }
                    }
                }
                if (moduleId != null && stackTrace != null) {
                    wrappedException = new WrapperException(moduleId, stackTrace);
                }
            }
            StringBuffer sb = new StringBuffer();
            sb.append("Incident detected using watch rule \"");
            sb.append(watch.getWatchName());
            sb.append("\":\nWatch time:             ");
            sb.append(watch.getWatchTime());
            sb.append("\nWatch ServerName:       ");
            sb.append(watch.getWatchServerName());
            sb.append("\nWatch RuleType:         ");
            sb.append(watch.getWatchRuleType());
            sb.append("\nWatch Rule:             ");
            sb.append(watch.getWatchRule());
            sb.append("\nWatch DomainName:       ");
            sb.append(watch.getWatchDomainName());
            sb.append("\nWatch Data:");
            for (Object name : watchData.keySet()) {
                String sname = (String)name;
                sb.append("\n");
                sb.append("   ");
                sb.append(sname);
                sb.append(" : ");
                sb.append(watchData.get(name));
                if (componentId != null || !sname.equals("SUBSYSTEM")) continue;
                componentId = (String)watchData.get(name);
            }
            sb.append("\n");
            IncidentFacts facts = null;
            if (wrappedException != null) {
                facts = IncidentFacts.createUnhandledExceptionIncidentFacts(notification.getTimeStamp(), appName, componentId, moduleId, false, wrappedException);
            } else {
                if (watch.getWatchName() != null && watch.getWatchName().equals("HeapSpace")) {
                    componentId = "LowMemory";
                }
                facts = IncidentFacts.createSystemIncidentFacts(notification.getTimeStamp(), errMsg, null, null);
                facts.setSynchronous(false);
                facts.setComponentModuleId(componentId, moduleId);
                facts.setApplicationName(appName);
            }
            facts.setDescription(sb.toString());
            facts.setExecutionContextId(ecid);
            facts.setContextValue("DFW_WATCH_RULE", watch.getWatchRule());
            facts.setContextValue("DFW_WATCH_NAME", watch.getWatchName());
            if (contextValues != null) {
                for (Map.Entry<Object, Object> contextNV : contextValues.entrySet()) {
                    facts.setContextValue((String)contextNV.getKey(), (String)contextNV.getValue());
                }
            }
            this.m_dde.createIncident(facts, false);
        }
        catch (Throwable e) {
            LoggerFactory.getFrameworkLogger().log(Level.WARNING, "DFW-40121", e);
        }
    }

    @Override
    public boolean isNotificationEnabled(Notification notification) {
        return notification instanceof JMXWatchNotification && notification.getType().compareTo(DFW_NOTIF_TYPE) == 0;
    }

    private long getThreadId(final String threadName) {
        if (s_bean == null) {
            return 0L;
        }
        long threadId = AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                long foundId = 0L;
                for (ThreadInfo info : s_bean.getThreadInfo(s_bean.getAllThreadIds(), 0)) {
                    if (!threadName.equals(info.getThreadName())) continue;
                    foundId = info.getThreadId();
                    break;
                }
                return foundId;
            }
        });
        return threadId;
    }
}

