/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.spi.weblogic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.ResourceBundle;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.impl.dump.ExternalUtility;
import oracle.dfw.resource.DiagnosticTranslation;
import weblogic.diagnostics.integration.DiagnosticIntegrationManager;

public class WLDFImageDump
extends ComponentDiagnosticDump {
    private static final long LOCKOUT_PERIOD = 900000L;
    private volatile String m_lastImageFile;
    private long m_lastRan = 0L;
    private Object LOCK = new Object();
    private DiagnosticIntegrationManager m_diagMgr = DiagnosticIntegrationManager.Factory.getInstance();
    private static final String DFW_MESSAGES = DiagnosticTranslation.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DumpResult executeDump(DumpContext context) throws DumpExecutionException {
        File lastFile;
        String filename = null;
        boolean captureImage = false;
        Object object = this.LOCK;
        synchronized (object) {
            long timeNow = System.currentTimeMillis();
            if (this.m_lastImageFile == null || !new File(this.m_lastImageFile).exists() || timeNow - this.m_lastRan > 900000L) {
                captureImage = true;
                this.m_lastRan = timeNow;
            }
        }
        if (captureImage) {
            object = ExternalUtility.getExecuteLock();
            synchronized (object) {
                try {
                    String generatedFile = this.m_diagMgr.captureImage(context.getDumpPath(), true, 0L);
                    File imageFile = new File(generatedFile);
                    if (WLDFImageDump.exists(imageFile)) {
                        filename = imageFile.getName();
                        this.m_lastImageFile = imageFile.getAbsolutePath();
                    }
                }
                catch (Exception e) {
                    throw new DumpExecutionException("failure capturing WebLogic Server image", e);
                }
            }
        }
        if (this.m_lastImageFile != null && WLDFImageDump.exists(lastFile = new File(this.m_lastImageFile))) {
            File destFile = null;
            try {
                destFile = context.generateUniqueFile("zip");
                WLDFImageDump.copyFile(lastFile, destFile);
                filename = destFile.getName();
            }
            catch (Exception e) {
                throw new DumpExecutionException("failure copying WebLogic Server image file " + lastFile.getAbsolutePath() + " to " + destFile, e);
            }
        }
        if (filename == null) {
            throw new DumpExecutionException("WebLogic server image file not available");
        }
        return new DumpResult(context, filename);
    }

    private static boolean exists(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File source, File dest) throws IOException {
        FileChannel in = null;
        FileChannel out = null;
        try {
            in = WLDFImageDump.getFileInputStream(source).getChannel();
            out = WLDFImageDump.getFileOutputStream(dest).getChannel();
            long size = in.size();
            MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            out.write(buf);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private static FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    private static FileOutputStream getFileOutputStream(final File file) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    @Override
    public String getOwner() {
        return "wls";
    }

    @Override
    public String getName() {
        return "image";
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return EnumSet.of(DiagnosticsCategory.CONFIGURATION, new DiagnosticsCategory[]{DiagnosticsCategory.LOGGING, DiagnosticsCategory.MEMORY, DiagnosticsCategory.NETWORK, DiagnosticsCategory.PERFORMANCE, DiagnosticsCategory.THREADS});
    }

    @Override
    public String getDumpDescription() {
        try {
            return ResourceBundle.getBundle(DFW_MESSAGES).getString("DFW_WLDF_DESCRIPTION");
        }
        catch (Exception e) {
            return "Dumps the WLDF (WebLogic Diagnostics Framework) server image dump.";
        }
    }
}

