/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.spi.weblogic;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.core.ojdl.logging.LogUtil;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.framework.DiagnosticsFrameworkProvider;
import oracle.dfw.impl.common.SecurityContext;
import oracle.dfw.incident.DiagnosticsDataExtractor;
import oracle.dfw.spi.portable.DiagnosticsFrameworkPlatformExtension;
import oracle.dfw.spi.weblogic.JMXWatchNotificationListener;
import oracle.dfw.spi.weblogic.SecurityContextImpl;
import oracle.dfw.spi.weblogic.WLDFImageDump;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.ServerPlatformSupportFactory;

public class WebLogicDiagnosticsFrameworkExtension
implements DiagnosticsFrameworkPlatformExtension {
    private String m_productId = "domain";
    private String m_instanceId = "server";
    private String m_serverName;
    private String m_domainName;
    private String m_adrBase;
    private String m_serverConfigPath;
    private String m_domainConfigPath;
    private boolean m_isAdminServer;
    private ServerPlatformSupport m_jrf = ServerPlatformSupportFactory.getInstance();
    private WLDFImageDump m_wldfImageDump;
    private static final String COMMON_COMPONENTS_HOME = "common.components.home";
    private static final String CONFIG_FILE = "dfw_config.xml";
    private static final String WLS_DIAG_RULES = "oracle/dfw/spi/weblogic/wls-rules.xml";
    private static final long WLDF_REGISTRATION_TIMEOUT = 300000L;
    private static final long WLDF_REGISTRATION_PERIOD = 15000L;

    public WebLogicDiagnosticsFrameworkExtension() throws Exception {
        this.setPropertiesFromServer();
    }

    @Override
    public String getOracleHome() {
        File adrHome;
        String oracleHome = null;
        String commonHome = WebLogicDiagnosticsFrameworkExtension.getProperty(COMMON_COMPONENTS_HOME, null);
        if (commonHome != null && commonHome.length() > 0 && WebLogicDiagnosticsFrameworkExtension.exists(adrHome = new File(commonHome, "adr"))) {
            oracleHome = adrHome.getAbsolutePath();
        }
        return oracleHome;
    }

    @Override
    public String getADRBase() {
        return this.m_adrBase;
    }

    @Override
    public String getProductId() {
        return this.m_productId;
    }

    @Override
    public String getInstanceId() {
        return this.m_instanceId;
    }

    @Override
    public File getDiagnosticsConfigFile() {
        return new File(this.m_serverConfigPath + File.separator + CONFIG_FILE);
    }

    @Override
    public File[] getCustomRuleDirs() {
        return new File[]{new File(this.m_domainConfigPath, "dfw"), new File(this.m_serverConfigPath, "dfw")};
    }

    @Override
    public SecurityContext getSecurityContext() {
        SecurityContextImpl secContext = null;
        try {
            secContext = new SecurityContextImpl();
        }
        catch (Exception e) {
            LoggerFactory.getFrameworkLogger().log(Level.WARNING, "DFW-40203", e);
        }
        return secContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupExtension(DiagnosticsFrameworkProvider dfw, Map<String, String> properties) {
        if (dfw.getDDE() != null && this.m_serverName != null && this.m_serverName.length() > 0) {
            this.registerWatchNotificationListener(dfw.getDDE());
            InputStreamReader isr = null;
            try {
                InputStream rulesStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        this.getClass().getClassLoader();
                        return ClassLoader.getSystemResourceAsStream(WebLogicDiagnosticsFrameworkExtension.WLS_DIAG_RULES);
                    }
                });
                isr = new InputStreamReader(rulesStream);
                dfw.getDDE().registerRules(isr, "wls-rules", true, null);
            }
            catch (Exception e) {
                LogUtil.log((Logger)LoggerFactory.getFrameworkLogger(), (Level)Level.WARNING, (String)"DFW-40206", (Object[])new Object[]{WLS_DIAG_RULES}, (Throwable)e);
            }
            finally {
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (Exception e) {
                        LoggerFactory.getFrameworkLogger().log(Level.FINEST, "failure closing stream for oracle/dfw/spi/weblogic/wls-rules.xml", e);
                    }
                }
            }
        }
        if (dfw.getDumpManager() != null) {
            try {
                this.m_wldfImageDump = new WLDFImageDump();
                dfw.getDumpManager().registerDump(this.m_wldfImageDump, true, null);
            }
            catch (Throwable t) {
                LoggerFactory.getFrameworkLogger().log(Level.WARNING, "failure registering WebLogic Diagnostic Image dump", t);
            }
        }
        if (this.m_serverName != null) {
            properties.put("DFW_SERVER_NAME", this.m_serverName);
        }
        if (this.m_domainName != null) {
            properties.put("DFW_DOMAIN_NAME", this.m_domainName);
        }
    }

    private void registerWatchNotificationListener(DiagnosticsDataExtractor dde) {
        final JMXWatchNotificationListener listener = new JMXWatchNotificationListener(dde);
        Runnable registrationRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    ObjectName oname = new ObjectName("com.bea:ServerRuntime=" + WebLogicDiagnosticsFrameworkExtension.this.m_serverName + ",Name=" + "DiagnosticsJMXNotificationSource" + ",Type=WLDFWatchJMXNotificationRuntime," + "WLDFWatchNotificationRuntime=WatchNotification," + "WLDFRuntime=WLDFRuntime");
                    Thread.sleep(15000L);
                    long abortTime = System.currentTimeMillis() + 300000L;
                    boolean retry = true;
                    while (retry) {
                        try {
                            WebLogicDiagnosticsFrameworkExtension.getMBeanServer().addNotificationListener(oname, listener, (NotificationFilter)listener, null);
                            retry = false;
                        }
                        catch (InterruptedException ie) {
                            throw ie;
                        }
                        catch (Exception e) {
                            LoggerFactory.getFrameworkLogger().log(Level.FINER, "unable to register diagnostic framework watch notification listener", e);
                        }
                        if (retry) {
                            if (System.currentTimeMillis() >= abortTime) {
                                LoggerFactory.getFrameworkLogger().log(Level.FINE, "unable to register diagnostic framework watch notification listener");
                                retry = false;
                                continue;
                            }
                            Thread.sleep(15000L);
                            continue;
                        }
                        LoggerFactory.getFrameworkLogger().log(Level.FINE, "registerd diagnostic framework watch notification listener");
                    }
                }
                catch (Throwable t) {
                    LoggerFactory.getFrameworkLogger().log(Level.FINE, "unable to register diagnostic framework watch notification listener", t);
                }
            }
        };
        Thread thread = new Thread(registrationRunner);
        thread.setDaemon(true);
        thread.setName("oracle.dfw.spi.WebLogicDiagnosticsFrameworkExtension - WLDF watch notfication registration thread");
        thread.start();
    }

    private void setPropertiesFromServer() throws Exception {
        this.m_productId = this.m_domainName = this.m_jrf.getDomainName();
        this.m_instanceId = this.m_serverName = this.m_jrf.getServerName();
        this.m_isAdminServer = this.m_jrf.isAdminServer();
        String domainHome = WebLogicDiagnosticsFrameworkExtension.getProperty("domain.home", null);
        if (domainHome != null && domainHome.length() > 0) {
            String base = domainHome + File.separatorChar + "servers" + File.separatorChar + this.m_serverName + File.separatorChar + "adr";
            File adrHome = new File(base);
            this.m_adrBase = adrHome.getCanonicalPath();
        } else {
            File serverHome = new File(this.m_jrf.getServerLogPath()).getParentFile();
            File adrHome = new File(serverHome, "adr");
            this.m_adrBase = adrHome.getCanonicalPath();
        }
        this.m_serverConfigPath = this.m_jrf.getServerConfigDirectory(null, this.m_serverName);
        this.m_domainConfigPath = this.m_jrf.getDomainConfigDirectory();
    }

    private static Object getMBeanAttribute(final MBeanServer server, final ObjectName objectName, final String attributeName) throws Exception {
        Object retVal = null;
        try {
            retVal = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return server.getAttribute(objectName, attributeName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        return retVal;
    }

    private static MBeanServer getMBeanServer() throws Exception {
        InitialContext ctx = new InitialContext();
        try {
            return (MBeanServer)ctx.lookup("java:comp/jmx/runtime");
        }
        catch (NamingException e) {
            return (MBeanServer)ctx.lookup("java:comp/env/jmx/runtime");
        }
    }

    private static String getProperty(final String key, final String def) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, def);
            }
        });
    }

    private static boolean exists(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
    }
}

