/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.as.config.notification.DocumentChangeListener;
import oracle.as.config.notification.DocumentChangeNotifierFactory;
import oracle.as.config.notification.DocumentChangedEvent;
import oracle.as.jmx.framework.annotations.Inject;
import oracle.as.jmx.framework.services.EventBroadcaster;
import oracle.as.jmx.framework.services.JMXSupport;
import oracle.as.jmx.framework.util.ConfigMBeanSupport;
import oracle.as.management.exception.ASException;
import oracle.core.ojdl.logging.ODLLogger;
import oracle.dms.config.Config;
import oracle.dms.config.ConfigResourceBundle;
import oracle.dms.config.DMSConfigMBean;
import oracle.dms.config.DMSConfigurationException;
import oracle.dms.config.parameter.DMSParameterConfigMBean;
import oracle.dms.config.parameter.JMXDMSParameterConfig;
import oracle.dms.config.paramscopedmetrics.ParamScopedMetricsConfigMXBean;
import oracle.dms.config.paramscopedmetrics.ParamScopedMetricsConfigMXBeanImpl;
import oracle.dms.console.DMSConsole;
import oracle.dms.event.config.EventConfigMBean;
import oracle.dms.event.config.JMXEventConfig;
import oracle.dms.util.Platform;
import oracle.dms.util.PlatformSupportFactory;

public class JMXDMSConfig
extends ConfigMBeanSupport
implements DMSConfigMBean,
MBeanRegistration,
DocumentChangeListener {
    public Config m_runtimeConfig = null;
    private String mMyIdForLogging = null;
    private String m_serverName = null;
    private volatile boolean m_isConfigUpdated;
    private static volatile boolean s_configValid = false;
    private static final String CLASS_NAME = JMXDMSConfig.class.getName();
    private Config m_liveConfig = null;
    private static ODLLogger s_logger = ODLLogger.getODLLogger((String)"oracle.dms.config", (String)ConfigResourceBundle.class.getName());
    private String m_accessLevel = null;
    private JMXSupport m_jmxSupport = null;
    private JMXEventConfig m_eventConfigMBean = null;
    private JMXDMSParameterConfig m_parameterConfigMBean = null;
    private ParamScopedMetricsConfigMXBeanImpl m_paramScopedMetricsConfigMBean = null;
    private EventBroadcaster m_eventBroadcaster = null;
    private List<ObjectName> m_childObjectName = new ArrayList<ObjectName>(3);

    public JMXDMSConfig() {
        String METHOD_NAME = "JMXDMSConfig";
        if (s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, CLASS_NAME, "JMXDMSConfig", "Constructor");
        }
    }

    public void setConfiguration(Config config) {
        this.m_liveConfig = config;
        if (this.m_liveConfig == null) {
            JMXDMSConfig.setConfigValid(false);
        } else {
            JMXDMSConfig.setConfigValid(true);
        }
    }

    private String accessLevel() {
        if (this.m_accessLevel == null) {
            this.m_accessLevel = this.getJMXSupport().isReadOnly() ? "RO" : "RW";
        }
        return this.m_accessLevel;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.getJMXSupport().isReadOnly()) {
            DocumentChangeNotifierFactory.getInstance().getNotifier().addDocumentChangeListener(this.getConfigURL().toURI(), (DocumentChangeListener)this);
        }
        return super.preRegister(server, name);
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue()) {
            this.registerChildMBeans();
        }
    }

    @Override
    public void preDeregister() throws Exception {
        this.unregisterChildMBeans();
    }

    private void unregisterChildMBeans() throws Exception {
        String METHOD_NAME = "unregisterChildMBeans";
        for (ObjectName oname : this.m_childObjectName) {
            this.m_jmxSupport.getMBeanFactorySupport().unregisterChildConfigMBean(oname);
            s_logger.logp(Level.FINER, CLASS_NAME, "unregisterChildMBeans", this.getMyIdForLogging() + " unregistered child MBean for " + oname.toString());
        }
    }

    private void registerChildMBeans() {
        block3: {
            String METHOD_NAME = "registerChildMBeans";
            s_logger.logp(Level.FINER, CLASS_NAME, "registerChildMBeans", this.getMyIdForLogging() + "; start.");
            try {
                this.validateConfig();
                if (this.m_jmxSupport != null) {
                    ObjectName parameterConfigName = new ObjectName("oracle.dms:type=ParameterConfig,name=ParameterConfig");
                    this.m_childObjectName.add(this.getJMXSupport().translateObjectNameToGlobalNameSpace(parameterConfigName));
                    this.m_parameterConfigMBean = new JMXDMSParameterConfig(this.m_liveConfig.getParamConfig());
                    this.m_jmxSupport.getMBeanFactorySupport().createAndRegisterChildConfigMBean((Object)this.m_parameterConfigMBean, DMSParameterConfigMBean.class, parameterConfigName);
                    s_logger.logp(Level.FINER, CLASS_NAME, "registerChildMBeans", this.getMyIdForLogging() + " registered child MBean for " + parameterConfigName.toString());
                    ObjectName eventConfigName = new ObjectName("oracle.dms.event.config:type=JMXEventConfig,name=DMSEventConfigMBean");
                    this.m_childObjectName.add(this.getJMXSupport().translateObjectNameToGlobalNameSpace(eventConfigName));
                    this.m_eventConfigMBean = new JMXEventConfig(this.m_liveConfig.getEventConfig());
                    this.m_jmxSupport.getMBeanFactorySupport().createAndRegisterChildConfigMBean((Object)this.m_eventConfigMBean, EventConfigMBean.class, eventConfigName);
                    s_logger.logp(Level.FINER, CLASS_NAME, "registerChildMBeans", this.getMyIdForLogging() + " registered child MBean for " + eventConfigName.toString());
                    ObjectName paramScopedMetricsConfigName = new ObjectName("oracle.dms:type=oracle.dms.config.ParamScopedMetricsConfigMXBean,name=ParamScopedMetrics");
                    this.m_childObjectName.add(this.getJMXSupport().translateObjectNameToGlobalNameSpace(paramScopedMetricsConfigName));
                    this.m_paramScopedMetricsConfigMBean = new ParamScopedMetricsConfigMXBeanImpl(this.m_liveConfig.getParamScopedMetricsConfig());
                    this.m_jmxSupport.getMBeanFactorySupport().createAndRegisterChildConfigMBean((Object)this.m_paramScopedMetricsConfigMBean, ParamScopedMetricsConfigMXBean.class, paramScopedMetricsConfigName);
                    s_logger.logp(Level.FINER, CLASS_NAME, "registerChildMBeans", this.getMyIdForLogging() + " registered child MBean for " + paramScopedMetricsConfigName.toString());
                }
            }
            catch (Exception e) {
                if (!s_logger.isLoggable(Level.WARNING)) break block3;
                s_logger.logp(Level.WARNING, CLASS_NAME, "registerChildMBeans", "DMS_58076", (Object[])new String[]{this.getServerName(), this.accessLevel()}, (Throwable)e);
            }
        }
        s_logger.logp(Level.FINER, CLASS_NAME, "registerChildMBeans", this.getMyIdForLogging() + "; end.");
    }

    @Inject
    public void setJMXSupport(JMXSupport jmxSupport) {
        this.m_jmxSupport = jmxSupport;
    }

    protected JMXSupport getJMXSupport() {
        if (this.m_jmxSupport == null) {
            this.m_jmxSupport = this.getJMXSupport();
        }
        return this.m_jmxSupport;
    }

    public boolean documentAdded(DocumentChangedEvent documentChangedEvent) {
        s_logger.logp(Level.FINER, CLASS_NAME, "documentAdded", this.getMyIdForLogging());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean documentChanged(DocumentChangedEvent documentChangedEvent) throws Exception {
        String METHOD_NAME = "documentChanged";
        InputStream inputStream = null;
        s_logger.logp(Level.FINER, CLASS_NAME, "documentChanged", this.getMyIdForLogging() + "; start");
        try {
            inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return JMXDMSConfig.this.getDataSource().getInputStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        if (this.m_liveConfig == null) {
            throw ASException.toException(new DMSConfigurationException("DMS-58068"), Exception.class);
        }
        JMXDMSConfig.setConfigValid(true);
        try {
            URL url = this.getConfigURL();
            String filename = url.getFile();
            Config updateConfig = new Config(filename, inputStream);
            s_logger.logp(Level.FINER, CLASS_NAME, "documentChanged", this.getMyIdForLogging() + "; sync'ing live config.");
            this.m_liveConfig.sync(updateConfig);
            this.reloadROMBeanConfig();
            if (this.m_runtimeConfig != null) {
                s_logger.logp(Level.FINER, CLASS_NAME, "documentChanged", this.getMyIdForLogging() + "; sync'ing runtime config.");
                this.m_runtimeConfig.sync(updateConfig);
            }
            this.sendEvent();
        }
        catch (Exception e) {
            s_logger.logp(Level.WARNING, CLASS_NAME, "documentChanged", "DMS-58023", (Throwable)e);
        }
        finally {
            inputStream.close();
        }
        s_logger.logp(Level.FINER, CLASS_NAME, "documentChanged", this.getMyIdForLogging() + "; end.");
        return true;
    }

    public boolean documentRemoved(DocumentChangedEvent documentChangedEvent) {
        s_logger.logp(Level.FINER, CLASS_NAME, "documentRemoved", this.getMyIdForLogging());
        return true;
    }

    private void validateConfig() throws Exception {
        String METHOD_NAME = "isConfigValid";
        s_logger.logp(Level.FINER, CLASS_NAME, "isConfigValid", this.getMyIdForLogging() + "; Status of Config is " + s_configValid);
        if (!s_configValid) {
            throw ASException.toException(new DMSConfigurationException("DMS-58069", this.getServerName()), Exception.class);
        }
    }

    private static void setConfigValid(boolean status) {
        s_logger.logp(Level.FINER, CLASS_NAME, "setConfigValid(static)", Boolean.toString(status));
        s_configValid = status;
    }

    protected void doSave() {
        block2: {
            String METHOD_NAME = "doSave";
            s_logger.logp(Level.FINER, CLASS_NAME, "doSave", this.getMyIdForLogging() + "; start");
            try {
                this.saveConfig();
            }
            catch (Exception e) {
                if (!s_logger.isLoggable(Level.WARNING)) break block2;
                s_logger.logp(Level.WARNING, CLASS_NAME, "doSave", "DMS_58077", (Object[])new String[]{this.getServerName(), this.accessLevel()}, (Throwable)e);
            }
        }
        s_logger.logp(Level.FINER, CLASS_NAME, "doSave", this.getMyIdForLogging() + "; end");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveConfig() throws Exception {
        String METHOD_NAME = "saveConfig";
        s_logger.logp(Level.FINER, CLASS_NAME, "saveConfig", this.getMyIdForLogging() + "; start");
        if (this.m_liveConfig == null) {
            throw new Exception("DMS-58066");
        }
        OutputStream outputStream = null;
        try {
            outputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                @Override
                public OutputStream run() throws IOException {
                    return JMXDMSConfig.this.getDataSource().getOutputStream();
                }
            });
            this.m_liveConfig.save(outputStream);
            s_logger.logp(Level.FINER, CLASS_NAME, "saveConfig", this.getMyIdForLogging() + "; saved live config to file.");
            this.resetChildConfigSavedFlags();
            this.m_eventConfigMBean.resetConfigUpdated();
            this.m_isConfigUpdated = false;
            if (PlatformSupportFactory.getPlatformSupport().getPlatform() == Platform.WebSphereAS) {
                s_logger.logp(Level.FINER, CLASS_NAME, "saveConfig", this.getMyIdForLogging() + "; special case invocation of documentChanged.");
                this.documentChanged(null);
            }
        }
        catch (PrivilegedActionException e) {
            try {
                s_logger.logp(Level.WARNING, CLASS_NAME, "saveConfig", "DMS_59001", (Object[])new String[]{this.getServerName()}, (Throwable)e.getException());
                throw e.getException();
                catch (DMSConfigurationException e2) {
                    s_logger.logp(Level.WARNING, CLASS_NAME, "saveConfig", "DMS-58023", (Throwable)e2);
                    DMSConfigurationException c = new DMSConfigurationException("failure saving the configuration for server " + this.getServerName() + " id: " + this + " R/W: " + this.accessLevel(), e2);
                    throw ASException.toException(c, Exception.class);
                }
            }
            catch (Throwable throwable) {
                try {
                    outputStream.close();
                    throw throwable;
                }
                catch (Exception e3) {
                    s_logger.logp(Level.WARNING, CLASS_NAME, "saveConfig", "DMS-58023", (Object[])new String[]{this.getServerName()}, (Throwable)e3);
                    DMSConfigurationException ec = new DMSConfigurationException("DMS-58023", this.getServerName(), e3);
                    throw ASException.toException(ec, Exception.class);
                }
            }
        }
        try {
            outputStream.close();
        }
        catch (Exception e) {
            s_logger.logp(Level.WARNING, CLASS_NAME, "saveConfig", "DMS-58023", (Object[])new String[]{this.getServerName()}, (Throwable)e);
            DMSConfigurationException ec = new DMSConfigurationException("DMS-58023", this.getServerName(), e);
            throw ASException.toException(ec, Exception.class);
        }
        s_logger.logp(Level.FINER, CLASS_NAME, "saveConfig", this.getMyIdForLogging() + "; end");
    }

    private void resetChildConfigSavedFlags() {
        if (this.m_liveConfig != null) {
            this.m_liveConfig.getEventConfig().setConfigurationUpdated(false);
            this.m_liveConfig.getEventConfig().setConfigurationActivated(false);
            this.m_liveConfig.getParamConfig().setConfigurationUpdated(false);
            this.m_liveConfig.getParamScopedMetricsConfig().setConfigurationUpdated(false);
        }
    }

    private String getServerName() {
        JMXSupport jmxSupport = this.getJMXSupport();
        if (this.m_serverName == null && jmxSupport != null) {
            this.m_serverName = this.accessLevel().equals("RW") ? jmxSupport.getObjectName().getKeyProperty("ServerName") : jmxSupport.getObjectName().getKeyProperty("Location");
        }
        return this.m_serverName;
    }

    private String getMyIdForLogging() {
        JMXSupport jmxSupport;
        if (this.mMyIdForLogging == null && (jmxSupport = this.getJMXSupport()) != null) {
            this.mMyIdForLogging = " Server(" + (Object)((Object)PlatformSupportFactory.getPlatformSupport().getPlatform()) + "): " + this.getServerName() + " id: " + this + " R/W: " + this.accessLevel();
        }
        return this.mMyIdForLogging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        String METHOD_NAME = "load";
        s_logger.logp(Level.FINER, CLASS_NAME, "load", this.getMyIdForLogging() + "; start");
        JMXDMSConfig.setConfigValid(true);
        if (this.m_runtimeConfig == null && this.getJMXSupport().isReadOnly()) {
            s_logger.logp(Level.FINER, CLASS_NAME, "load", this.getMyIdForLogging() + "; fetching runtime config from DMSConsole.");
            this.m_runtimeConfig = DMSConsole.getConsole().getConfig();
        }
        if (this.m_isConfigUpdated || this.m_eventConfigMBean != null && this.m_eventConfigMBean.isConfigUpdated()) {
            s_logger.logp(Level.FINER, CLASS_NAME, "load", this.getMyIdForLogging() + "; The DMS configuration has not been reloaded due to pending changes.");
        } else {
            URL url = this.getConfigURL();
            String filename = url.getFile();
            InputStream inputStream = null;
            try {
                inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        return JMXDMSConfig.this.getDataSource().getInputStream();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                JMXDMSConfig.setConfigValid(false);
                s_logger.logp(Level.WARNING, CLASS_NAME, "load", "DMS-58042", (Throwable)e);
                throw (IOException)e.getException();
            }
            try {
                if (!this.getJMXSupport().isReadOnly() || this.m_liveConfig == null) {
                    s_logger.logp(Level.FINER, CLASS_NAME, "load", this.getMyIdForLogging() + "; creating new Config from file.");
                    this.m_liveConfig = new Config(filename, inputStream);
                    this.setConfiguration(this.m_liveConfig);
                    if (this.m_eventConfigMBean != null) {
                        this.m_eventConfigMBean.resetConfigUpdated();
                    }
                }
            }
            catch (Exception e) {
                JMXDMSConfig.setConfigValid(false);
                if (s_logger.isLoggable(Level.WARNING)) {
                    s_logger.logp(Level.WARNING, CLASS_NAME, "load", "DMS-58021", (Object[])new String[]{filename}, (Throwable)e);
                    s_logger.logp(Level.WARNING, CLASS_NAME, "load", "DMS-58042", (Throwable)e);
                }
                s_logger.logp(Level.FINER, CLASS_NAME, "load", this.getMyIdForLogging() + "; failure loading DMS configuration file.");
            }
            finally {
                inputStream.close();
            }
        }
        s_logger.logp(Level.FINER, CLASS_NAME, "load", this.getMyIdForLogging() + "; end.");
    }

    private void reloadROMBeanConfig() throws Exception {
        String METHOD_NAME = "reloadROMBeanConfig";
        s_logger.logp(Level.FINER, CLASS_NAME, "reloadROMBeanConfig", this.getMyIdForLogging() + "; start.");
        if (this.m_liveConfig != null) {
            if (this.m_eventConfigMBean != null) {
                s_logger.logp(Level.FINER, CLASS_NAME, "reloadROMBeanConfig", this.getMyIdForLogging() + "; updating event config mbean.");
                this.m_eventConfigMBean.update(this.m_liveConfig.getEventConfig());
            }
            if (this.m_parameterConfigMBean != null) {
                s_logger.logp(Level.FINER, CLASS_NAME, "reloadROMBeanConfig", this.getMyIdForLogging() + "; updating param config mbean.");
                this.m_parameterConfigMBean.update(this.m_liveConfig.getParamConfig());
            }
            if (this.m_paramScopedMetricsConfigMBean != null) {
                s_logger.logp(Level.FINER, CLASS_NAME, "reloadROMBeanConfig", this.getMyIdForLogging() + "; updating p.s.m. config mbean.");
                this.m_paramScopedMetricsConfigMBean.update(this.m_liveConfig.getParamScopedMetricsConfig());
            }
        }
        s_logger.logp(Level.FINER, CLASS_NAME, "reloadROMBeanConfig", this.getMyIdForLogging() + "; end.");
    }

    @Inject
    public void setEventBroadcaster(EventBroadcaster eventBroadcaster) {
        this.m_eventBroadcaster = eventBroadcaster;
    }

    @Deprecated
    public void sendEvent() {
        s_logger.logp(Level.FINER, CLASS_NAME, "sendEvent", this.getMyIdForLogging() + "; start");
        this.m_eventBroadcaster.sendManagementEvent("config.changed", "config.change", (Object)this);
        s_logger.logp(Level.FINER, CLASS_NAME, "sendEvent", this.getMyIdForLogging() + "; end");
    }
}

