/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context.internal;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.context.ContextContent;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ECForJDBC;
import oracle.dms.context.ExecutionContext;
import oracle.dms.context.RID;
import oracle.dms.context.WrapOptions;
import oracle.dms.context.internal.ContextParameterDescriptorInternal;
import oracle.dms.context.internal.DomainContextFamily;
import oracle.dms.context.internal.DomainContextManager;
import oracle.dms.context.internal.DomainExecutionContext;
import oracle.dms.context.internal.ImmutableExecutionContext;
import oracle.dms.context.internal.ParameterValueListener;
import oracle.dms.context.internal.WrapUtils;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventReportingManager;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.EventSystem;
import oracle.dms.util.ClassUtils;
import oracle.dms.util.Time;

public abstract class AbstractExecutionContext<M extends DomainContextManager<F, C>, F extends DomainContextFamily<C>, C extends DomainExecutionContext> {
    protected M mContextManager;
    protected F mContextFamily;
    protected String mECID = null;
    protected RID mRID = null;
    protected boolean mInheritable = true;
    protected boolean mSuspended = false;
    protected long mActivationTime = -1L;
    protected final Logger sLogger = DMSContextManager.getLogger();
    protected ECForJDBC mJDBCContext = null;
    protected HashMap<String, String> mCtxLocalMap = null;
    protected HashMap<String, ContextContent> mCtxContentMap = null;
    protected Map<String, String> mCtxGlobalMap = null;
    protected C mPusher = null;
    protected boolean mUpdateSqlText = true;
    protected Set<ParameterValueListener> mValueListeners = null;
    private String mIDAsString;
    private ExecutionContext mThisAsMutableExecutionContext = null;
    private ImmutableExecutionContext mThisAsImmutableExecutionContext = null;
    private EnumMap<DomainExecutionContext.ObjectCacheKey, Object> mObjectCache;

    protected AbstractExecutionContext(M mgr, F family, RID r) {
        if (mgr == null || family == null || r == null) {
            throw new IllegalArgumentException("None of the constructor's arguments is allowed to be null: \n  mgr    = " + mgr + "\n  family = " + family + "\n  r      = " + r);
        }
        this.mContextManager = mgr;
        this.mContextFamily = family;
        this.mECID = family.getECID();
        this.mRID = r;
        this.mCtxGlobalMap = new HashMap<String, String>();
        if (this.sLogger.isLoggable(Level.FINER)) {
            this.sLogger.log(Level.FINER, "New AbstractExecutionContext created [{0}, {1}] - invoked with stack:\n{2}", new Object[]{this.mECID, this.mRID, ClassUtils.getPrettyStack(Thread.currentThread().getStackTrace())});
        }
    }

    protected AbstractExecutionContext(M mgr, AbstractExecutionContext parentContext) {
        if (mgr == null || parentContext == null) {
            throw new IllegalArgumentException("None of the constructor's arguments is allowed to be null: \n  mgr    = " + mgr + "\n  parentContext      = " + parentContext);
        }
        this.mContextManager = mgr;
        this.mContextFamily = parentContext.mContextFamily;
        this.mECID = this.mContextFamily.getECID();
        this.mRID = parentContext.getRID().createChildRID();
        this.mCtxGlobalMap = new HashMap<String, String>(parentContext.mCtxGlobalMap);
        if (this.sLogger.isLoggable(Level.FINER)) {
            this.sLogger.log(Level.FINER, "New AbstractExecutionContext created [{0}, {1}] - invoked with stack:\n{2}", new Object[]{this.mECID, this.mRID, ClassUtils.getPrettyStack(Thread.currentThread().getStackTrace())});
        }
    }

    public F getContextFamily() {
        return this.mContextFamily;
    }

    public C createChild() {
        if (this.mContextFamily == null) {
            throw new IllegalStateException("AbstractExecutionContext has no reference to a ContextFamily (m_ctf).");
        }
        DomainExecutionContext ctx = this.createChildContext(this.mContextManager, (DomainExecutionContext)((Object)this));
        this.mContextFamily.addContext(ctx);
        return (C)ctx;
    }

    protected abstract C createChildContext(M var1, C var2);

    @Deprecated
    public C getParent() {
        RID parentRID = this.mRID.getParent();
        if (parentRID != null) {
            return this.mContextFamily.getExecutionContext(parentRID);
        }
        return null;
    }

    @Deprecated
    int getKidCount() {
        return this.mRID.getKidCount();
    }

    public String getIDasString() {
        if (this.mIDAsString != null) {
            return this.mIDAsString;
        }
        if (this.mECID == null || this.mRID == null) {
            throw new IllegalStateException("Execution context found with invalid m_ecid (" + this.mECID + ") and m_rid (" + this.mRID + ") combination");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.mECID).append(',').append(this.mRID.toString());
        this.mIDAsString = builder.toString();
        return this.mIDAsString;
    }

    public boolean isInheritable() {
        return this.mInheritable;
    }

    public void setInheritable(boolean inheritable) {
        this.mInheritable = inheritable;
    }

    public void suspend(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Can not suspend a context using a null key.");
        }
        Object contextSuspendedWithKey = this.mContextManager.getSuspendedContext(key);
        if (contextSuspendedWithKey != null) {
            if (this == contextSuspendedWithKey) {
                if (this.isSuspended()) {
                    return;
                }
                throw new IllegalStateException("Context is recorded in suspended-context map but is not in a suspended state.");
            }
            throw new IllegalArgumentException("Key used to suspend this context is already being used to suspend a different context.");
        }
        if (!this.isActive()) {
            throw new IllegalArgumentException("Can not suspend an inactive context.");
        }
        this.mSuspended = true;
        EventReportingManager eMgr = EventSystem.getEventReportingManager();
        if (eMgr != null) {
            eMgr.reportEvent(this.getAsMutableExecutionContext(), EventSourceType.EXECUTION_CONTEXT, EventActionType.SUSPEND, Time.currentTimeMillis(), this.getAsMutableExecutionContext(), null);
        }
        this.suspend2();
        this.mContextManager.addToSuspendedMap(key, (DomainExecutionContext)((DomainExecutionContext)((Object)this)));
    }

    protected abstract void suspend2();

    public String getECID() {
        return this.mECID;
    }

    public String toString() {
        return this.getIDasString();
    }

    public String getRIDasString() {
        return this.mRID.toString();
    }

    @Deprecated
    long getParentRID() {
        return 0L;
    }

    public RID getRID() {
        return this.mRID;
    }

    @Deprecated
    public long[] getChildren() {
        return null;
    }

    public abstract boolean isActive();

    public boolean isSuspended() {
        return this.mSuspended;
    }

    public void deactivate() {
        this.deactivate(true);
    }

    public synchronized void deactivate(boolean disassociateWithThread) {
        EventReportingManager eMgr = EventSystem.getEventReportingManager();
        if (eMgr != null) {
            eMgr.reportEvent(this.getAsMutableExecutionContext(), EventSourceType.EXECUTION_CONTEXT, EventActionType.STOP, Time.currentTimeMillis(), this.getAsMutableExecutionContext(), null);
        }
        if (this.sLogger.isLoggable(Level.FINER)) {
            this.sLogger.log(Level.FINER, "AbstractExecutionContext deactivation [{0}, {1}] - invoked with stack:\n{2}{3}", new Object[]{this.mECID, this.mRID, ClassUtils.getPrettyStack(Thread.currentThread().getStackTrace()), this.getPrettyInstanceStateSummary(Level.FINE)});
        }
        if (this.isActive()) {
            if (this.mCtxContentMap != null) {
                for (ContextContent content : this.mCtxContentMap.values()) {
                    content.onDeactivation();
                }
            }
            if (disassociateWithThread) {
                this.disassociateWithThread();
            }
        } else if (this.isSuspended()) {
            if (this.mCtxContentMap != null) {
                for (ContextContent content : this.mCtxContentMap.values()) {
                    content.onDeactivation();
                }
            }
            this.mContextManager.removeSuspendedContext((DomainExecutionContext)((DomainExecutionContext)((Object)this)));
        }
        this.mContextFamily.removeContext((DomainExecutionContext)((DomainExecutionContext)((Object)this)));
    }

    protected abstract void disassociateWithThread();

    protected abstract String getPrettyInstanceStateSummary(Level var1);

    public String setGlobalValue(String key, String value) {
        String retVal = this.setValueInternal(this.mCtxGlobalMap, key, value);
        return retVal;
    }

    public String setLocalValue(String key, String value) {
        if (this.mCtxLocalMap == null) {
            this.mCtxLocalMap = new HashMap(6, 0.75f);
        }
        String retVal = this.setValueInternal(this.mCtxLocalMap, key, value);
        return retVal;
    }

    private String setValueInternal(Map<String, String> map, String key, String value) {
        String retVal = null;
        boolean sendNotifications = true;
        if (key == null) {
            return retVal;
        }
        if (value != null) {
            retVal = map.put(key, value);
        } else {
            retVal = map.remove(key);
            boolean bl = sendNotifications = retVal != null;
        }
        if (sendNotifications) {
            this.keyTouched(key, value);
        }
        return retVal;
    }

    public void setValue(String key, String value) {
        this.setGlobalValue(key, value);
    }

    public void setValueAccordingToDescriptor(ContextParameterDescriptorInternal descriptor, String value) {
        if (descriptor != null && descriptor.isValid()) {
            if (descriptor.getValueHolder() != null) {
                throw new RuntimeException("An attempt has been made to udpate the value associated with parameter " + descriptor.getName() + " in context " + this.getIDasString() + ". The parameter is a value holder and is " + "therefore not updateable.");
            }
            boolean setValue = true;
            if (!descriptor.isUpdateable()) {
                setValue = false;
                String prevValue = this.getValueAccordingToDescriptor(descriptor, true);
                if (prevValue == null) {
                    setValue = true;
                } else if (prevValue.equals(value)) {
                    setValue = false;
                } else {
                    if (value == null) {
                        throw new RuntimeException("An attempt has been made to remove the immutable value associated with parameter " + descriptor.getName() + " in context " + this.getIDasString() + ". The parameter is not updateable.");
                    }
                    throw new RuntimeException("An attempt has been made to update the immutable value associated with parameter " + descriptor.getName() + " in context " + this.getIDasString() + ". The parameter is not updateable.");
                }
            }
            if (setValue) {
                if (descriptor.getScope().isSharedInFamily()) {
                    this.setGlobalValue(descriptor.getName(), value);
                } else {
                    this.setLocalValue(descriptor.getName(), value);
                }
            }
        }
    }

    public String getValueAccordingToDescriptor(ContextParameterDescriptorInternal descriptor, boolean calledFromContextsThread) {
        String retVal = null;
        if (descriptor != null && descriptor.isValid()) {
            if (descriptor.getValueHolder() != null) {
                if (descriptor.getValueHolder().getClass().isAnnotationPresent(ContextParameterDescriptorInternal.RemoteThreadSafeValueHolder.class) || calledFromContextsThread) {
                    boolean valueIsCacheable;
                    boolean bl = valueIsCacheable = descriptor.getECIDCardinality() == 1;
                    if (valueIsCacheable) {
                        retVal = this.getLocalValue(descriptor.getName());
                    }
                    if (retVal == null) {
                        retVal = descriptor.getValueHolder().getValue((DomainExecutionContext)((Object)this));
                    }
                    if (retVal != null && valueIsCacheable) {
                        this.setLocalValue(descriptor.getName(), retVal);
                    }
                }
            } else {
                retVal = descriptor.getScope().isSharedInFamily() ? this.getGlobalValue(descriptor.getName()) : this.getLocalValue(descriptor.getName());
            }
        }
        return retVal;
    }

    @Deprecated
    public boolean isTraceTriggered() {
        return false;
    }

    public void setLogLevel(Level level) {
        this.mContextFamily.setLogLevel(level);
    }

    public Level getLogLevel() {
        return this.mContextFamily.getLogLevel();
    }

    public Set<String> getParameterNames(DomainContextManager.ParameterAttribute paramAttr) {
        Set<String> retVal = null;
        Set<String> managerNames = this.mContextManager.getParameterNames(paramAttr);
        Set<String> familyNames = this.mContextFamily.getParameterNames(paramAttr);
        if (familyNames == null) {
            retVal = managerNames;
        } else {
            retVal = new HashSet<String>(managerNames);
            retVal.addAll(familyNames);
        }
        return retVal;
    }

    public Map<String, String> getPropagateMap() {
        Map<String, String> retVal = null;
        retVal = this.mCtxGlobalMap;
        return retVal;
    }

    public String getLocalOrGlobalValue(String key) {
        String retVal = null;
        retVal = this.getLocalValue(key);
        if (retVal == null) {
            retVal = this.getGlobalValue(key);
        }
        return retVal;
    }

    boolean hasKey(String key) {
        if (this.mCtxLocalMap.containsKey(key)) {
            return true;
        }
        return this.mCtxGlobalMap.containsKey(key);
    }

    public String getGlobalValue(String key) {
        if (key == null) {
            return null;
        }
        return this.mCtxGlobalMap.get(key);
    }

    public String getLocalValue(String key) {
        if (key == null || this.mCtxLocalMap == null) {
            return null;
        }
        return this.mCtxLocalMap.get(key);
    }

    public long getActivationTime() {
        return this.mActivationTime;
    }

    public Map<String, String> getAllValues(boolean calledFromContextsThread) {
        HashMap<String, String> retVal = new HashMap<String, String>(this.mCtxGlobalMap);
        if (this.mCtxLocalMap != null) {
            retVal.putAll(this.mCtxLocalMap);
        }
        for (ContextParameterDescriptorInternal p : this.mContextManager.getValueHolderDescriptors(calledFromContextsThread)) {
            String value;
            if (!p.isValid() || retVal.containsKey(p.getName()) || (value = this.getValueAccordingToDescriptor(p, calledFromContextsThread)) == null) continue;
            retVal.put(p.getName(), value);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(String key, ContextContent content) {
        if (key == null) {
            throw new IllegalArgumentException("key used in setContent must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("content intended for setContent must not be null");
        }
        AbstractExecutionContext abstractExecutionContext = this;
        synchronized (abstractExecutionContext) {
            if (this.mCtxContentMap == null) {
                this.mCtxContentMap = new HashMap(4, 0.75f);
            }
            this.mCtxContentMap.put(key, content);
        }
    }

    public ContextContent getContent(String key) {
        if (this.mCtxContentMap == null) {
            return null;
        }
        return this.mCtxContentMap.get(key);
    }

    @Deprecated
    public String dump(int format) {
        return this.getPrettyInstanceStateSummary(Level.FINE);
    }

    String getChildRIDasString() {
        RID kid_rid = this.mRID.createChildRID();
        return kid_rid.toString();
    }

    @Deprecated
    public void registerListener(ParameterValueListener lsnr) {
        if (lsnr == null) {
            return;
        }
        if (this.mValueListeners == null) {
            this.mValueListeners = new CopyOnWriteArraySet<ParameterValueListener>();
        }
        this.mValueListeners.add(lsnr);
    }

    public void deregisterListener(ParameterValueListener lsnr) {
        if (lsnr != null && this.mValueListeners != null) {
            this.mValueListeners.remove(lsnr);
        }
    }

    @Deprecated
    public void setUpdateSqlText(boolean set) {
        this.mUpdateSqlText = set;
    }

    @Deprecated
    public boolean isRoot() {
        return this.mRID.isRoot();
    }

    public void setPusher(C pusher) {
        this.mPusher = pusher;
    }

    public C getPusher() {
        return this.mPusher;
    }

    public void keyTouched(String key, String value) {
        if (this.mValueListeners != null) {
            ExecutionContext ctx = this.getAsMutableExecutionContext();
            for (ParameterValueListener lsnr : this.mValueListeners) {
                lsnr.parameterValueTouched(ctx, key, value);
            }
        }
    }

    public String wrap(WrapOptions wrapOptions) {
        String wrappedString = WrapUtils.wrap((DomainExecutionContext)((Object)this), wrapOptions);
        return wrappedString;
    }

    public boolean isUpdateSqlText() {
        return this.mUpdateSqlText;
    }

    public RID generateKidRID() {
        return this.mRID.createChildRID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionContext getAsMutableExecutionContext() {
        ExecutionContext retVal = null;
        if (this.mThisAsMutableExecutionContext != null) {
            retVal = this.mThisAsMutableExecutionContext;
        } else {
            AbstractExecutionContext abstractExecutionContext = this;
            synchronized (abstractExecutionContext) {
                retVal = this.mThisAsMutableExecutionContext != null ? this.mThisAsMutableExecutionContext : (this.mThisAsMutableExecutionContext = new ExecutionContext((DomainExecutionContext)((Object)this)));
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionContext getAsImmutableExecutionContext() {
        ImmutableExecutionContext retVal = null;
        if (this.mThisAsImmutableExecutionContext != null) {
            retVal = this.mThisAsImmutableExecutionContext;
        } else {
            AbstractExecutionContext abstractExecutionContext = this;
            synchronized (abstractExecutionContext) {
                retVal = this.mThisAsImmutableExecutionContext != null ? this.mThisAsImmutableExecutionContext : (this.mThisAsImmutableExecutionContext = new ImmutableExecutionContext((DomainExecutionContext)((Object)this)));
            }
        }
        return retVal;
    }

    public ECForJDBC getECForJDBC() {
        if (this.mJDBCContext == null) {
            this.mJDBCContext = new ECForJDBC((DomainExecutionContext)((Object)this));
            this.registerListener(this.mJDBCContext);
            this.sLogger.log(Level.FINE, "adding new ECForJDBC {0} to set of listeners for this context", this.mJDBCContext);
        }
        return this.mJDBCContext;
    }

    public Object getCachedObject(DomainExecutionContext.ObjectCacheKey key) {
        Object retVal = null;
        if (this.mObjectCache != null) {
            retVal = this.mObjectCache.get((Object)key);
        }
        return retVal;
    }

    public void setCachedObject(DomainExecutionContext.ObjectCacheKey key, Object value) {
        if (this.mObjectCache == null) {
            this.mObjectCache = new EnumMap(DomainExecutionContext.ObjectCacheKey.class);
        }
        this.mObjectCache.put(key, value);
    }
}

