/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.context.internal.wls;

import java.util.logging.Level;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.internal.DomainExecutionContext;

public interface ToWLSBridge {
    public void addRefInWorkContextMap(DomainExecutionContext var1);

    public void removeRefFromWorkContextMap();

    public void initWorkContextMap();

    public String getDiagnosticContextId();

    public static class Factory {
        public static synchronized ToWLSBridge getBridge() {
            ToWLSBridge retVal = null;
            try {
                Class<?> workContextMapClass = Class.forName("weblogic.workarea.WorkContextMap");
                Class<?> diagnosticMgrClass = Class.forName("weblogic.diagnostics.context.DiagnosticContextManager");
                Class<?> bridgeClass = Class.forName("oracle.dms.context.internal.wls.ToWLSBridgeImpl");
                retVal = (ToWLSBridge)bridgeClass.newInstance();
                retVal.initWorkContextMap();
            }
            catch (Throwable t) {
                DMSContextManager.getLogger().log(Level.FINE, "Required classes not available for bridge between JSE and WLS for context propagation", t);
            }
            return retVal;
        }
    }
}

