/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event.config;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.core.ojdl.logging.ODLLogger;
import oracle.dms.event.EventResourceBundle;
import oracle.dms.event.config.Condition;
import oracle.dms.event.config.DataType;
import oracle.dms.event.config.EventConfigException;
import oracle.dms.event.config.OpType;

public class ContextCondition
implements Condition,
Serializable {
    private int m_hashCode;
    private String m_name;
    private String m_value;
    private OpType m_opType;
    private boolean m_ignoreCase;
    private DataType m_dataType;
    private static final String CLASS_NAME = ContextCondition.class.getName();
    private static final int SEED = 300;
    private static final long serialVersionUID = 0L;
    private static final ODLLogger LOGGER = ODLLogger.getODLLogger((String)"oracle.dms.event", (String)EventResourceBundle.class.getName());

    public ContextCondition(String name, String value, OpType opType) {
        block3: {
            block2: {
                this.m_ignoreCase = false;
                this.m_dataType = null;
                if (opType == null) break block2;
                if (value != null) break block3;
                if (opType == OpType.IS_NULL) break block3;
                if (opType == OpType.ISNULL) break block3;
                if (opType == OpType.IS_NOT_NULL) break block3;
                if (opType == OpType.ISNOTNULL) break block3;
            }
            String msg = "invalid arguments to created ContextCondition; name=" + name + " opType=" + (Object)((Object)opType);
            throw new IllegalArgumentException(msg);
        }
        this.m_name = name;
        this.m_value = value;
        this.m_opType = opType;
        this.setHashCode();
    }

    public String getName() {
        return this.m_name;
    }

    public String getValue() {
        return this.m_value;
    }

    public OpType getOpType() {
        return this.m_opType;
    }

    public boolean getIgnoreCase() {
        return this.m_ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.m_ignoreCase = ignoreCase;
        this.setHashCode();
    }

    public DataType getDataType() {
        return this.m_dataType;
    }

    public void setDataType(DataType dataType) throws EventConfigException {
        String METHOD_NAME = "setDataType";
        if (!this.isValidDataTypeValue(dataType)) {
            String dataTypeString = null;
            if (dataType != null) {
                dataTypeString = dataType.toString();
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.logp(Level.FINER, CLASS_NAME, "setDataType", "DMS-58055", (Object[])new String[]{this.m_value, dataTypeString});
            }
            EventConfigException ec = new EventConfigException("DMS-58055");
            ec.addToken(this.m_value);
            ec.addToken(dataTypeString);
            throw ec;
        }
        switch (dataType) {
            case STRING: {
                this.m_dataType = DataType.STRING;
                break;
            }
            case DOUBLE: {
                this.m_dataType = DataType.DOUBLE;
                break;
            }
            case LONG: {
                this.m_dataType = DataType.LONG;
            }
        }
        this.setHashCode();
    }

    private boolean isValidDataTypeValue(DataType dataType) {
        if (this.m_value == null) {
            return false;
        }
        boolean retVal = true;
        StringTokenizer valueParser = new StringTokenizer(this.m_value, ",");
        String value = null;
        while (valueParser.hasMoreTokens()) {
            value = valueParser.nextToken();
            if (dataType == DataType.LONG) {
                try {
                    Long.parseLong(value);
                }
                catch (NumberFormatException ex) {
                    retVal = false;
                }
            } else if (dataType == DataType.DOUBLE) {
                try {
                    Double.parseDouble(value);
                }
                catch (NumberFormatException ex) {
                    retVal = false;
                }
                catch (NullPointerException np) {
                    retVal = false;
                }
            } else if (dataType != DataType.STRING) {
                retVal = false;
            }
            if (retVal) continue;
            break;
        }
        return retVal;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContextCondition)) {
            return false;
        }
        ContextCondition contextCondition = (ContextCondition)obj;
        boolean getDataType = this.getDataType() == null && contextCondition.getDataType() == null ? true : (this.getDataType() == null && contextCondition.getDataType() != null ? false : (this.getDataType() != null && contextCondition.getDataType() == null ? false : this.getDataType().equals((Object)contextCondition.getDataType())));
        boolean getName = this.getName() == null && contextCondition.getName() == null ? true : (this.getName() == null && contextCondition.getName() != null ? false : (this.getName() != null && contextCondition.getName() == null ? false : this.getName().equals(contextCondition.getName())));
        boolean getValue = this.getValue() == null && contextCondition.getValue() == null ? true : (this.getValue() == null && contextCondition.getValue() != null ? false : (this.getValue() != null && contextCondition.getValue() == null ? false : this.getValue().equals(contextCondition.getValue())));
        boolean getOpType = this.getOpType() == null && contextCondition.getOpType() == null ? true : (this.getOpType() == null && contextCondition.getOpType() != null ? false : (this.getOpType() != null && contextCondition.getOpType() == null ? false : this.getOpType().equals((Object)contextCondition.getOpType())));
        return getDataType && this.getIgnoreCase() == contextCondition.getIgnoreCase() && getName && getValue && getOpType;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    private void setHashCode() {
        int retVal = 300;
        if (this.getDataType() != null) {
            retVal = retVal * 300 + this.getDataType().hashCode();
        }
        int n = retVal = this.getIgnoreCase() ? retVal * 300 + Boolean.TRUE.hashCode() : retVal * 300 + Boolean.FALSE.hashCode();
        if (this.getName() != null) {
            retVal = retVal * 300 + this.getName().hashCode();
        }
        if (this.getValue() != null) {
            retVal = retVal * 300 + this.getValue().hashCode();
        }
        if (this.getOpType() != null) {
            retVal = retVal * 300 + this.getOpType().hashCode();
        }
        this.m_hashCode = retVal;
    }
}

