/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import oracle.core.ojdl.logging.ODLLogger;
import oracle.dms.event.EventResourceBundle;
import oracle.dms.event.EventType;
import oracle.dms.event.config.AndCondition;
import oracle.dms.event.config.Condition;
import oracle.dms.event.config.ConditionFilter;
import oracle.dms.event.config.ConditionParser;
import oracle.dms.event.config.ContextCondition;
import oracle.dms.event.config.DataType;
import oracle.dms.event.config.Destination;
import oracle.dms.event.config.EventConfig;
import oracle.dms.event.config.EventConfigException;
import oracle.dms.event.config.Filter;
import oracle.dms.event.config.NounTypeCondition;
import oracle.dms.event.config.NounTypeOpType;
import oracle.dms.event.config.OpType;
import oracle.dms.event.config.OrCondition;
import oracle.dms.jfr.JFREnvironmentInspector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
public class EventPersistence {
    private static final String SCHEMA_NAME_SPACE = "http://xmlns.oracle.com/dms/DMSConfiguration/V2";
    private static final String SCHEMA_NAME_SPACE_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String SCHEMA_LOCATION = "http://xmlns.oracle.com/dms/DMSConfiguration/V2";
    private static final String EVENT_ELEMENT_NAME = "eventConfiguration";
    private static final String DESTINATIONS_ELEMENT_NAME = "destinations";
    private static final String DESTINATION_ELEMENT_NAME = "destination";
    private static final String PROPERTIES_ELEMENT_NAME = "properties";
    private static final String PROPERTY_ELEMENT_NAME = "property";
    private static final String FILTERS_ELEMENT_NAME = "filters";
    private static final String CONDITION_FILTER_ELEMENT_NAME = "conditionFilter";
    private static final String CONDITION_ELEMENT_NAME = "condition";
    private static final String EVENTROUTINGTABLE_ELEMENT_NAME = "eventRoutingTable";
    private static final String EVENTROUTE_ELEMENT_NAME = "eventRoute";
    private static final String ANDCONDITION_ELEMENT_NAME = "andCondition";
    private static final String ORCONDITION_ELEMENT_NAME = "orCondition";
    private static final String TEXTCONDITION_ELEMENT_NAME = "textCondition";
    private static final String CONTEXTCONDITION_ELEMENT_NAME = "contextCondition";
    private static final String NOUNTYPECONDITION_ELEMENT_NAME = "nounTypeCondition";
    private static String LOGGER_NAME = "oracle.dms.event";
    private static final String CLASS_NAME = EventPersistence.class.getName();
    private static final String JFR_DESTINATION_CLASS = "oracle.dms.jfr.JFRDestination";
    private static final String LOGGER_DESTINATION_LOGGERNAME_VALUE = "DMSEventTraceLoggerDestination";
    private static final String LOGGER_DESTINATION_LOGGERNAME = "loggerName";
    private EventConfig m_eventConfig = null;
    private ODLLogger m_logger;

    public EventPersistence(EventConfig config) throws EventConfigException {
        if (config == null) {
            throw new IllegalArgumentException("invalid argument to EventPersistence; config is null");
        }
        this.m_eventConfig = config;
        this.m_logger = ODLLogger.getODLLogger((String)LOGGER_NAME, (String)EventResourceBundle.class.getName());
    }

    public Element buildElement(Document document) throws EventConfigException, ParserConfigurationException {
        Collection<Destination> destinations;
        String METHOD_NAME = "buildDOM";
        Element xevent = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", EVENT_ELEMENT_NAME);
        Element xdestinations = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", DESTINATIONS_ELEMENT_NAME);
        xevent.appendChild(xdestinations);
        if (this.m_eventConfig != null && (destinations = this.m_eventConfig.getAllDestinations()) != null) {
            for (Destination dest : destinations) {
                String dclass = dest.getDestinationClassName();
                String name = dest.getDestinationName();
                String id = dest.getDestinationId();
                Element xdestination = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", DESTINATION_ELEMENT_NAME);
                xdestination.setAttribute("class", dclass);
                xdestination.setAttribute("name", name);
                xdestination.setAttribute("id", id);
                xdestinations.appendChild(xdestination);
                Element xproperties = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", PROPERTIES_ELEMENT_NAME);
                xdestination.appendChild(xproperties);
                Map<String, String> properties = dest.getProperties();
                if (properties == null) continue;
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    String pname = entry.getKey().toString();
                    String pvalue = entry.getValue().toString();
                    Element xproperty = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", PROPERTY_ELEMENT_NAME);
                    xproperties.appendChild(xproperty);
                    xproperty.setAttribute("name", pname);
                    xproperty.setAttribute("value", pvalue);
                    xproperties.appendChild(xproperty);
                }
            }
        }
        Element xFilters = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", FILTERS_ELEMENT_NAME);
        xevent.appendChild(xFilters);
        Collection<Filter> filters = null;
        if (this.m_eventConfig != null) {
            filters = this.m_eventConfig.getAllFilters();
            for (Filter filter : filters) {
                String con;
                if (!(filter instanceof ConditionFilter)) continue;
                ConditionFilter conditionFilter = (ConditionFilter)filter;
                Element xconditionFilter = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", CONDITION_FILTER_ELEMENT_NAME);
                xconditionFilter.setAttribute("id", conditionFilter.getFilterId());
                xconditionFilter.setAttribute("name", conditionFilter.getFilterName());
                if (conditionFilter.getEventTypes() != null) {
                    xconditionFilter.setAttribute("eventTypes", conditionFilter.getEventTypes());
                }
                if ((con = conditionFilter.getConditionAsString()) != null) {
                    this.buildConditionElement(con, xconditionFilter, document);
                }
                xFilters.appendChild(xconditionFilter);
            }
        }
        Element xeventRoutingTable = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", EVENTROUTINGTABLE_ELEMENT_NAME);
        xevent.appendChild(xeventRoutingTable);
        if (this.m_eventConfig != null) {
            for (Filter filter : filters) {
                Map<String, Boolean> destinations2 = this.m_eventConfig.getEventRouteStatus(filter.getFilterId(), true);
                for (Map.Entry<String, Boolean> destEnableEntry : destinations2.entrySet()) {
                    Element xeventRoute = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", EVENTROUTE_ELEMENT_NAME);
                    xeventRoute.setAttribute("filterId", filter.getFilterId());
                    xeventRoute.setAttribute("destinationId", destEnableEntry.getKey());
                    xeventRoute.setAttribute("enabled", String.valueOf(destEnableEntry.getValue()));
                    xeventRoutingTable.appendChild(xeventRoute);
                }
            }
            Map<String, Boolean> destinations2 = this.m_eventConfig.getEventRouteStatus(null, true);
            for (Map.Entry<String, Boolean> destEnableEntry : destinations2.entrySet()) {
                Element xeventRoute = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", EVENTROUTE_ELEMENT_NAME);
                xeventRoute.setAttribute("filterId", null);
                xeventRoute.setAttribute("destinationId", destEnableEntry.getKey());
                xeventRoute.setAttribute("enabled", String.valueOf(destEnableEntry.getValue()));
                xeventRoutingTable.appendChild(xeventRoute);
            }
            xevent.appendChild(xeventRoutingTable);
        }
        return xevent;
    }

    public EventConfig buildEventConfig(Element xevent) throws EventConfigException {
        String name;
        String METHOD_NAME = "buildEventConfig";
        int nodeLength = 0;
        int destinationNodeLength = 0;
        if (xevent == null) {
            this.m_logger.logp(Level.FINE, CLASS_NAME, "buildEventConfig", "DMS-58064");
            throw new EventConfigException("DMS-58064");
        }
        NodeList nodes = xevent.getElementsByTagName(DESTINATION_ELEMENT_NAME);
        nodeLength = nodes.getLength();
        ArrayList<String> badDestination = new ArrayList<String>();
        for (int destinationIterator = 0; destinationIterator < nodeLength; ++destinationIterator) {
            String id = null;
            String className = null;
            name = null;
            id = ((Element)nodes.item(destinationIterator)).getAttribute("id");
            className = ((Element)nodes.item(destinationIterator)).getAttribute("class");
            name = ((Element)nodes.item(destinationIterator)).getAttribute("name");
            if ("oracle.dms.jrockit.jfr.JFRDestination".equals(className)) {
                className = JFR_DESTINATION_CLASS;
            }
            Destination destination = new Destination(id, className);
            destination.setDestinationName(name);
            NodeList dnodes = ((Element)nodes.item(destinationIterator)).getElementsByTagName(PROPERTY_ELEMENT_NAME);
            destinationNodeLength = dnodes.getLength();
            for (int propertiesIterator = 0; propertiesIterator < destinationNodeLength; ++propertiesIterator) {
                String propertyName = ((Element)dnodes.item(propertiesIterator)).getAttribute("name");
                String propertyValue = ((Element)dnodes.item(propertiesIterator)).getAttribute("value");
                destination.setProperty(propertyName, propertyValue);
                this.m_logger.logp(Level.FINER, CLASS_NAME, "buildEventConfig", "EventPersistence: destination= " + destination.getDestinationId() + " propertyName=" + propertyName + " propertyValue=" + propertyValue + " propertiesIterator=" + propertiesIterator);
            }
            if (destination.getDestinationId().equals("LoggerDestination") && destination.getProperty(LOGGER_DESTINATION_LOGGERNAME) == null) {
                destination.setProperty(LOGGER_DESTINATION_LOGGERNAME, LOGGER_DESTINATION_LOGGERNAME_VALUE);
                if (this.m_logger.isLoggable(Level.FINER)) {
                    this.m_logger.logp(Level.FINER, CLASS_NAME, "buildEventConfig", "added missing required property 'loggerName' with value 'DMSEventTraceLoggerDestination' to destinationId '" + id + "'");
                }
            }
            try {
                this.m_eventConfig.validateDestination(destination, false);
                this.m_eventConfig.addDestination(destination);
                if (!this.m_logger.isLoggable(Level.FINER)) continue;
                this.m_logger.logp(Level.FINER, CLASS_NAME, "buildEventConfig", "built a destination with destinationId '" + id + "' from the config file");
                continue;
            }
            catch (Exception e) {
                String badId = destination.getDestinationId();
                badDestination.add(badId);
                if (e instanceof EventConfigException && ("DMS-58070".equals(((EventConfigException)e).getMessageID()) || "DMS-58081".equals(((EventConfigException)e).getMessageID()))) {
                    EventConfigException ece = (EventConfigException)e;
                    Level level = Level.INFO;
                    JFREnvironmentInspector.Availability availability = (JFREnvironmentInspector.Availability)((Object)ece.get("JFREnvironmentInspector.Availability"));
                    if (availability == JFREnvironmentInspector.Availability.NOT_SUPPORTED_BY_PLATFORM || availability == JFREnvironmentInspector.Availability.SUPPORTED_BY_PLATFORM_BUT_NOT_SUPPORTED_BY_JVM) {
                        level = Level.FINE;
                    }
                    this.m_logger.log(level, ece.getLocalizedMessage());
                    continue;
                }
                this.m_logger.logp(Level.WARNING, CLASS_NAME, "buildEventConfig", "DMS-58044", (Object[])new String[]{badId}, (Throwable)e);
            }
        }
        nodes = xevent.getElementsByTagName(CONDITION_FILTER_ELEMENT_NAME);
        nodeLength = nodes.getLength();
        for (int filterIterator = 0; filterIterator < nodeLength; ++filterIterator) {
            Condition con = null;
            String id = ((Element)nodes.item(filterIterator)).getAttribute("id");
            name = ((Element)nodes.item(filterIterator)).getAttribute("name");
            String eventTypes = ((Element)nodes.item(filterIterator)).getAttribute("eventTypes");
            if (eventTypes != null && eventTypes.length() > 0) {
                try {
                    eventTypes = EventType.v1TypeConversion(eventTypes.toUpperCase().replaceAll("\\s", ""));
                }
                catch (Exception e) {
                    if (this.m_logger.isLoggable(Level.WARNING)) {
                        this.m_logger.logp(Level.WARNING, CLASS_NAME, "buildEventConfig", "DMS-58079", (Object[])new String[]{id}, (Throwable)e);
                    }
                    eventTypes = null;
                }
            }
            List<Element> condition = this.getElements(nodes.item(filterIterator).getChildNodes());
            String conString = null;
            try {
                if (condition.size() > 0) {
                    con = this.buildCondition(condition.get(0));
                    List<Element> realConditionElements = this.getElements(condition.get(0).getChildNodes());
                    if (realConditionElements.size() > 0) {
                        Element realCondition = realConditionElements.get(0);
                        this.m_logger.logp(Level.FINE, CLASS_NAME, "buildEventConfig", "XML element name=" + realCondition.getNodeName());
                        if (realCondition.getNodeName().equals(TEXTCONDITION_ELEMENT_NAME)) {
                            NodeList textConditionNL = realCondition.getChildNodes();
                            conString = textConditionNL.item(0).getNodeValue();
                            this.m_logger.logp(Level.FINE, CLASS_NAME, "buildEventConfig", "textCondition : " + textConditionNL.item(0).getNodeValue() + "\n");
                        } else {
                            conString = ConditionFilter.getStringCondition(con);
                        }
                    }
                }
                ConditionFilter conditionFilter = new ConditionFilter(id, con, conString);
                conditionFilter.setFilterName(name);
                conditionFilter.setEventTypes(eventTypes);
                this.m_eventConfig.addFilter(conditionFilter);
                if (!this.m_logger.isLoggable(Level.FINER)) continue;
                this.m_logger.logp(Level.FINER, CLASS_NAME, "buildEventConfig", "built a filter with filterId '" + id + "' from the config file");
                continue;
            }
            catch (Exception e) {
                if (!this.m_logger.isLoggable(Level.WARNING)) continue;
                this.m_logger.logp(Level.WARNING, CLASS_NAME, "buildEventConfig", "DMS-58053", (Object[])new String[]{id}, (Throwable)e);
            }
        }
        nodes = xevent.getElementsByTagName(EVENTROUTE_ELEMENT_NAME);
        nodeLength = nodes.getLength();
        for (int destinationIterator = 0; destinationIterator < nodeLength; ++destinationIterator) {
            boolean enabled;
            String filterId = ((Element)nodes.item(destinationIterator)).getAttribute("filterId");
            if ("".equals(filterId)) {
                filterId = null;
            }
            String destinationId = ((Element)nodes.item(destinationIterator)).getAttribute("destinationId");
            String enabledString = ((Element)nodes.item(destinationIterator)).getAttribute("enabled");
            boolean bl = enabled = !enabledString.contains("false");
            if (badDestination.contains(destinationId)) continue;
            try {
                this.m_eventConfig.addEventRoute(filterId, destinationId, enabled);
                if (!this.m_logger.isLoggable(Level.FINER)) continue;
                this.m_logger.logp(Level.FINER, CLASS_NAME, "buildEventConfig", "built a route with filterId '" + filterId + "' and destinationId '" + destinationId + "' from the config file");
                continue;
            }
            catch (Exception e) {
                if (!this.m_logger.isLoggable(Level.WARNING)) continue;
                this.m_logger.logp(Level.WARNING, CLASS_NAME, "buildEventConfig", "DMS-58054", (Object[])new String[]{filterId, destinationId}, (Throwable)e);
            }
        }
        return this.m_eventConfig;
    }

    private Condition buildCondition(Node rootNode) throws EventConfigException {
        List<Element> realConditionElements;
        Condition condition = null;
        NounTypeOpType nop = null;
        OpType op = null;
        boolean ignoreCase = true;
        String name = null;
        String value = null;
        String METHOD_NAME = "buildCondition";
        DataType dataType = null;
        if (rootNode != null && (realConditionElements = this.getElements(rootNode.getChildNodes())).size() > 0) {
            Element realCondition = realConditionElements.get(0);
            if (realCondition.getNodeName().equals(ANDCONDITION_ELEMENT_NAME)) {
                List<Element> conditionParts = this.getElements(realCondition.getChildNodes());
                if (conditionParts.size() == 2) {
                    Condition lh = this.buildCondition(conditionParts.get(0));
                    Condition rh = this.buildCondition(conditionParts.get(1));
                    return new AndCondition(lh, rh);
                }
            } else if (realCondition.getNodeName().equals(ORCONDITION_ELEMENT_NAME)) {
                List<Element> conditionParts = this.getElements(realCondition.getChildNodes());
                if (conditionParts.size() == 2) {
                    Condition lh = this.buildCondition(conditionParts.get(0));
                    Condition rh = this.buildCondition(conditionParts.get(1));
                    return new OrCondition(lh, rh);
                }
            } else {
                if (realCondition.getNodeName().equals(NOUNTYPECONDITION_ELEMENT_NAME)) {
                    name = realCondition.getAttribute("name");
                    String ntcs = realCondition.getAttribute("op");
                    nop = NounTypeOpType.getOpType(ntcs);
                    return new NounTypeCondition(name, nop);
                }
                if (realCondition.getNodeName().equals(CONTEXTCONDITION_ELEMENT_NAME)) {
                    name = realCondition.getAttribute("name");
                    op = OpType.getOpType(realCondition.getAttribute("op"));
                    ContextCondition ContextCondition2 = null;
                    if (op == OpType.IS_NULL || op == OpType.IS_NOT_NULL || op == OpType.ISNULL || op == OpType.ISNOTNULL) {
                        ContextCondition2 = new ContextCondition(name, null, op);
                    } else {
                        value = realCondition.getAttribute("value");
                        String ignoreCaseString = realCondition.getAttribute("ignoreCase").toString();
                        if (ignoreCaseString.contains("false")) {
                            ignoreCase = false;
                        }
                        dataType = DataType.getDataType(realCondition.getAttribute("dataType"));
                        ContextCondition2 = new ContextCondition(name, value, op);
                        ContextCondition2.setIgnoreCase(ignoreCase);
                        ContextCondition2.setDataType(dataType);
                    }
                    return ContextCondition2;
                }
                if (realCondition.getNodeName().equals(TEXTCONDITION_ELEMENT_NAME)) {
                    String textCondition = null;
                    if (rootNode.getNodeType() == 1) {
                        Element element = (Element)rootNode;
                        NodeList textConditionNodeList = element.getElementsByTagName(TEXTCONDITION_ELEMENT_NAME);
                        Element element1 = (Element)textConditionNodeList.item(0);
                        NodeList textConditionNL = element1.getChildNodes();
                        this.m_logger.logp(Level.FINE, CLASS_NAME, METHOD_NAME, "textCondition : " + textConditionNL.item(0).getNodeValue() + "\n");
                        textCondition = textConditionNL.item(0).getNodeValue();
                    }
                    ConditionParser conditionParser = new ConditionParser();
                    return conditionParser.parse(textCondition);
                }
            }
        }
        return condition;
    }

    private List<Element> getElements(NodeList nodes) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (nodes != null) {
            int len = nodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node n = nodes.item(i);
                if (n.getNodeType() != 1) continue;
                elements.add((Element)n);
            }
        }
        return elements;
    }

    private void buildConditionElement(String con, Element elem, Document document) throws EventConfigException {
        String METHOD_NAME = "buildConditionElement";
        if (con == null || elem == null || document == null) {
            this.m_logger.logp(Level.FINE, CLASS_NAME, "buildConditionElement", "DMS-58065", (Object[])new String[]{con.toString(), elem.getTagName()});
            EventConfigException ec = new EventConfigException("DMS-58065");
            ec.addToken(con.toString());
            ec.addToken(elem.getTagName());
            throw ec;
        }
        Element xcon = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", CONDITION_ELEMENT_NAME);
        elem.appendChild(xcon);
        Element xTextCondition = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", TEXTCONDITION_ELEMENT_NAME);
        xTextCondition.setTextContent(con);
        xcon.appendChild(xTextCondition);
    }

    private void buildConditionElement(Condition con, Element elem, Document document) throws EventConfigException {
        String METHOD_NAME = "buildConditionElement";
        if (con == null || elem == null || document == null) {
            this.m_logger.logp(Level.FINE, CLASS_NAME, "buildConditionElement", "DMS-58065", (Object[])new String[]{con.toString(), elem.getTagName()});
            EventConfigException ec = new EventConfigException("DMS-58065");
            ec.addToken(con.toString());
            ec.addToken(elem.getTagName());
            throw ec;
        }
        Element xcon = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", CONDITION_ELEMENT_NAME);
        elem.appendChild(xcon);
        if (con instanceof AndCondition) {
            Element xAndCondition = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", ANDCONDITION_ELEMENT_NAME);
            xcon.appendChild(xAndCondition);
            AndCondition and1 = (AndCondition)con;
            this.buildConditionElement(and1.getLHCondition(), xAndCondition, document);
            this.buildConditionElement(and1.getRHCondition(), xAndCondition, document);
        } else if (con instanceof OrCondition) {
            Element xOrCondition = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", ORCONDITION_ELEMENT_NAME);
            xcon.appendChild(xOrCondition);
            OrCondition or1 = (OrCondition)con;
            this.buildConditionElement(or1.getLHCondition(), xOrCondition, document);
            this.buildConditionElement(or1.getRHCondition(), xOrCondition, document);
        } else if (con instanceof ContextCondition) {
            ContextCondition Con = (ContextCondition)con;
            Element xContextCondition = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", CONTEXTCONDITION_ELEMENT_NAME);
            xContextCondition.setAttribute("op", Con.getOpType().toString());
            xContextCondition.setAttribute("name", Con.getName().toString());
            if (Con.getOpType() != OpType.IS_NULL && Con.getOpType() != OpType.IS_NOT_NULL && Con.getOpType() != OpType.ISNULL && Con.getOpType() != OpType.ISNOTNULL) {
                xContextCondition.setAttribute("value", Con.getValue().toString());
                xContextCondition.setAttribute("ignoreCase", String.valueOf(Con.getIgnoreCase()));
                xContextCondition.setAttribute("dataType", Con.getDataType().toString().toLowerCase());
            }
            xcon.appendChild(xContextCondition);
        } else if (con instanceof NounTypeCondition) {
            NounTypeCondition Noun2 = (NounTypeCondition)con;
            Element xNounTypeCondition = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", NOUNTYPECONDITION_ELEMENT_NAME);
            xNounTypeCondition.setAttribute("name", Noun2.getNounType().toString());
            xNounTypeCondition.setAttribute("op", Noun2.getOpType().toString());
            xcon.appendChild(xNounTypeCondition);
        }
    }
}

