/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event.config;

import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.dms.event.EventResourceBundle;
import oracle.dms.event.config.AndCondition;
import oracle.dms.event.config.Condition;
import oracle.dms.event.config.ContextCondition;
import oracle.dms.event.config.EventConfigException;
import oracle.dms.event.config.EventConfigurationAdapter;
import oracle.dms.event.config.NestedCondition;
import oracle.dms.event.config.NounTypeCondition;
import oracle.dms.event.config.NounTypeOpType;
import oracle.dms.event.config.OpType;
import oracle.dms.event.config.OrCondition;

class JMXHelper {
    public static final String CONDITION = "condition";

    JMXHelper() {
    }

    static CompositeType toCompositeType(Condition condition) throws Exception {
        CompositeType ct = null;
        if (condition instanceof AndCondition) {
            AndCondition andCon = (AndCondition)condition;
            ct = new CompositeType("AndCondition", "AND Condition", new String[]{"lhCondition", "rhCondition"}, new String[]{"Left-hand condition", "Right-hand condition"}, new OpenType[]{JMXHelper.toCompositeType(andCon.getLHCondition()), JMXHelper.toCompositeType(andCon.getRHCondition())});
        } else if (condition instanceof OrCondition) {
            OrCondition orCon = (OrCondition)condition;
            ct = new CompositeType("OrCondition", "OR Condition", new String[]{"lhCondition", "rhCondition"}, new String[]{"Left-hand condition", "Right-hand condition"}, new OpenType[]{JMXHelper.toCompositeType(orCon.getLHCondition()), JMXHelper.toCompositeType(orCon.getRHCondition())});
        } else if (condition instanceof NounTypeCondition) {
            NounTypeCondition ntCon = (NounTypeCondition)condition;
            ct = new CompositeType("NounTypeCondition", "NounType Condition", new String[]{"nounType", "opType"}, new String[]{"Noun type", "Operation type"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
        } else if (condition instanceof ContextCondition) {
            ContextCondition ctCon = (ContextCondition)condition;
            ct = new CompositeType("ContextCondition", "Context Condition", new String[]{"name", "value", "opType", "ignoreCase", "dataType"}, new String[]{"Name", "Value", "Operation type", "Ignore case", "Value Data Type"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.STRING});
        } else if (condition instanceof NestedCondition) {
            NestedCondition nestedCon = (NestedCondition)condition;
            ct = new CompositeType("NestedCondition", "Nested  Condition", new String[]{CONDITION}, new String[]{"Nested Condition"}, new OpenType[]{JMXHelper.toCompositeType(nestedCon.getCondition())});
        } else {
            throw new EventConfigException("DMS-58072");
        }
        return ct;
    }

    static CompositeData toCompositeData(Condition condition) throws Exception {
        CompositeDataSupport cd = null;
        String LOGGER_NAME = "oracle.dms.event";
        Logger logger = Logger.getLogger(LOGGER_NAME, EventResourceBundle.class.getName());
        String METHOD_NAME = "toCompositeData";
        String CLASS_NAME = EventConfigurationAdapter.class.getName();
        if (condition instanceof NestedCondition) {
            NestedCondition nestedCon = (NestedCondition)condition;
            CompositeType compositeType = JMXHelper.toCompositeType(nestedCon);
            String[] itemNames = new String[]{CONDITION};
            Set<String> namesSet = compositeType.keySet();
            if (!Arrays.asList(itemNames).containsAll(namesSet) && logger.isLoggable(Level.WARNING)) {
                logger.logp(Level.WARNING, CLASS_NAME, METHOD_NAME, "DMS-58073", new String[]{itemNames.toString(), namesSet.toString()});
            }
            cd = new CompositeDataSupport(compositeType, itemNames, new Object[]{JMXHelper.toCompositeData(nestedCon.getCondition())});
        } else if (condition instanceof AndCondition) {
            AndCondition andCon = (AndCondition)condition;
            cd = new CompositeDataSupport(JMXHelper.toCompositeType(andCon), new String[]{"lhCondition", "rhCondition"}, new Object[]{JMXHelper.toCompositeData(andCon.getLHCondition()), JMXHelper.toCompositeData(andCon.getRHCondition())});
        } else if (condition instanceof OrCondition) {
            OrCondition orCon = (OrCondition)condition;
            cd = new CompositeDataSupport(JMXHelper.toCompositeType(orCon), new String[]{"lhCondition", "rhCondition"}, new Object[]{JMXHelper.toCompositeData(orCon.getLHCondition()), JMXHelper.toCompositeData(orCon.getRHCondition())});
        } else if (condition instanceof NounTypeCondition) {
            NounTypeCondition ntCon = (NounTypeCondition)condition;
            cd = new CompositeDataSupport(JMXHelper.toCompositeType(ntCon), new String[]{"nounType", "opType"}, new Object[]{ntCon.getNounType(), ntCon.getOpType().toString()});
        } else if (condition instanceof ContextCondition) {
            ContextCondition ctCon = (ContextCondition)condition;
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, METHOD_NAME, "getName=" + ctCon.getName() + "getValue=" + ctCon.getValue() + "getOpType=" + ctCon.getOpType().toString() + "getIgnoreCase=" + ctCon.getIgnoreCase());
            }
            String dataTypeString = null;
            if (ctCon.getDataType() != null) {
                dataTypeString = ctCon.getDataType().toString();
            }
            Object[] myObjects = new Object[]{ctCon.getName(), ctCon.getValue(), ctCon.getOpType().toString(), ctCon.getIgnoreCase(), dataTypeString};
            cd = new CompositeDataSupport(JMXHelper.toCompositeType(ctCon), new String[]{"name", "value", "opType", "ignoreCase", "dataType"}, myObjects);
        }
        return cd;
    }

    static Condition toCondition(CompositeData cd) {
        Condition con = null;
        String type = cd.getCompositeType().getTypeName();
        if (type.equals("NestedCondition")) {
            Condition nestedCondition = JMXHelper.toCondition((CompositeData)cd.get(CONDITION));
            con = new NestedCondition(nestedCondition);
        } else if (type.equals("AndCondition")) {
            Condition lhCondition = JMXHelper.toCondition((CompositeData)cd.get("lhCondition"));
            Condition rhCondition = JMXHelper.toCondition((CompositeData)cd.get("rhCondition"));
            con = new AndCondition(lhCondition, rhCondition);
        } else if (type.equals("OrCondition")) {
            Condition lhCondition = JMXHelper.toCondition((CompositeData)cd.get("lhCondition"));
            Condition rhCondition = JMXHelper.toCondition((CompositeData)cd.get("rhCondition"));
            con = new OrCondition(lhCondition, rhCondition);
        } else if (type.equals("NounTypeCondition")) {
            con = new NounTypeCondition((String)cd.get("nounType"), NounTypeOpType.getOpType((String)cd.get("opType")));
        } else if (type.equals("ContextCondition")) {
            con = new ContextCondition((String)cd.get("name"), (String)cd.get("value"), OpType.getOpType((String)cd.get("opType")));
        }
        return con;
    }
}

