/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.jmx;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.dms.jmx.MetricMBeanCreationListener;
import oracle.dms.jmx.MetricMBeanFactory;

public abstract class MetricMBeanInitializer {
    private static MetricMBeanFactory s_metricMBeanFactory = null;
    private static Set<MetricMBeanCreationListener> s_listeners = Collections.synchronizedSet(new HashSet());

    static void setMetricMBeanFactory(MetricMBeanFactory metricMBeanFactory) {
        if (s_metricMBeanFactory != null && s_metricMBeanFactory == metricMBeanFactory) {
            return;
        }
        s_metricMBeanFactory = metricMBeanFactory;
    }

    public static MetricMBeanFactory getMetricMBeanFactory() {
        return s_metricMBeanFactory;
    }

    public static void addMetricMBeanListener(MetricMBeanCreationListener listener) {
        if (listener != null) {
            s_listeners.add(listener);
        }
    }

    public static void removeMetricMBeanListener(MetricMBeanCreationListener listener) {
        if (listener != null) {
            s_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createMetricMBeans(boolean isEnabled) {
        HashSet<MetricMBeanCreationListener> listeners;
        Set<MetricMBeanCreationListener> set = s_listeners;
        synchronized (set) {
            listeners = new HashSet<MetricMBeanCreationListener>(s_listeners);
        }
        for (MetricMBeanCreationListener listener : listeners) {
            listener.createMetricMBeans(isEnabled);
        }
    }
}

