/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.jmx;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.dms.jmx.ParameterConstraint;
import oracle.dms.util.JSONUtils;
import oracle.dms.util.ObjectUtils;

@JSONUtils.JSONFormatToString
public class ParameterScopedMetricsRule {
    private final String mRuleId;
    private final NounTypePattern[] mNounTypePatterns;
    private final ParameterConstraint[] mActivationParameterConstraints;
    private final ParameterConstraint[] mContextParameterConstraints;
    private final int mHashCode;
    private static final CompositeType RULE_CT;
    private static final OpenType[] RULE_CT_ITEM_TYPES;
    private static final String[] RULE_CT_ITEM_NAMES;
    private static final String[] RULE_CT_ITEM_DESCRIPTIONS;

    public ParameterScopedMetricsRule(String ruleId, NounTypePattern[] nounTypePatterns, ParameterConstraint[] activationParameterConstraints, ParameterConstraint[] contextParameterConstraints) {
        int tmpHashCode = 0;
        if (ruleId == null) {
            throw new IllegalArgumentException("ruleId must not be null.");
        }
        this.mRuleId = ruleId;
        tmpHashCode ^= this.mRuleId.hashCode();
        if (nounTypePatterns != null && nounTypePatterns.length > 0) {
            this.mNounTypePatterns = nounTypePatterns;
            for (int i = 0; i < nounTypePatterns.length; ++i) {
                tmpHashCode ^= this.mNounTypePatterns[i].hashCode();
            }
        } else {
            this.mNounTypePatterns = new NounTypePattern[0];
        }
        if (activationParameterConstraints != null && activationParameterConstraints.length > 0) {
            for (ParameterConstraint n : this.mActivationParameterConstraints = activationParameterConstraints) {
                tmpHashCode ^= n == null ? 0 : n.hashCode();
            }
        } else {
            this.mActivationParameterConstraints = null;
        }
        if (contextParameterConstraints != null && contextParameterConstraints.length > 0) {
            for (ParameterConstraint n : this.mContextParameterConstraints = contextParameterConstraints) {
                tmpHashCode ^= n == null ? 0 : n.hashCode();
            }
        } else {
            this.mContextParameterConstraints = null;
        }
        this.mHashCode = tmpHashCode;
    }

    @ConstructorProperties(value={"ruleId", "nounTypes", "activationParameterConstraints", "contextParameterConstraints"})
    public ParameterScopedMetricsRule(String ruleId, String[] nounTypePatternStrings, ParameterConstraint[] activationParameterConstraints, ParameterConstraint[] contextParameterConstraints) {
        int tmpHashCode = 0;
        if (ruleId == null) {
            throw new IllegalArgumentException("ruleId must not be null.");
        }
        this.mRuleId = ruleId;
        tmpHashCode ^= this.mRuleId.hashCode();
        if (nounTypePatternStrings != null && nounTypePatternStrings.length > 0) {
            this.mNounTypePatterns = new NounTypePattern[nounTypePatternStrings.length];
            for (int i = 0; i < nounTypePatternStrings.length; ++i) {
                this.mNounTypePatterns[i] = new NounTypePattern(nounTypePatternStrings[i]);
                tmpHashCode ^= this.mNounTypePatterns[i].hashCode();
            }
        } else {
            this.mNounTypePatterns = new NounTypePattern[0];
        }
        if (activationParameterConstraints != null && activationParameterConstraints.length > 0) {
            for (ParameterConstraint n : this.mActivationParameterConstraints = activationParameterConstraints) {
                tmpHashCode ^= n == null ? 0 : n.hashCode();
            }
        } else {
            this.mActivationParameterConstraints = null;
        }
        if (contextParameterConstraints != null && contextParameterConstraints.length > 0) {
            for (ParameterConstraint n : this.mContextParameterConstraints = contextParameterConstraints) {
                tmpHashCode ^= n == null ? 0 : n.hashCode();
            }
        } else {
            this.mContextParameterConstraints = null;
        }
        this.mHashCode = tmpHashCode;
    }

    public String getId() {
        return this.mRuleId;
    }

    public String[] getNounTypePatternsAsString() {
        String[] retVal = new String[this.mNounTypePatterns.length];
        for (int i = 0; i < this.mNounTypePatterns.length; ++i) {
            retVal[i] = this.mNounTypePatterns[i].toString();
        }
        return retVal;
    }

    public NounTypePattern[] getNounTypePatterns() {
        return this.mNounTypePatterns;
    }

    public ParameterConstraint[] getActivationParameterConstraints() {
        return this.mActivationParameterConstraints;
    }

    public ParameterConstraint[] getContextParameterConstraints() {
        return this.mContextParameterConstraints;
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public boolean equals(Object o) {
        boolean retVal = false;
        if (o instanceof ParameterScopedMetricsRule) {
            ParameterScopedMetricsRule that = (ParameterScopedMetricsRule)o;
            if (this == that) {
                retVal = true;
            } else if (Arrays.equals(this.mActivationParameterConstraints, that.mActivationParameterConstraints) && Arrays.equals(this.mContextParameterConstraints, that.mContextParameterConstraints) && Arrays.equals(this.mNounTypePatterns, that.mNounTypePatterns) && ObjectUtils.areEqual(this.mRuleId, that.mRuleId)) {
                retVal = true;
            }
        }
        return retVal;
    }

    public static CompositeType toCompositeType() {
        return RULE_CT;
    }

    public CompositeData toCompositeData(CompositeType ct) {
        CompositeDataSupport retVal = null;
        if (RULE_CT != null) {
            try {
                int i;
                HashMap<String, Object> allData = new HashMap<String, Object>();
                allData.put(RULE_CT_ITEM_NAMES[0], this.mRuleId);
                if (this.mNounTypePatterns == null) {
                    allData.put(RULE_CT_ITEM_NAMES[1], null);
                } else {
                    allData.put(RULE_CT_ITEM_NAMES[1], this.getNounTypePatternsAsString());
                }
                if (this.mActivationParameterConstraints == null) {
                    allData.put(RULE_CT_ITEM_NAMES[2], null);
                } else {
                    CompositeData[] actParamConstrArr = new CompositeData[this.mActivationParameterConstraints.length];
                    i = 0;
                    for (ParameterConstraint pc : this.mActivationParameterConstraints) {
                        int n = i++;
                        actParamConstrArr[n] = pc.toCompositeData(pc.toCompositeType());
                    }
                    allData.put(RULE_CT_ITEM_NAMES[2], actParamConstrArr);
                }
                if (this.mContextParameterConstraints == null) {
                    allData.put(RULE_CT_ITEM_NAMES[3], null);
                } else {
                    CompositeData[] ctxParamConstrArr = new CompositeData[this.mContextParameterConstraints.length];
                    i = 0;
                    for (ParameterConstraint pc : this.mContextParameterConstraints) {
                        int n = i++;
                        ctxParamConstrArr[n] = pc.toCompositeData(pc.toCompositeType());
                    }
                    allData.put(RULE_CT_ITEM_NAMES[3], ctxParamConstrArr);
                }
                retVal = new CompositeDataSupport(RULE_CT, allData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    public static ParameterScopedMetricsRule from(CompositeData cd) {
        String paramName = (String)cd.get(RULE_CT_ITEM_NAMES[0]);
        NounTypePattern[] nounTypePatterns = null;
        String[] nounTypeCDArr = (String[])cd.get(RULE_CT_ITEM_NAMES[1]);
        if (nounTypeCDArr != null && nounTypeCDArr.length > 0) {
            HashSet<NounTypePattern> patternSet = new HashSet<NounTypePattern>();
            for (String s : nounTypeCDArr) {
                NounTypePattern ntp = new NounTypePattern(s);
                patternSet.add(ntp);
            }
            nounTypePatterns = new NounTypePattern[patternSet.size()];
            patternSet.toArray(nounTypePatterns);
        }
        ParameterConstraint[] actParamConstraintArr = null;
        CompositeData[] actParamConstraintCDArr = (CompositeData[])cd.get(RULE_CT_ITEM_NAMES[2]);
        if (actParamConstraintCDArr != null) {
            int n = actParamConstraintCDArr.length;
            actParamConstraintArr = new ParameterConstraint[n];
            for (int i = 0; i < n; ++i) {
                actParamConstraintArr[i] = ParameterConstraint.from(actParamConstraintCDArr[i]);
            }
        }
        ParameterConstraint[] ctxParamConstraintArr = null;
        CompositeData[] ctxParamConstraintCDArr = (CompositeData[])cd.get(RULE_CT_ITEM_NAMES[3]);
        if (ctxParamConstraintCDArr != null) {
            int n = ctxParamConstraintCDArr.length;
            ctxParamConstraintArr = new ParameterConstraint[n];
            for (int i = 0; i < n; ++i) {
                ctxParamConstraintArr[i] = ParameterConstraint.from(ctxParamConstraintCDArr[i]);
            }
        }
        ParameterScopedMetricsRule retVal = new ParameterScopedMetricsRule(paramName, nounTypePatterns, actParamConstraintArr, ctxParamConstraintArr);
        return retVal;
    }

    public String toString() {
        boolean addComma = false;
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        JSONUtils.appendNameValuePair(sb, "ruleId", this.mRuleId);
        sb.append(',');
        JSONUtils.appendNameValuePair(sb, "nounTypePatterns", this.mNounTypePatterns);
        sb.append(',');
        JSONUtils.appendNameValuePair(sb, "actParamConstraints", this.mActivationParameterConstraints);
        sb.append(',');
        JSONUtils.appendNameValuePair(sb, "ctxParamConstraints", this.mContextParameterConstraints);
        sb.append('}');
        return sb.toString();
    }

    static {
        RULE_CT_ITEM_NAMES = new String[]{"parameterScopedMetricsRuleId", "parameterScopedMetricsRuleNounTypes", "parameterScopedMetricsRuleActParamConstraint", "parameterScopedMetricsRuleCtxParamConstraint"};
        RULE_CT_ITEM_DESCRIPTIONS = new String[]{"The id of the parameter scoped metric rule.", "The noun types to which the rule applies.", "The activation parameter constraints used by the rule (if any).", "The context parameter constraints used by the rule (if any)."};
        CompositeType ruleCT = null;
        ArrayType<String[]> nounTypesCT = null;
        ArrayType<CompositeData[]> actParamConstraintsCT = null;
        ArrayType<CompositeData[]> ctxParamConstraintsCT = null;
        OpenType[] ruleCTItemTypes = null;
        try {
            nounTypesCT = ArrayType.getArrayType(SimpleType.STRING);
            actParamConstraintsCT = ArrayType.getArrayType(ParameterConstraint.toCompositeType());
            ctxParamConstraintsCT = ArrayType.getArrayType(ParameterConstraint.toCompositeType());
            ruleCTItemTypes = new OpenType[]{SimpleType.STRING, nounTypesCT, actParamConstraintsCT, ctxParamConstraintsCT};
            ruleCT = new CompositeType("DMSParameterScopedMetricsRule", "Read-only data describing a DMS parameter scoped metric rule.", RULE_CT_ITEM_NAMES, RULE_CT_ITEM_DESCRIPTIONS, ruleCTItemTypes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ruleCTItemTypes != null && ruleCT != null) {
            RULE_CT = ruleCT;
            RULE_CT_ITEM_TYPES = ruleCTItemTypes;
        } else {
            RULE_CT = null;
            RULE_CT_ITEM_TYPES = null;
        }
    }

    public static class NounTypePattern {
        private final String mNounType;
        private final NounTypeOperator mNounTypeOperator;
        private final int mHashCode;
        public static final NounTypePattern ALL_NOUN_TYPES = new NounTypePattern(null, NounTypeOperator.ANY);

        public NounTypePattern(String nounTypePatternAsString) {
            NounTypeOperator operator = NounTypeOperator.EQUALS;
            String nounTypeString = nounTypePatternAsString.trim();
            int spaceLoc = nounTypePatternAsString.indexOf(32);
            if (spaceLoc > 0) {
                String operatorString = nounTypePatternAsString.substring(0, spaceLoc);
                operator = NounTypeOperator.findOperator(operatorString);
                if (operator == null) {
                    throw new IllegalArgumentException("Unrecognized operator: " + operatorString);
                }
                nounTypeString = nounTypePatternAsString.substring(spaceLoc + 1).trim();
            }
            this.mNounType = nounTypeString;
            this.mNounTypeOperator = operator;
            this.mHashCode = this.mNounType.hashCode() ^ this.mNounTypeOperator.hashCode();
        }

        public NounTypePattern(String nounType, NounTypeOperator nounTypeOperator) {
            this.mNounType = nounType == null ? null : nounType.trim();
            this.mNounTypeOperator = nounTypeOperator;
            this.mHashCode = (this.mNounType == null ? 0 : this.mNounType.hashCode()) ^ this.mNounTypeOperator.hashCode();
        }

        public String getNounType() {
            return this.mNounType;
        }

        public NounTypeOperator getNounTypeOperator() {
            return this.mNounTypeOperator;
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean isMatch(String s) {
            boolean retVal = this.mNounTypeOperator.isMatch(this.mNounType, s);
            return retVal;
        }

        public boolean equals(Object o) {
            boolean retVal = false;
            if (o instanceof NounTypePattern) {
                NounTypePattern that = (NounTypePattern)o;
                retVal = ObjectUtils.areEqual(this.mNounType, that.mNounType) && ObjectUtils.areEqual((Object)this.mNounTypeOperator, (Object)that.mNounTypeOperator);
            }
            return retVal;
        }

        public String toString() {
            String retVal = (this.mNounTypeOperator.getPrimaryAlias() == null ? "" : this.mNounTypeOperator.getPrimaryAlias()) + (this.mNounType == null ? "" : " " + this.mNounType);
            return retVal;
        }
    }

    public static enum NounTypeOperator {
        STARTS_WITH(new String[]{"sw", "startsWith"}, "startsWith"){

            @Override
            public boolean isMatch(String pattern, String forComparison) {
                boolean retVal = false;
                if (forComparison != null) {
                    retVal = forComparison.startsWith(pattern);
                }
                return retVal;
            }
        }
        ,
        EQUALS(new String[]{"eq", "equals"}, "equals"){

            @Override
            public boolean isMatch(String pattern, String forComparison) {
                boolean retVal = false;
                retVal = forComparison != null ? forComparison.equals(pattern) : pattern == null;
                return retVal;
            }
        }
        ,
        ANY(new String[0], null){

            @Override
            public boolean isMatch(String pattern, String forComparison) {
                return true;
            }
        };

        private String[] mAliases;
        private String mPrimaryAlias;

        private NounTypeOperator(String[] aliases, String primaryAlias) {
            this.mAliases = aliases;
            this.mPrimaryAlias = primaryAlias;
        }

        public String getPrimaryAlias() {
            return this.mPrimaryAlias;
        }

        public boolean isMatch(String pattern, String forComparison) {
            return false;
        }

        public static NounTypeOperator findOperator(String queryAlias) {
            NounTypeOperator retVal = null;
            if (queryAlias != null) {
                queryAlias = queryAlias.trim();
                for (NounTypeOperator nto : NounTypeOperator.values()) {
                    for (String alias : nto.mAliases) {
                        if (!alias.equalsIgnoreCase(queryAlias)) continue;
                        retVal = nto;
                        break;
                    }
                    if (retVal != null) break;
                }
            }
            return retVal;
        }
    }
}

