/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.MetricDescriptor;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.reporter.TableExporter;
import oracle.dms.reporter.TbmlReporter;
import oracle.dms.spy.Metric;
import oracle.dms.table.TableSupport;
import oracle.dms.table.ValueType;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.QueryOptions;

public class DMSTbmlGenerator
extends TableExporter {
    private Noun[][] m_nouns = null;
    private Sensor[][][] m_sensors;
    private Metric[][][][] m_metrics;
    private Serializable[][][][] m_values;
    private NounDescriptor[] m_ndescs = null;

    @Override
    public TableExporter copy() {
        return new DMSTbmlGenerator();
    }

    @Override
    public void getTableNames(Collection<String> list, QueryOptions options) {
        if (list == null) {
            return;
        }
        String[] tables = Noun.getAllTypes();
        if (tables != null) {
            list.addAll(Arrays.asList(tables));
        }
    }

    @Override
    public boolean containsTable(String name, QueryOptions options) {
        return Noun.getDescriptorByType(name) != null;
    }

    @Override
    public void close() {
        super.close();
        this.m_nouns = null;
        this.m_sensors = null;
        this.m_metrics = null;
        this.m_values = null;
        this.m_ndescs = null;
    }

    @Override
    public boolean init(List<String> tableNames, QueryOptions options) {
        if (!super.init(tableNames, options)) {
            return false;
        }
        int size = this.m_tableNames.size();
        this.m_nouns = new Noun[size][];
        this.m_sensors = new Sensor[size][][];
        this.m_metrics = new Metric[size][][][];
        this.m_values = new Serializable[size][][][];
        this.m_ndescs = new NounDescriptor[size];
        for (int i = 0; i < this.m_nouns.length; ++i) {
            String table = (String)this.m_tableNames.get(i);
            this.m_nouns[i] = Noun.getNounsByType(table);
            this.m_sensors[i] = new Sensor[this.m_nouns[i].length][];
            this.m_metrics[i] = new Metric[this.m_nouns[i].length][][];
            this.m_values[i] = new Serializable[this.m_nouns[i].length][][];
            this.m_ndescs[i] = Noun.getDescriptorByType(table);
        }
        return true;
    }

    @Override
    public void refreshMetrics() {
        int i;
        int j;
        HashSet<GroupRefresh> gRefresh = new HashSet<GroupRefresh>();
        int size = 0;
        for (int k = this.m_nouns.length - 1; k >= 0; --k) {
            if (this.m_nouns[k] == null) continue;
            String table = (String)this.m_tableNames.get(k);
            long valueRefreshTime = this.m_options.valueRefreshTime(table);
            for (j = this.m_nouns[k].length - 1; j >= 0; --j) {
                if (this.m_nouns[k][j] == null) continue;
                this.m_sensors[k][j] = this.m_nouns[k][j].getSensors();
                if (this.m_sensors[k][j] == null) continue;
                this.m_metrics[k][j] = new Metric[this.m_sensors[k][j].length][];
                for (i = this.m_sensors[k][j].length - 1; i >= 0; --i) {
                    long lastSensorUpdate;
                    if (this.m_sensors[k][j][i] == null || valueRefreshTime > (lastSensorUpdate = this.m_sensors[k][j][i].getUpdateTime()) && lastSensorUpdate != 0L) continue;
                    Vector<Metric> metricVec = new Vector<Metric>();
                    this.m_sensors[k][j][i].getMetrics(metricVec);
                    int len = metricVec.size();
                    if (len == 0) continue;
                    size += len;
                    this.m_metrics[k][j][i] = new Metric[len];
                    metricVec.toArray(this.m_metrics[k][j][i]);
                }
            }
        }
        if (size == 0) {
            gRefresh.clear();
            return;
        }
        int p = 0;
        Metric[] metricArray = new Metric[size];
        for (int k = this.m_nouns.length - 1; k >= 0; --k) {
            if (this.m_nouns[k] == null) continue;
            for (int j2 = this.m_nouns[k].length - 1; j2 >= 0; --j2) {
                if (this.m_sensors[k][j2] == null) continue;
                for (int i2 = this.m_sensors[k][j2].length - 1; i2 >= 0; --i2) {
                    if (this.m_metrics[k][j2][i2] == null) continue;
                    int len = this.m_metrics[k][j2][i2].length;
                    System.arraycopy(this.m_metrics[k][j2][i2], 0, metricArray, p, len);
                    p += len;
                }
            }
        }
        Serializable[] values = Metric.getSerializableValues(metricArray, gRefresh);
        p = 0;
        for (int k = this.m_nouns.length - 1; k >= 0; --k) {
            if (this.m_nouns[k] == null) continue;
            for (j = this.m_nouns[k].length - 1; j >= 0; --j) {
                if (this.m_sensors[k][j] == null) continue;
                this.m_values[k][j] = new Serializable[this.m_sensors[k][j].length][];
                for (i = this.m_sensors[k][j].length - 1; i >= 0; --i) {
                    if (this.m_metrics[k][j][i] == null) continue;
                    int len = this.m_metrics[k][j][i].length;
                    this.m_values[k][j][i] = new Serializable[len];
                    System.arraycopy(values, p, this.m_values[k][j][i], 0, len);
                    p += len;
                }
            }
        }
        gRefresh.clear();
    }

    @Override
    public void printTables(PrintWriter out) {
        boolean includeSchema = this.m_options.includeSchema();
        boolean includeRows = this.m_options.includeRows();
        for (int i = this.m_nouns.length - 1; i >= 0; --i) {
            if (this.m_nouns[i] == null) continue;
            String table = (String)this.m_tableNames.get(i);
            TbmlReporter.printTableHeading(table, TableSupport.getDefaultKeys(), null, out);
            if (includeSchema) {
                this._printSchema(i, out);
            }
            if (includeRows) {
                long valueRefreshTime = this.m_options.valueRefreshTime(table);
                this._printValues(i, valueRefreshTime, out);
            }
            TbmlReporter.printTableEnding(out);
        }
    }

    private void _printSchema(int index, PrintWriter out) {
        String[] ancestorTypes;
        String[] sensorNames = this.m_ndescs[index].getSensorNames();
        if (sensorNames != null) {
            for (String sensorName : sensorNames) {
                SensorDescriptor sdesc = this.m_ndescs[index].getSensorDescriptor(sensorName);
                if (sdesc == null) continue;
                String[] metricNames = sdesc.getMetricNames();
                String sensorType = sdesc.getType();
                String description = sdesc.getDescription();
                TbmlReporter.printColumnGroup(sensorName, sensorType, metricNames, description, out);
                if (metricNames == null || metricNames.length <= 0) continue;
                for (String metricName : metricNames) {
                    MetricDescriptor mdesc = sdesc.getMetricDescriptor(metricName);
                    if (mdesc == null) continue;
                    String type = mdesc.getValueType();
                    String unit = mdesc.getUnit();
                    TbmlReporter.printColumnDefinition(metricName, type, unit, description, out);
                }
            }
        }
        if ((ancestorTypes = this.m_ndescs[index].getAncestorTypes()) != null) {
            for (String ancestorType : ancestorTypes) {
                TbmlReporter.printColumnDefinition(ancestorType, out);
            }
        }
        TbmlReporter.printColumnDefinition("Name", out);
        TbmlReporter.printColumnDefinition("Parent", out);
        TbmlReporter.printColumnDefinition("Host", out);
        TbmlReporter.printColumnDefinition("Process", out);
    }

    private void _printValues(int index, long valueRefreshTime, PrintWriter out) {
        for (int j = 0; j < this.m_nouns[index].length; ++j) {
            if (this.m_nouns[index][j] == null) continue;
            TbmlReporter.printRowHeading(true, out);
            Noun parent = this.m_nouns[index][j].getParent();
            if (this.m_sensors[index][j] != null) {
                for (int i = 0; i < this.m_sensors[index][j].length; ++i) {
                    if (this.m_sensors[index][j][i] == null || this.m_metrics[index][j][i] == null) continue;
                    for (int k = 0; k < this.m_metrics[index][j][i].length; ++k) {
                        if (this.m_metrics[index][j][i][k] == null) continue;
                        TbmlReporter.printColumn(this.m_metrics[index][j][i][k].getName(), this.m_values[index][j][i][k], null, out);
                    }
                }
            }
            TbmlReporter.printColumn("Name", (Serializable)((Object)this.m_nouns[index][j].getName()), ValueType.STRING, out);
            TbmlReporter.printColumn("Parent", (Serializable)((Object)parent.toString()), ValueType.STRING, out);
            TbmlReporter.printColumn("Host", (Serializable)((Object)DMSUtil.getLocalHostname()), ValueType.STRING, out);
            TbmlReporter.printColumn("Process", (Serializable)((Object)DMSUtil.getProcessName()), ValueType.STRING, out);
            long lastNounUpdate = this.m_nouns[index][j].getCreateTime();
            if (valueRefreshTime <= lastNounUpdate || lastNounUpdate == 0L) {
                while (parent.getParent() != null) {
                    String type = parent.getType();
                    if (!"n/a".equals(type) && type.trim().length() != 0) {
                        TbmlReporter.printColumn(type, (Serializable)((Object)parent.getName()), ValueType.STRING, out);
                    }
                    parent = parent.getParent();
                }
            }
            TbmlReporter.printRowEnding(out);
        }
    }
}

