/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import java.util.Date;
import oracle.dms.http.Request;
import oracle.dms.reporter.BranchTreeletNode;
import oracle.dms.reporter.LeafTreeletNode;
import oracle.dms.reporter.TreeletReporter;
import oracle.dms.util.Time;

public class RawReporter
extends TreeletReporter {
    public RawReporter(Request request) {
        super(request);
        this.m_treeletOptions.setIsOrdered(true);
        this.m_treeletOptions.setFormat("raw");
    }

    @Override
    void printHeading(PrintWriter out) {
        if (!"true".equalsIgnoreCase(this.m_request.getParameter("nodoctype"))) {
            out.print("<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE DMSDUMP>\n");
        }
        out.print("<DMSDUMP version='");
        out.print("11.0");
        out.print("' timestamp='");
        long tstamp = Time.currentTimeMillis();
        out.print(tstamp);
        out.print(" (");
        Date date = new Date(tstamp);
        out.print(date);
        out.print(")' id='");
        out.print(this.m_id);
        out.print("' name='");
        out.print(this.m_name);
        out.print("'>\n");
    }

    @Override
    void printEnding(PrintWriter out) {
        out.print("</DMSDUMP>\n");
    }

    @Override
    void startPrintBranchNode(BranchTreeletNode node, PrintWriter out) {
        this.m_treeletOptions.getIndentation().increIndent();
        node.startPrintNode(this.m_treeletOptions, out);
    }

    @Override
    void printLeafNode(LeafTreeletNode node, PrintWriter out) {
        this.m_treeletOptions.getIndentation().increIndent();
        node.printNode(this.m_treeletOptions, out);
        this.m_treeletOptions.getIndentation().decreIndent();
    }

    @Override
    void endPrintBranchNode(BranchTreeletNode node, PrintWriter out) {
        this.m_treeletOptions.getIndentation().decreIndent();
    }
}

