/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dms.instrument.Level;
import oracle.dms.instrument.Log;
import oracle.dms.instrument.Noun;
import oracle.dms.spy.ConfigurationError;
import oracle.dms.spy.IllegalOperation;
import oracle.dms.spy.Metric;
import oracle.dms.spy.Publisher;
import oracle.dms.spy.PublisherError;
import oracle.dms.spy.SpyFileUtil;
import oracle.dms.spy.StatisticsProducer;
import oracle.dms.spy.TreeNode;
import oracle.dms.spy.jvm.ThreadMonitor;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;

public class Spy {
    public static final String PUBLISHER_CLASSES = "oracle.dms.publisher.classes";
    public static final String HTTP_PUBLISHER_CLASS = "oracle.dms.http.Httpd";
    private static final String PUBLISHER_DELIMITORS = ",;";
    private static StatisticsProducer _spy;
    private static Vector<Publisher> _sPublisher;
    private static volatile boolean s_active;
    private static volatile boolean _sPublishInited;
    private static String _defaultDumpFile;
    private static final String NOT_ALIVE = "NOT_ALIVE";
    private static final String PREFIX = "SPY_";
    private static final String SPY = "Spy";
    private static final String PUBINIT = "pubInit";
    private static final String SPYEXIT = "spyExit";

    private Spy() {
    }

    public static synchronized void init() throws ConfigurationError, PublisherError {
        Spy.init("", null);
    }

    public static synchronized void init(String name, Properties props) throws ConfigurationError, PublisherError {
        if (Spy.isActive()) {
            if (name != null) {
                Spy.setName(name, true);
            }
            return;
        }
        Spy._setActive(true);
        DMSProperties.init(props);
        Log.init();
        if (name == null) {
            name = "";
        }
        Spy.setName(name, true);
        _spy = new StatisticsProducer();
        Spy.initPublisher();
    }

    public static synchronized void initPublisher() throws ConfigurationError, PublisherError {
        if (!Spy.isActive() || _sPublishInited) {
            return;
        }
        String publisher = DMSProperties.getProperty(PUBLISHER_CLASSES);
        if (publisher == null) {
            return;
        }
        _sPublishInited = true;
        boolean failed = true;
        try {
            StringTokenizer st = new StringTokenizer(publisher, PUBLISHER_DELIMITORS);
            while (st.hasMoreTokens()) {
                String pName = st.nextToken();
                Class<?> pubClass = Class.forName(pName);
                Publisher pub = (Publisher)pubClass.newInstance();
                _sPublisher.addElement(pub);
                Log.log(DMSUtil.genCompNounPath("Spy/pubInit"), DMSNLSupport.getString("SPY_pubInit"), Level.DEBUG, new Object[]{pName});
            }
            failed = false;
        }
        catch (ClassNotFoundException e) {
            ConfigurationError ce = new ConfigurationError("50702", publisher, e);
            throw ce;
        }
        catch (InstantiationException e) {
            PublisherError ce = new PublisherError("50717", publisher, e);
            throw ce;
        }
        catch (IllegalAccessException e) {
            PublisherError ce = new PublisherError("50717", publisher, e);
            throw ce;
        }
        catch (ClassCastException e) {
            PublisherError ce = new PublisherError("50717", publisher, e);
            throw ce;
        }
        catch (Exception e) {
            PublisherError ce = new PublisherError("50717", publisher, e);
            throw ce;
        }
        finally {
            if (failed) {
                for (Publisher pub : _sPublisher) {
                    pub.publisherExit();
                }
            }
        }
    }

    public static synchronized boolean isActive() {
        return s_active;
    }

    private static synchronized void _setActive(boolean active) {
        s_active = active;
    }

    public static Vector<Publisher> getPublisher() {
        return new Vector<Publisher>(_sPublisher);
    }

    public static void setName(String name) {
        Spy.setName(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setName(String name, boolean force) {
        Noun root;
        if (name == null) {
            name = "";
        }
        if (!Spy.isActive()) {
            return;
        }
        if (!force && name.length() == 0) {
            return;
        }
        Noun noun = root = Noun.getRoot();
        synchronized (noun) {
            if (force) {
                root.setName(name);
            } else {
                String rootName = root.getName();
                if (rootName == null || rootName.length() == 0) {
                    root.setName(name);
                }
            }
        }
    }

    public static String getName() {
        return Noun.getRoot().getName();
    }

    public static synchronized void exit() {
        Spy.exit(true);
    }

    public static synchronized void exit(boolean dumpResults) {
        if (!Spy.isActive()) {
            return;
        }
        Log.log(DMSUtil.genCompNounPath("Spy/spyExit"), DMSNLSupport.getString("SPY_spyExit"), Level.DEBUG, null);
        if (dumpResults) {
            Spy.dump();
        }
        Log.shutdown();
        for (Publisher pub : _sPublisher) {
            pub.publisherExit();
        }
        _sPublisher.clear();
        _sPublishInited = false;
        if (_spy != null) {
            _spy.exit();
            _spy = null;
        }
        DMSProperties.exit();
        DMSUtil.exit();
        ThreadMonitor.exit();
        _defaultDumpFile = "dms.log";
        Spy._setActive(false);
    }

    public static synchronized void setDumpFile(String name) {
        if (name != null) {
            _defaultDumpFile = name;
        }
    }

    public static synchronized String getDumpFile() {
        return _defaultDumpFile;
    }

    public static synchronized Noun getRoot() {
        return Noun.getRoot();
    }

    private static void _checkAlive() {
        if (!Spy.isActive()) {
            throw new IllegalOperation(DMSNLSupport.getMessage(NOT_ALIVE, new Object[]{SPY, ""}));
        }
    }

    public static synchronized TreeNode getTreeNode(String name) {
        Spy._checkAlive();
        Noun n = Noun.get(name);
        if (n != null) {
            return n;
        }
        n = Noun.get(DMSUtil.getParentFromPath(name));
        String base = DMSUtil.getLeafFromPath(name);
        if (n == null) {
            return null;
        }
        Vector<Metric> mets = n.getMetrics();
        if (mets != null) {
            for (Metric m : mets) {
                if (!m.getName().equals(base)) continue;
                return m;
            }
        }
        return null;
    }

    public static Object getMetricValue(String name) {
        TreeNode tn = Spy.getTreeNode(name);
        if (tn == null) {
            return null;
        }
        if (!(tn instanceof Metric)) {
            return null;
        }
        Metric met = (Metric)tn;
        Object retval = met.getValue();
        return retval;
    }

    public static Vector<Metric> getMetrics(String query) {
        return null;
    }

    public static synchronized void dump() {
        Spy.dump(_defaultDumpFile, true, true);
    }

    public static synchronized void dump(String filename, boolean pretty, boolean append) {
        Spy._checkAlive();
        try {
            File file = new File(filename);
            boolean isExists = SpyFileUtil.exists(file);
            FileWriter fw = SpyFileUtil.createFileWriter(file, append);
            PrintWriter pw = new PrintWriter(fw);
            _spy.dump(pw, pretty);
            fw.close();
            if (!isExists) {
                SpyFileUtil.setReadable(file, false, false);
                SpyFileUtil.setWritable(file, false, false);
                SpyFileUtil.setExecutable(file, false, false);
                SpyFileUtil.setReadable(file, true, true);
                SpyFileUtil.setWritable(file, true, true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized void dump(PrintWriter pw, boolean pretty) throws IOException {
        Spy._checkAlive();
        _spy.dump(pw, pretty);
    }

    public static synchronized Object[] getValues(Metric[] mets) {
        return Metric.getValues(mets);
    }

    static {
        _sPublisher = new Vector(4);
        s_active = false;
        _sPublishInited = false;
        _defaultDumpFile = "dms.log";
    }
}

