/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import oracle.dms.util.DMSProperties;

public class Time {
    private static boolean sEnforceNonDecreasingTime = false;
    private static boolean sEnforceNonDecreasingTimeSet = false;
    private static long sLatestTime = Long.MIN_VALUE;
    private static Object sLatestTimeLockObject = new Object();

    private Time() {
    }

    public static synchronized void setEnforceNonDecreasingTime(boolean isEnforced) {
        sEnforceNonDecreasingTime = isEnforced;
        sEnforceNonDecreasingTimeSet = true;
    }

    public static boolean isEnforceNonDecresingTime() {
        if (!sEnforceNonDecreasingTimeSet) {
            boolean b = DMSProperties.getPropertyBoolean("oracle.dms.time.enforceNonDecreasingTime", false);
            Time.setEnforceNonDecreasingTime(b);
        }
        return sEnforceNonDecreasingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long currentTimeMillis() {
        long retVal = -1L;
        if (Time.isEnforceNonDecresingTime()) {
            long now = System.currentTimeMillis();
            Object object = sLatestTimeLockObject;
            synchronized (object) {
                if (now > sLatestTime) {
                    sLatestTime = now;
                }
                retVal = sLatestTime;
            }
        } else {
            retVal = System.currentTimeMillis();
        }
        return retVal;
    }
}

