/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.wls;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.dms.ReadableValueHolder;
import weblogic.security.Security;
import weblogic.security.SubjectUtils;

public class WLSUserValueHolder
implements ReadableValueHolder<String> {
    private static Logger s_logger = Logger.getLogger("oracle.dms.context", "oracle.dms.context.ContextResourceBundle");

    public WLSUserValueHolder() throws Exception {
        Class.forName("weblogic.security.Security");
        Class.forName("weblogic.security.SubjectUtils");
    }

    @Override
    public String getValue() {
        String retVal = null;
        try {
            retVal = SubjectUtils.getUsername((Subject)this.getCurrentSubject());
        }
        catch (Exception e) {
            retVal = null;
        }
        return retVal;
    }

    private Subject getCurrentSubject() {
        Subject subject = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return Subject.getSubject(AccessController.getContext());
            }
        });
        if (subject == null) {
            subject = Security.getCurrentSubject();
            if (s_logger.isLoggable(Level.FINER)) {
                s_logger.finer("unable to get Subject using JAAS API; using WebLogic Server security got: " + subject);
            }
        } else if (s_logger.isLoggable(Level.FINER)) {
            s_logger.finer("using the JAAS API got Subject: " + subject);
        }
        return subject;
    }
}

