/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.Vector;
import oracle.dms.context.ExecutionContext;
import oracle.dms.event.Destination;
import oracle.dms.event.Event;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventSourceType;
import oracle.dms.instrument.Noun;

public class NounLifecycleWalker {
    private Destination m_listener;

    public NounLifecycleWalker(Destination listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener=" + listener);
        }
        this.m_listener = listener;
    }

    public void walk(Noun noun) {
        if (noun == null) {
            return;
        }
        EventImpl event = new EventImpl(noun);
        this.m_listener.handleEvent(event);
        Vector<Noun> children = noun.getNouns();
        if (children == null) {
            return;
        }
        for (Noun child : children) {
            if (child == null) continue;
            this.walk(child);
        }
    }

    private static class EventImpl
    implements Event {
        Noun mSource;

        private EventImpl(Noun n) {
            this.mSource = n;
        }

        @Override
        public Object getSource() {
            return this.mSource;
        }

        @Override
        public Object getSubsidiaryObject(int index) {
            return null;
        }

        @Override
        public EventSourceType getSourceType() {
            return EventSourceType.NOUN;
        }

        @Override
        public EventActionType getActionType() {
            return EventActionType.CREATE;
        }

        @Override
        public ExecutionContext getExecutionContext() {
            return null;
        }

        @Override
        public long getTime() {
            return 0L;
        }

        @Override
        public StackTraceElement[] getStack() {
            return null;
        }

        @Override
        public void setExecutionContext(ExecutionContext executionContext) {
        }

        @Override
        public Object[] getSubsidiaryObjects() {
            return null;
        }
    }
}

