/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;

public class OSStats {
    private static OSStats s_stats = null;
    private State m_version = null;
    private State m_procs = null;

    private OSStats() {
    }

    private OSStats(Noun baseNoun) {
        if (baseNoun == null) {
            baseNoun = Noun.create("/JVM/MxBeans");
        }
        OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        Noun noun = Noun.create(baseNoun, "system", "JVM_OS");
        State name = State.create(noun, "name", (byte)5, "", "name of the OS");
        name.update(bean.getName());
        State arch = State.create(noun, "architecture", (byte)5, "", "architecture of the OS");
        arch.update(bean.getArch());
        State version = State.create(noun, "version", (byte)5, "", "version of the OS");
        version.update(bean.getVersion());
        State procs = State.create(noun, "processors", (byte)3, "", "number of available processors on host");
        procs.update(bean.getAvailableProcessors());
    }

    public static void create(Noun base) {
        if (s_stats != null) {
            return;
        }
        s_stats = new OSStats(base);
    }

    static void exit() {
        s_stats = null;
    }
}

