/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import oracle.dms.table.Row;
import oracle.dms.table.RowSelector;
import oracle.dms.table.Selector;

class AndOrNotSelector
extends RowSelector {
    private RowSelector m_selector1 = null;
    private RowSelector m_selector2 = null;

    AndOrNotSelector(RowSelector selector1, RowSelector selector2, Selector.Operator operator) {
        super(operator);
        if (selector1 == null || selector2 == null) {
            throw new IllegalArgumentException("selector1=" + selector1 + " selector2=" + selector2);
        }
        this.m_selector1 = selector1;
        this.m_selector2 = selector2;
    }

    AndOrNotSelector(RowSelector selector, Selector.Operator operator) {
        super(operator);
        if (selector == null) {
            throw new IllegalArgumentException("selector=" + selector);
        }
        this.m_selector1 = selector;
    }

    @Override
    public boolean select(Row row) {
        switch (this.m_operator) {
            case AND: {
                return this.m_selector1.select(row) && this.m_selector2.select(row);
            }
            case OR: {
                return this.m_selector1.select(row) || this.m_selector2.select(row);
            }
            case NOT: {
                return !this.m_selector1.select(row);
            }
        }
        return true;
    }

    public String toString() {
        switch (this.m_operator) {
            case AND: {
                return '(' + this.m_selector1.toString() + " AND " + this.m_selector2.toString() + ')';
            }
            case OR: {
                return '(' + this.m_selector1.toString() + " OR " + this.m_selector2.toString() + ')';
            }
            case NOT: {
                return "(NOT " + this.m_selector1.toString() + ')';
            }
        }
        return super.toString();
    }
}

