/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
final class NIOHeader {
    int length;
    int packetChecksum;
    int flags;
    int headerChecksum;
    int type;
    final SessionAtts session;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    NIOHeader(SessionAtts sessionAtts) {
        this.session = sessionAtts;
    }

    final void readHeaderBuffer() throws IOException, NetException {
        this.session.headerBufferForRead = this.session.readBuffer.slice();
        this.session.headerBufferForRead.clear();
        this.session.headerBufferForRead.limit(8);
        this.session.headerBufferForRead.rewind();
        this.readNSHeader();
    }

    final void readNSHeader() throws IOException {
        if (this.session.isLargeSDU && (this.type == 6 || this.type == 12 || this.type == 15 || this.type == 14)) {
            this.length = this.session.headerBufferForRead.getInt() & 0xFFFFFFFF;
        } else {
            this.length = this.session.headerBufferForRead.getShort() & 0xFFFF;
            this.packetChecksum = this.session.headerBufferForRead.getShort() & 0xFFFF;
        }
        this.type = this.session.headerBufferForRead.get() & 0xFF;
        this.flags = this.session.headerBufferForRead.get() & 0xFF;
        this.headerChecksum = this.session.headerBufferForRead.getShort() & 0xFFFF;
    }

    final void fillHeaderBuffer() throws IOException {
        this.session.headerBufferForWrite.clear();
        if (this.session.isLargeSDU && (this.type == 6 || this.type == 12 || this.type == 15 || this.type == 14)) {
            this.session.headerBufferForWrite.putInt(this.length);
        } else {
            this.session.headerBufferForWrite.putShort((short)this.length);
            this.session.headerBufferForWrite.putShort((short)0);
        }
        this.session.headerBufferForWrite.put((byte)this.type);
        this.session.headerBufferForWrite.put((byte)this.flags);
        this.session.headerBufferForWrite.putShort((short)0);
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$3 = NIOHeader.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = NIOHeader.class.getDeclaredMethod("fillHeaderBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = NIOHeader.class.getDeclaredMethod("readNSHeader", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = NIOHeader.class.getDeclaredMethod("readHeaderBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
    }
}

