/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import oracle.net.ns.NIOHeader;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;
import oracle.net.ns.ZLIBCodec;

final class NIOAcceptPacket
extends NIOPacket {
    protected int version;
    protected int options;
    protected int sduSize;
    protected int tduSize;
    protected int myHWByteOrder;
    protected int flag0;
    protected int flag1;
    String connectData;
    boolean isOOBCheckEnabled;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    NIOAcceptPacket(NIOHeader nIOHeader, SessionAtts sessionAtts) throws IOException {
        super(nIOHeader, sessionAtts);
    }

    @Override
    void readPayloadBuffer() throws IOException, NetException {
        int n2;
        short s2 = 0;
        short s3 = 0;
        this.version = this.session.payloadBufferForRead.getShort();
        this.options = this.session.payloadBufferForRead.getShort();
        this.sduSize = this.session.payloadBufferForRead.getShort() & 0xFFFF;
        this.tduSize = this.session.payloadBufferForRead.getShort() & 0xFFFF;
        this.myHWByteOrder = this.session.payloadBufferForRead.getShort();
        short s4 = this.session.payloadBufferForRead.getShort();
        short s5 = this.session.payloadBufferForRead.getShort();
        this.flag0 = this.session.payloadBufferForRead.get();
        this.flag1 = this.session.payloadBufferForRead.get();
        this.session.timeout = this.session.payloadBufferForRead.getShort();
        this.session.tick = this.session.payloadBufferForRead.getShort();
        s2 = this.session.payloadBufferForRead.getShort();
        s3 = this.session.payloadBufferForRead.getShort();
        boolean bl = this.session.noAnoServices = (this.flag1 & 8) == 8;
        if (!this.session.noAnoServices) {
            this.session.noAnoServices = (this.flag0 & 4) == 4;
        }
        this.session.timeout -= this.session.tick;
        this.session.timeout *= 10;
        if (s2 > 0) {
            this.session.reconnectAddress = new byte[s2];
            this.session.payloadBufferForRead.position(s3 - 8);
            this.session.payloadBufferForRead.get(this.session.reconnectAddress, 0, s2);
        }
        if (this.version >= 315) {
            this.sduSize = this.session.payloadBufferForRead.getInt(24);
            this.tduSize = this.session.payloadBufferForRead.getInt(28);
            this.session.isLargeSDU = true;
            this.session.dataChannel.setLargeSDU(true);
            this.session.markerPacket.setLargeSDU(true);
            n2 = this.session.payloadBufferForRead.get(32);
            boolean bl2 = true;
            if (!this.session.cOption.protocol.equalsIgnoreCase("tcp") && (n2 & 2) == 0) {
                bl2 = false;
            }
            if (bl2 && (n2 & 0x80) != 0) {
                this.session.negotiatedNetworkCompression = (n2 & 0x40) != 0 ? "auto" : "on";
                this.session.negotiatedNetworkCompressionScheme = (n2 & 0x3C) >> 2;
                this.session.networkCompressionEnabled = true;
                if (this.session.negotiatedNetworkCompressionScheme == 1) {
                    throw new IOException("Unsupported Compression Scheme");
                }
                if (this.session.negotiatedNetworkCompressionScheme == 2) {
                    this.session.compressionCodec = new ZLIBCodec();
                }
            } else {
                this.session.negotiatedNetworkCompression = "off";
                this.session.networkCompressionEnabled = false;
            }
            if (this.version >= 318) {
                int n3 = this.session.payloadBufferForRead.getInt(33);
                this.isOOBCheckEnabled = !this.session.noAnoServices && (n3 & 1) > 0;
                this.session.isPollAndCheckEnabled = (n3 & 0x1000000) != 0;
            }
        }
        if (this.session.timeout > 0) {
            n2 = s4 + s5 - 8;
            this.session.poolEnabled = true;
            this.session.sessionId = new byte[16];
            this.session.payloadBufferForRead.position(n2);
            this.session.payloadBufferForRead.get(this.session.sessionId, 0, 16);
            this.session.dataChannel.setPoolEnabled(true);
            this.session.timestampLastIO = System.currentTimeMillis();
        }
        if (s4 > 0) {
            byte[] byArray = null;
            if (this.session.payloadBufferForRead.hasRemaining() && this.session.payloadBufferForRead.position(s5 - 8).remaining() > 0) {
                byArray = new byte[s4];
                this.session.payloadBufferForRead.get(byArray);
            } else {
                byArray = this.session.dataChannel.readPayloadDataFromSocketChannel(s4);
            }
            this.connectData = new String(byArray, Charset.forName("US-ASCII"));
        } else {
            this.connectData = "";
        }
        if (this.tduSize < this.sduSize) {
            this.session.setNegotiatedSDUAndTDU(this.tduSize, this.tduSize);
        } else {
            this.session.setNegotiatedSDUAndTDU(this.sduSize, this.tduSize);
        }
        this.session.setNegotiatedOptions(this.options);
        if (this.session.networkCompressionEnabled) {
            this.session.dataChannel.initializeNetworkCompressionBuffers();
        }
    }

    static {
        try {
            $$$methodRef$$$1 = NIOAcceptPacket.class.getDeclaredConstructor(NIOHeader.class, SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NIOAcceptPacket.class.getDeclaredMethod("readPayloadBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

