/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInput;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.AssociativeArrayEntry;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.ConcreteProxyUtil;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.COLLECTION_METADATA})
public class ArrayDescriptor
extends TypeDescriptor
implements OracleTypeMetaData.Array,
Serializable {
    public static final int TYPE_VARRAY = 3;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int CACHE_NONE = 0;
    public static final int CACHE_ALL = 1;
    public static final int CACHE_LAST = 2;
    static final long serialVersionUID = 3838105394346513809L;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;

    public static ArrayDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$0, null, string, connection);
            }
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(string, connection, false, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$0, null, arrayDescriptor);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$0, null, null);
            }
            return arrayDescriptor;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    public static ArrayDescriptor createDescriptor(String string, Connection connection, boolean bl, boolean bl2) throws SQLException {
        boolean bl3 = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$1, null, string, connection, bl, bl2);
            }
            if (string == null || string.length() == 0 || connection == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(60, "ArrayDescriptor.createDescriptor: Invalid argument, 'name' should not be an empty string and 'conn' should not be null.").fillInStackTrace();
                if (bl3) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$1, null, sQLException);
                }
                throw sQLException;
            }
            connection = ConcreteProxyUtil.unwrapConnectionProxy((oracle.jdbc.OracleConnection)connection);
            SQLName sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection);
            String string2 = sQLName.getName();
            ArrayDescriptor arrayDescriptor = null;
            if (!bl2) {
                arrayDescriptor = (ArrayDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string2);
            }
            if (arrayDescriptor == null) {
                short s2 = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getVersionNumber();
                arrayDescriptor = s2 >= 12000 ? new ArrayDescriptor(string, connection) : new ArrayDescriptor(sQLName, connection);
                if (bl) {
                    arrayDescriptor.initNamesRecursively();
                }
                ((oracle.jdbc.OracleConnection)connection).putDescriptor(string2, arrayDescriptor);
            }
            ArrayDescriptor arrayDescriptor2 = arrayDescriptor;
            if (bl3) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$1, null, arrayDescriptor2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$1, null, null);
            }
            return arrayDescriptor2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    public static ArrayDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$2, null, sQLName, connection);
            }
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(sQLName, connection, false, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$2, null, arrayDescriptor);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$2, null, null);
            }
            return arrayDescriptor;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    public static ArrayDescriptor createDescriptor(SQLName sQLName, Connection connection, boolean bl, boolean bl2) throws SQLException {
        boolean bl3 = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$3, null, sQLName, connection, bl, bl2);
            }
            connection = ConcreteProxyUtil.unwrapConnectionProxy((oracle.jdbc.OracleConnection)connection);
            String string = sQLName.getName();
            ArrayDescriptor arrayDescriptor = null;
            if (!bl2) {
                arrayDescriptor = (ArrayDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string);
            }
            if (arrayDescriptor == null) {
                arrayDescriptor = new ArrayDescriptor(sQLName, connection);
                if (bl) {
                    arrayDescriptor.initNamesRecursively();
                }
                ((oracle.jdbc.OracleConnection)connection).putDescriptor(string, arrayDescriptor);
            }
            ArrayDescriptor arrayDescriptor2 = arrayDescriptor;
            if (bl3) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$3, null, arrayDescriptor2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$3, null, null);
            }
            return arrayDescriptor2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    public static ArrayDescriptor createDescriptor(OracleTypeCOLLECTION oracleTypeCOLLECTION) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$4, null, oracleTypeCOLLECTION);
            }
            String string = oracleTypeCOLLECTION.getFullName();
            oracle.jdbc.OracleConnection oracleConnection = oracleTypeCOLLECTION.getConnection();
            ArrayDescriptor arrayDescriptor = (ArrayDescriptor)(oracleConnection = ConcreteProxyUtil.unwrapConnectionProxy(oracleConnection)).getDescriptor(string);
            if (arrayDescriptor == null) {
                SQLName sQLName = new SQLName(oracleTypeCOLLECTION.getSchemaName(), oracleTypeCOLLECTION.getSimpleName(), oracleTypeCOLLECTION.getConnection());
                arrayDescriptor = new ArrayDescriptor(sQLName, oracleTypeCOLLECTION, (Connection)oracleConnection);
                oracleConnection.putDescriptor(string, arrayDescriptor);
            }
            ArrayDescriptor arrayDescriptor2 = arrayDescriptor;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$4, null, arrayDescriptor2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$4, null, null);
            }
            return arrayDescriptor2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    public static ArrayDescriptor createDescriptor(SQLName sQLName, byte[] byArray, int n2, byte[] byArray2, OracleConnection oracleConnection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$5, null, sQLName, byArray, n2, byArray2, oracleConnection);
            }
            OracleTypeADT oracleTypeADT = new OracleTypeADT(sQLName, byArray, n2, byArray2, oracleConnection);
            oracleTypeADT.init(byArray2, oracleConnection);
            OracleTypeCOLLECTION oracleTypeCOLLECTION = (OracleTypeCOLLECTION)oracleTypeADT.cleanup();
            ArrayDescriptor arrayDescriptor = new ArrayDescriptor(sQLName, oracleTypeCOLLECTION, (Connection)oracleConnection);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$5, null, arrayDescriptor);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$5, null, null);
            }
            return arrayDescriptor;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    public ArrayDescriptor(String string, Connection connection) throws SQLException {
        this(string, connection, true);
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$48, null, string, connection);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$48, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$48, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$48, null, throwable2);
            }
            throw throwable;
        }
    }

    private ArrayDescriptor(String string, Connection connection, boolean bl) throws SQLException {
        super((short)122, string, connection);
        if (bl) {
            this.initPickler();
        }
    }

    public ArrayDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super((short)122, sQLName, connection);
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$50, null, sQLName, connection);
            }
            this.initPickler();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$50, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$50, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$50, null, throwable2);
            }
            throw throwable;
        }
    }

    public ArrayDescriptor(SQLName sQLName, OracleTypeCOLLECTION oracleTypeCOLLECTION, Connection connection) throws SQLException {
        super((short)122, sQLName, oracleTypeCOLLECTION, connection);
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$51, null, sQLName, oracleTypeCOLLECTION, connection);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$51, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$51, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$51, null, throwable2);
            }
            throw throwable;
        }
    }

    public ArrayDescriptor(OracleTypeCOLLECTION oracleTypeCOLLECTION, Connection connection) throws SQLException {
        super((short)122, oracleTypeCOLLECTION, connection);
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$52, null, oracleTypeCOLLECTION, connection);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$52, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$52, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$52, null, throwable2);
            }
            throw throwable;
        }
    }

    ArrayDescriptor(byte[] byArray, int n2, Connection connection) throws SQLException {
        super((short)122);
        this.toid = byArray;
        this.toidVersion = n2;
        this.setPhysicalConnectionOf(connection);
        this.initPickler();
    }

    @Override
    public OracleTypeMetaData.Kind getKind() {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$6, this, new Object[0]);
            }
            OracleTypeMetaData.Kind kind = OracleTypeMetaData.Kind.ARRAY;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$6, this, (Object)kind);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$6, this, null);
            }
            return kind;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getBaseType() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$7, this, new Object[0]);
            }
            int n2 = ((OracleTypeCOLLECTION)this.pickler).getElementType().getTypeCode();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$7, this, n2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$7, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getBaseName() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$8, this, new Object[0]);
            }
            String string = null;
            switch (this.getBaseType()) {
                case 12: {
                    string = "VARCHAR";
                    break;
                }
                case 1: {
                    string = "CHAR";
                    break;
                }
                case -9: {
                    string = "NVARCHAR";
                    break;
                }
                case -15: {
                    string = "NCHAR";
                    break;
                }
                case -2: {
                    string = "RAW";
                    break;
                }
                case 6: {
                    string = "FLOAT";
                    break;
                }
                case 2: {
                    string = "NUMBER";
                    break;
                }
                case 8: {
                    string = "DOUBLE";
                    break;
                }
                case 3: {
                    string = "DECIMAL";
                    break;
                }
                case 91: {
                    string = "DATE";
                    break;
                }
                case 93: {
                    string = "TIMESTAMP";
                    break;
                }
                case -101: {
                    string = "TIMESTAMP WITH TIME ZONE";
                    break;
                }
                case -102: {
                    string = "TIMESTAMP WITH LOCAL TIME ZONE";
                    break;
                }
                case 2004: {
                    string = "BLOB";
                    break;
                }
                case 2005: {
                    string = "CLOB";
                    break;
                }
                case 2011: {
                    string = "NCLOB";
                    break;
                }
                case -13: {
                    string = "BFILE";
                    break;
                }
                case 2002: 
                case 2003: 
                case 2007: 
                case 2008: {
                    OracleNamedType oracleNamedType = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                    string = oracleNamedType.getFullName();
                    break;
                }
                case 2006: {
                    OracleNamedType oracleNamedType = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                    string = "REF " + ((OracleTypeREF)oracleNamedType).getFullName();
                    break;
                }
                case 100: {
                    string = "BINARY_FLOAT";
                    break;
                }
                case 101: {
                    string = "BINARY_DOUBLE";
                    break;
                }
                case -104: {
                    string = "INTERVALDS";
                    break;
                }
                case -103: {
                    string = "INTERVALYM";
                    break;
                }
                default: {
                    string = null;
                }
            }
            String string2 = string;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$8, this, string2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$8, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    public OracleTypeCOLLECTION getOracleTypeCOLLECTION() {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$9, this, new Object[0]);
            }
            OracleTypeCOLLECTION oracleTypeCOLLECTION = (OracleTypeCOLLECTION)this.pickler;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$9, this, oracleTypeCOLLECTION);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$9, this, null);
            }
            return oracleTypeCOLLECTION;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OracleTypeMetaData.ArrayStorage getArrayStorage() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$10, this, new Object[0]);
            }
            OracleTypeMetaData.ArrayStorage arrayStorage = OracleTypeMetaData.ArrayStorage.withCode(this.getArrayType());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$10, this, (Object)arrayStorage);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$10, this, null);
            }
            return arrayStorage;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getArrayType() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$11, this, new Object[0]);
            }
            int n2 = ((OracleTypeCOLLECTION)this.pickler).getUserCode();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$11, this, n2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$11, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getMaxLength() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$12, this, new Object[0]);
            }
            long l3 = l2 = this.getArrayType() == 3 ? ((OracleTypeCOLLECTION)this.pickler).getMaxLength() : 0L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$12, this, l2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$12, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    public String descType() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$13, this, new Object[0]);
            }
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.descType(stringBuffer, 0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$13, this, string);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$13, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    String descType(StringBuffer stringBuffer, int n2) throws SQLException {
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + "  ";
        }
        String string2 = string + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("\n");
        int n3 = this.getBaseType();
        if (n3 == 2002 || n3 == 2008) {
            StructDescriptor structDescriptor = StructDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            structDescriptor.descType(stringBuffer, n2 + 1);
        } else if (n3 == 2003) {
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            arrayDescriptor.descType(stringBuffer, n2 + 1);
        } else if (n3 == 2007) {
            OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
            opaqueDescriptor.descType(stringBuffer, n2 + 1);
        } else {
            stringBuffer.append(string2);
            stringBuffer.append(this.getBaseName());
            stringBuffer.append("\n");
        }
        return stringBuffer.substring(0, stringBuffer.length());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int toLength(OracleArray oracleArray, Datum datum) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$15, this, oracleArray, datum);
            }
            if (oracleArray.getNumElems() == -1) {
                if (oracleArray.getDatumArray() != null) {
                    oracleArray.setLength(oracleArray.getDatumArray().length);
                } else if (oracleArray.getObjArray() != null) {
                    Object object = oracleArray.getObjArray();
                    int n2 = oracleArray.getNumElems();
                    if (object instanceof Object[]) {
                        n2 = ((Object[])object).length;
                    } else if (object instanceof int[]) {
                        n2 = ((long[])object).length;
                    } else if (object instanceof long[]) {
                        n2 = ((float[])object).length;
                    } else if (object instanceof float[]) {
                        n2 = ((double[])object).length;
                    } else if (object instanceof double[]) {
                        n2 = ((boolean[])object).length;
                    } else if (object instanceof boolean[]) {
                        n2 = ((int[])object).length;
                    } else if (object instanceof byte[]) {
                        n2 = ((byte[])object).length;
                    } else if (object instanceof short[]) {
                        n2 = ((short[])object).length;
                    } else if (object instanceof char[]) {
                        n2 = ((char[])object).length;
                    }
                    oracleArray.setLength(n2);
                } else if (oracleArray.getLocator() != null) {
                    oracleArray.setLength(this.toLengthFromLocator(oracleArray.getLocator()));
                } else if (oracleArray.shareBytes() != null) {
                    this.pickler.unlinearize(oracleArray.shareBytes(), oracleArray.getImageOffset(), datum, 0, null);
                    if (oracleArray.getNumElems() == -1) {
                        if (oracleArray.getLocator() != null) {
                            oracleArray.setLength(this.toLengthFromLocator(oracleArray.getLocator()));
                        } else {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to get array length").fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$15, this, sQLException);
                            }
                            throw sQLException;
                        }
                    }
                } else {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$15, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            int n3 = oracleArray.getNumElems();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$15, this, n3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$15, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] toBytes(OracleArray oracleArray, Datum datum, boolean bl) throws SQLException {
        boolean bl2 = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] byArray;
            block15: {
                block13: {
                    block14: {
                        if (bl2) {
                            ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$16, this, oracleArray, datum, bl);
                        }
                        if ((byArray = oracleArray.shareBytes()) != null) break block13;
                        if (oracleArray.getDatumArray() == null && oracleArray.getLocator() == null) break block14;
                        byArray = this.pickler.linearize(datum);
                        if (!bl) {
                            oracleArray.setShareBytes(null);
                        }
                        break block15;
                    }
                    if (oracleArray.getObjArray() != null) {
                        oracleArray.setDatumArray(this.toOracleArray(oracleArray.getObjArray(), 1L, -1));
                        byArray = this.pickler.linearize(datum);
                        if (!bl) {
                            oracleArray.setDatumArray(null);
                            oracleArray.setShareBytes(null);
                        }
                        break block15;
                    } else {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$16, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
                if (oracleArray.getImageLength() != 0L) {
                    long l2 = oracleArray.getImageLength();
                    if (oracleArray.getImageOffset() != 0L || l2 != (long)byArray.length) {
                        byte[] byArray2 = new byte[(int)l2];
                        System.arraycopy(byArray, (int)oracleArray.getImageOffset(), byArray2, 0, (int)l2);
                        oracleArray.setImage(byArray2, 0L, 0L);
                        byte[] byArray3 = byArray2;
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$16, this, byArray3);
                            ClioSupport.publicExit();
                            ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$16, this, null);
                        }
                        return byArray2;
                    }
                }
            }
            byte[] byArray4 = byArray;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$16, this, byArray4);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$16, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Datum[] toOracleArray(OracleArray oracleArray, Datum datum, long l2, int n2, boolean bl) throws SQLException {
        boolean bl2 = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            Datum[] datumArray;
            block15: {
                block13: {
                    block16: {
                        block14: {
                            if (bl2) {
                                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$17, this, oracleArray, datum, l2, n2, bl);
                            }
                            if ((datumArray = oracleArray.getDatumArray()) != null) break block13;
                            if (oracleArray.getObjArray() == null) break block14;
                            datumArray = this.toOracleArray(oracleArray.getObjArray(), l2, n2);
                            break block15;
                        }
                        if (oracleArray.getLocator() == null) break block16;
                        datumArray = this.toOracleArrayFromLocator(oracleArray.getLocator(), l2, n2, null);
                        break block15;
                    }
                    if (oracleArray.shareBytes() != null) {
                        this.pickler.unlinearize(oracleArray.shareBytes(), oracleArray.getImageOffset(), datum, l2, n2, 1, null);
                        datumArray = oracleArray.getLocator() != null ? this.toOracleArrayFromLocator(oracleArray.getLocator(), l2, n2, null) : oracleArray.getDatumArray();
                        if (!bl) {
                            oracleArray.setDatumArray(null);
                        }
                        break block15;
                    } else {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status.").fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$17, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
                if (l2 > (long)datumArray.length) {
                    Datum[] datumArray2 = new Datum[]{};
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$17, this, datumArray2);
                        ClioSupport.publicExit();
                        ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$17, this, null);
                    }
                    return datumArray2;
                }
                int n3 = (int)(n2 == -1 ? (long)datumArray.length - l2 + 1L : Math.min((long)datumArray.length - l2 + 1L, (long)n2));
                datumArray = new Datum[n3];
                System.arraycopy(oracleArray.getDatumArray(), (int)l2 - 1, datumArray, 0, n3);
            }
            Datum[] datumArray3 = null;
            if (bl) {
                oracleArray.setDatumArray(datumArray);
                datumArray3 = (Datum[])datumArray.clone();
            } else {
                datumArray3 = datumArray;
            }
            Datum[] datumArray4 = datumArray3;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$17, this, datumArray4);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$17, this, null);
            }
            return datumArray3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    public Object[] toJavaArray(OracleArray oracleArray, Datum datum, long l2, int n2, Map map, boolean bl) throws SQLException {
        boolean bl2 = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$18, this, oracleArray, datum, l2, n2, map, bl);
            }
            Object[] objectArray = null;
            if (oracleArray.getObjArray() != null) {
                objectArray = (Object[])((Object[])oracleArray.getObjArray()).clone();
                int n3 = objectArray.length;
                int n4 = (int)(n2 == -1 ? (long)n3 - l2 + 1L : Math.min((long)n3 - l2 + 1L, (long)n2));
                if (n4 <= 0) {
                    Object[] objectArray2;
                    Object[] objectArray3 = objectArray2 = ArrayDescriptor.makeJavaArray(n4, this.getBaseType());
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$18, this, objectArray3);
                        ClioSupport.publicExit();
                        ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$18, this, null);
                    }
                    return objectArray2;
                }
                objectArray = ArrayDescriptor.makeJavaArray(n4, this.getBaseType());
                System.arraycopy(oracleArray.getObjArray(), (int)l2 - 1, objectArray, 0, n4);
            } else {
                if (oracleArray.getDatumArray() != null) {
                    objectArray = (Object[])this.toJavaArray(oracleArray, l2, n2, map);
                } else if (oracleArray.getLocator() != null) {
                    objectArray = this.toArrayFromLocator(oracleArray.getLocator(), l2, n2, map);
                } else if (oracleArray.shareBytes() != null) {
                    this.pickler.unlinearize(oracleArray.shareBytes(), oracleArray.getImageOffset(), datum, l2, n2, 2, map);
                    objectArray = oracleArray.getLocator() != null ? this.toArrayFromLocator(oracleArray.getLocator(), l2, n2, map) : (Object[])oracleArray.getObjArray();
                } else {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$18, this, sQLException);
                    }
                    throw sQLException;
                }
                if (bl && this.getBaseType() != 2002 && this.getBaseType() != 2008 && objectArray != null) {
                    oracleArray.setObjArray(objectArray.clone());
                } else {
                    oracleArray.setNullObjArray();
                }
            }
            Object[] objectArray4 = objectArray;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$18, this, objectArray4);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$18, this, null);
            }
            return objectArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    private Datum[] toOracleArrayFromLocator(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        int n3 = this.toLengthFromLocator(byArray);
        int n4 = (int)(n2 == -1 ? (long)n3 - l2 + 1L : Math.min((long)n3 - l2 + 1L, (long)n2));
        Datum[] datumArray = null;
        if (n4 <= 0) {
            datumArray = new Datum[]{};
        } else {
            datumArray = new Datum[n4];
            ResultSet resultSet = this.toResultSetFromLocator(byArray, l2, n2, map);
            int n5 = 0;
            while (resultSet.next()) {
                datumArray[n5] = ((OracleResultSet)resultSet).getOracleObject(2);
                ++n5;
            }
            resultSet.close();
        }
        return datumArray;
    }

    private Object[] toArrayFromLocator(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        int n3 = this.toLengthFromLocator(byArray);
        int n4 = (int)(n2 == -1 ? (long)n3 - l2 + 1L : Math.min((long)n3 - l2 + 1L, (long)n2));
        Object[] objectArray = null;
        if (n4 <= 0) {
            objectArray = ArrayDescriptor.makeJavaArray(0, this.getBaseType());
        } else {
            objectArray = ArrayDescriptor.makeJavaArray(n4, this.getBaseType());
            ResultSet resultSet = this.toResultSetFromLocator(byArray, l2, n2, map);
            int n5 = 0;
            while (resultSet.next()) {
                objectArray[n5] = ((OracleResultSet)resultSet).getObject(2, map);
                ++n5;
            }
            resultSet.close();
        }
        return objectArray;
    }

    public ResultSet toResultSet(ARRAY aRRAY, long l2, int n2, Map map, boolean bl) throws SQLException {
        boolean bl2 = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$21, this, aRRAY, l2, n2, map, bl);
            }
            ResultSet resultSet = this.toResultSet(aRRAY, aRRAY, l2, n2, map, bl);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$21, this, resultSet);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$21, this, null);
            }
            return resultSet;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    public ResultSet toResultSet(OracleArray oracleArray, Datum datum, long l2, int n2, Map map, boolean bl) throws SQLException {
        boolean bl2 = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$22, this, oracleArray, datum, l2, n2, map, bl);
            }
            ResultSet resultSet = null;
            if (oracleArray.getDatumArray() != null) {
                resultSet = this.toResultSet(oracleArray.getDatumArray(), l2, n2, map);
            } else if (oracleArray.getLocator() != null) {
                resultSet = this.toResultSetFromLocator(oracleArray.getLocator(), l2, n2, map);
            } else if (oracleArray.getObjArray() != null) {
                resultSet = this.toResultSet(this.toOracleArray(oracleArray.getObjArray(), l2, n2), 1L, -1, map);
            } else if (oracleArray.shareBytes() != null) {
                if (((OracleTypeCOLLECTION)this.pickler).isInlineImage(oracleArray.shareBytes(), (int)oracleArray.getImageOffset())) {
                    resultSet = this.toResultSetFromImage(oracleArray, l2, n2, map);
                } else {
                    this.pickler.unlinearize(oracleArray.shareBytes(), oracleArray.getImageOffset(), datum, 1, null);
                    if (oracleArray.getLocator() != null) {
                        resultSet = this.toResultSetFromLocator(oracleArray.getLocator(), l2, n2, map);
                    } else {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$22, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
            }
            if (resultSet == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to create array ResultSet").fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$22, this, sQLException);
                }
                throw sQLException;
            }
            ResultSet resultSet2 = resultSet;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$22, this, resultSet2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$22, this, null);
            }
            return resultSet2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    public ResultSet toResultSet(Datum[] datumArray, long l2, int n2, Map map) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$23, this, datumArray, l2, n2, map);
            }
            ResultSet resultSet = null;
            resultSet = n2 == -1 ? this.connection.newArrayDataResultSet(datumArray, l2, datumArray.length, map) : this.connection.newArrayDataResultSet(datumArray, l2, n2, map);
            ResultSet resultSet2 = resultSet;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$23, this, resultSet2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$23, this, null);
            }
            return resultSet2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    public ResultSet toResultSetFromLocator(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            ResultSet resultSet;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$24, this, byArray, l2, n2, map);
            }
            ResultSet resultSet2 = resultSet = this.connection.newArrayLocatorResultSet(this, byArray, l2, n2, map);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$24, this, resultSet2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$24, this, null);
            }
            return resultSet2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    public ResultSet toResultSetFromImage(OracleArray oracleArray, long l2, int n2, Map map) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            ResultSet resultSet;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$25, this, oracleArray, l2, n2, map);
            }
            ResultSet resultSet2 = resultSet = this.connection.newArrayDataResultSet(oracleArray, l2, n2, map);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$25, this, resultSet2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$25, this, null);
            }
            return resultSet2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    public static Object[] makeJavaArray(int n2, int n3) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$26, null, n2, n3);
            }
            Object[] objectArray = null;
            switch (n3) {
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = new BigDecimal[n2];
                    break;
                }
                case -15: 
                case -9: 
                case 1: 
                case 12: {
                    objectArray = new String[n2];
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    objectArray = new Timestamp[n2];
                    break;
                }
                case -102: 
                case -101: {
                    objectArray = new OffsetDateTime[n2];
                    break;
                }
                case 2002: 
                case 2008: {
                    objectArray = new Object[n2];
                    break;
                }
                case -13: {
                    objectArray = new BFILE[n2];
                    break;
                }
                case 2004: {
                    objectArray = new BLOB[n2];
                    break;
                }
                case 2005: 
                case 2011: {
                    objectArray = new CLOB[n2];
                    break;
                }
                case -3: 
                case -2: {
                    objectArray = (Object[])new byte[n2][];
                    break;
                }
                case 2006: {
                    objectArray = new REF[n2];
                    break;
                }
                case 2003: {
                    objectArray = new Object[n2];
                    break;
                }
                case 2007: {
                    objectArray = new Object[n2];
                    break;
                }
                case 100: {
                    objectArray = new Float[n2];
                    break;
                }
                case 101: {
                    objectArray = new Double[n2];
                    break;
                }
                case -104: {
                    objectArray = new INTERVALDS[n2];
                    break;
                }
                case -103: {
                    objectArray = new INTERVALYM[n2];
                    break;
                }
                case -8: {
                    objectArray = new ROWID[n2];
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(1, "makeJavaArray doesn't support type " + n3).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$26, null, sQLException);
                    }
                    throw sQLException;
                }
            }
            Object[] objectArray2 = objectArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$26, null, objectArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$26, null, null);
            }
            return objectArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$26, null, throwable2);
            }
            throw throwable;
        }
    }

    private int toLengthFromLocator(byte[] byArray) throws SQLException {
        ARRAY aRRAY = new ARRAY(this, this.connection, (Object)null);
        aRRAY.setLocator(byArray);
        int n2 = 0;
        OraclePreparedStatement oraclePreparedStatement = null;
        OracleResultSet oracleResultSet = null;
        oraclePreparedStatement = (OraclePreparedStatement)this.connection.prepareStatement("SELECT count(*) FROM TABLE( CAST(:1 AS " + this.getName() + ") )");
        oraclePreparedStatement.setArray(1, aRRAY);
        oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
        if (!oracleResultSet.next()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Fail to access array storage table").fillInStackTrace();
        }
        n2 = oracleResultSet.getInt(1);
        oracleResultSet.close();
        oraclePreparedStatement.close();
        return n2;
    }

    public Datum[] toOracleArray(Object object, long l2, int n2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$28, this, object, l2, n2);
            }
            Datum[] datumArray = null;
            if (object != null) {
                OracleType oracleType = this.getElementType();
                if (this.getArrayType() == 1) {
                    if (object.getClass().isArray()) {
                        int n3 = Array.getLength(object);
                        Datum[] datumArray2 = new Datum[n3];
                        for (int i2 = 0; i2 < n3; ++i2) {
                            Object object2 = Array.get(object, i2);
                            Datum datum = oracleType.toDatum(object2, this.connection);
                            datumArray2[i2] = new AssociativeArrayEntry<Integer, Datum>(i2, datum);
                        }
                        datumArray = datumArray2;
                    } else if (object instanceof Map) {
                        Map map = (Map)object;
                        Datum[] datumArray3 = new Datum[map.size()];
                        int n4 = 0;
                        for (Map.Entry entry : map.entrySet()) {
                            if (!(entry.getKey() instanceof Integer)) {
                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "SQL Associative Array Index Type").fillInStackTrace();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$28, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$28, this, sQLException);
                                }
                                throw sQLException;
                            }
                            Datum datum = oracleType.toDatum(entry.getValue(), this.connection);
                            datumArray3[n4] = new AssociativeArrayEntry(entry.getKey(), datum);
                            ++n4;
                        }
                        datumArray = datumArray3;
                    }
                } else {
                    datumArray = oracleType.toDatumArray(object, this.connection, l2, n2);
                }
            }
            Datum[] datumArray4 = datumArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$28, this, datumArray4);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$28, this, null);
            }
            return datumArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    private Object toJavaArray(OracleArray oracleArray, long l2, int n2, Map map) throws SQLException {
        HashMap<Integer, Object> hashMap = null;
        if (this.getArrayType() == 1) {
            hashMap = new HashMap<Integer, Object>();
        }
        Datum[] datumArray = oracleArray.getDatumArray();
        int n3 = (int)(n2 == -1 ? (long)datumArray.length - l2 + 1L : Math.min((long)datumArray.length - l2 + 1L, (long)n2));
        if (n3 < 0) {
            n3 = 0;
        }
        Object[] objectArray = ArrayDescriptor.makeJavaArray(n3, this.getBaseType());
        for (int i2 = 0; i2 < n3; ++i2) {
            Integer n4 = null;
            Datum datum = datumArray[(int)l2 + i2 - 1];
            if (datum instanceof AssociativeArrayEntry) {
                n4 = (Integer)((AssociativeArrayEntry)datum).getKey();
                datum = (Datum)((AssociativeArrayEntry)datum).getValue();
            }
            if (this.getBaseType() == 2002) {
                objectArray[i2] = datum != null ? ((STRUCT)datum).toJdbc(map) : null;
            } else if (this.getBaseType() == -101) {
                objectArray[i2] = datum != null ? ((TIMESTAMPTZ)datum).offsetDateTimeValue(oracleArray.getJavaSqlConnection()) : null;
            } else if (this.getBaseType() == -102) {
                objectArray[i2] = datum != null ? ((TIMESTAMPLTZ)datum).offsetDateTimeValue(oracleArray.getJavaSqlConnection()) : null;
            } else {
                Object object = objectArray[i2] = datum != null ? datum.toJdbc() : null;
            }
            if (hashMap == null) continue;
            hashMap.put(n4, objectArray[i2]);
        }
        oracleArray.setJavaMap(hashMap);
        return objectArray;
    }

    private Object toNumericArray(Datum[] datumArray, long l2, int n2, int n3) throws SQLException {
        Object[] objectArray = null;
        int n4 = (int)(n2 == -1 ? (long)datumArray.length - l2 + 1L : Math.min((long)datumArray.length - l2 + 1L, (long)n2));
        if (n4 < 0) {
            n4 = 0;
        }
        switch (n3) {
            case 4: {
                int[] nArray = new int[n4];
                for (int i2 = 0; i2 < n4; ++i2) {
                    Datum datum = datumArray[(int)l2 + i2 - 1];
                    if (datum == null) continue;
                    nArray[i2] = datum.intValue();
                }
                objectArray = nArray;
                break;
            }
            case 5: {
                double[] dArray = new double[n4];
                for (int i3 = 0; i3 < n4; ++i3) {
                    Datum datum = datumArray[(int)l2 + i3 - 1];
                    if (datum == null) continue;
                    dArray[i3] = datum.doubleValue();
                }
                objectArray = dArray;
                break;
            }
            case 6: {
                float[] fArray = new float[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    Datum datum = datumArray[(int)l2 + i4 - 1];
                    if (datum == null) continue;
                    fArray[i4] = datum.floatValue();
                }
                objectArray = fArray;
                break;
            }
            case 7: {
                long[] lArray = new long[n4];
                for (int i5 = 0; i5 < n4; ++i5) {
                    Datum datum = datumArray[(int)l2 + i5 - 1];
                    if (datum == null) continue;
                    lArray[i5] = datum.longValue();
                }
                objectArray = lArray;
                break;
            }
            case 8: {
                short[] sArray = new short[n4];
                for (int i6 = 0; i6 < n4; ++i6) {
                    Datum datum = datumArray[(int)l2 + i6 - 1];
                    if (datum == null) continue;
                    sArray[i6] = ((NUMBER)datum).shortValue();
                }
                objectArray = sArray;
                break;
            }
            default: {
                SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLFeatureNotSupportedException.fillInStackTrace();
                throw sQLFeatureNotSupportedException;
            }
        }
        return objectArray;
    }

    private Object toNumericArrayFromLocator(byte[] byArray, long l2, int n2, int n3) throws SQLException {
        Object[] objectArray = null;
        int n4 = this.toLengthFromLocator(byArray);
        ResultSet resultSet = this.toResultSetFromLocator(byArray, l2, n2, null);
        int n5 = 0;
        switch (n3) {
            case 4: {
                int[] nArray = new int[n4];
                while (resultSet.next() && n5 < n4) {
                    nArray[n5++] = ((OracleResultSet)resultSet).getInt(2);
                }
                resultSet.close();
                objectArray = nArray;
                break;
            }
            case 5: {
                double[] dArray = new double[n4];
                while (resultSet.next() && n5 < n4) {
                    dArray[n5++] = ((OracleResultSet)resultSet).getDouble(2);
                }
                resultSet.close();
                objectArray = dArray;
                break;
            }
            case 6: {
                float[] fArray = new float[n4];
                while (resultSet.next() && n5 < n4) {
                    fArray[n5++] = ((OracleResultSet)resultSet).getFloat(2);
                }
                resultSet.close();
                objectArray = fArray;
                break;
            }
            case 7: {
                long[] lArray = new long[n4];
                while (resultSet.next() && n5 < n4) {
                    lArray[n5++] = ((OracleResultSet)resultSet).getLong(2);
                }
                resultSet.close();
                objectArray = lArray;
                break;
            }
            case 8: {
                short[] sArray = new short[n4];
                while (resultSet.next() && n5 < n4) {
                    sArray[n5++] = ((OracleResultSet)resultSet).getShort(2);
                }
                resultSet.close();
                objectArray = sArray;
                break;
            }
            default: {
                SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLFeatureNotSupportedException.fillInStackTrace();
                throw sQLFeatureNotSupportedException;
            }
        }
        return objectArray;
    }

    public Object toNumericArray(OracleArray oracleArray, Datum datum, long l2, int n2, int n3, boolean bl) throws SQLException {
        boolean bl2 = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleType oracleType;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, oracleArray, datum, l2, n2, n3, bl);
            }
            if (!((oracleType = this.getElementType()) instanceof OracleTypeNUMBER) && !(oracleType instanceof OracleTypeFLOAT)) {
                SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
                sQLFeatureNotSupportedException.fillInStackTrace();
                SQLFeatureNotSupportedException sQLFeatureNotSupportedException2 = sQLFeatureNotSupportedException;
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, sQLFeatureNotSupportedException2);
                }
                throw sQLFeatureNotSupportedException2;
            }
            Object object = null;
            if (oracleArray.getObjArray() != null) {
                Object object2 = oracleArray.getObjArray();
                if (n3 == 4 && object2 instanceof int[]) {
                    int n4 = ((int[])object2).length;
                    if (l2 > (long)n4) {
                        int[] nArray = new int[]{};
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, nArray);
                            ClioSupport.publicExit();
                            ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, null);
                        }
                        return nArray;
                    }
                    n4 = (int)(n2 == -1 ? (long)n4 - l2 + 1L : Math.min((long)n4 - l2 + 1L, (long)n2));
                    int[] nArray = new int[n4];
                    System.arraycopy(object2, (int)l2 - 1, nArray, 0, n4);
                    object = nArray;
                } else if (n3 == 5 && object2 instanceof double[]) {
                    int n5 = ((double[])object2).length;
                    if (l2 > (long)n5) {
                        double[] dArray = new double[]{};
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, dArray);
                            ClioSupport.publicExit();
                            ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, null);
                        }
                        return dArray;
                    }
                    n5 = (int)(n2 == -1 ? (long)n5 - l2 + 1L : Math.min((long)n5 - l2 + 1L, (long)n2));
                    double[] dArray = new double[n5];
                    System.arraycopy(object2, (int)l2 - 1, dArray, 0, n5);
                    object = dArray;
                } else if (n3 == 6 && object2 instanceof float[]) {
                    int n6 = ((float[])object2).length;
                    if (l2 > (long)n6) {
                        float[] fArray = new float[]{};
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, fArray);
                            ClioSupport.publicExit();
                            ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, null);
                        }
                        return fArray;
                    }
                    n6 = (int)(n2 == -1 ? (long)n6 - l2 + 1L : Math.min((long)n6 - l2 + 1L, (long)n2));
                    float[] fArray = new float[n6];
                    System.arraycopy(object2, (int)l2 - 1, fArray, 0, n6);
                    object = fArray;
                } else if (n3 == 7 && object2 instanceof long[]) {
                    int n7 = ((long[])object2).length;
                    if (l2 > (long)n7) {
                        long[] lArray = new long[]{};
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, lArray);
                            ClioSupport.publicExit();
                            ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, null);
                        }
                        return lArray;
                    }
                    n7 = (int)(n2 == -1 ? (long)n7 - l2 + 1L : Math.min((long)n7 - l2 + 1L, (long)n2));
                    long[] lArray = new long[n7];
                    System.arraycopy(object2, (int)l2 - 1, lArray, 0, n7);
                    object = lArray;
                } else if (n3 == 8 && object2 instanceof short[]) {
                    int n8 = ((short[])object2).length;
                    if (l2 > (long)n8) {
                        short[] sArray = new short[]{};
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, sArray);
                            ClioSupport.publicExit();
                            ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, null);
                        }
                        return sArray;
                    }
                    n8 = (int)(n2 == -1 ? (long)n8 - l2 + 1L : Math.min((long)n8 - l2 + 1L, (long)n2));
                    short[] sArray = new short[n8];
                    System.arraycopy(object2, (int)l2 - 1, sArray, 0, n8);
                    object = sArray;
                }
            } else {
                if (oracleArray.getDatumArray() != null) {
                    object = this.toNumericArray(oracleArray.getDatumArray(), l2, n2, n3);
                } else if (oracleArray.getLocator() != null) {
                    object = this.toNumericArrayFromLocator(oracleArray.getLocator(), l2, n2, n3);
                } else if (oracleArray.shareBytes() != null) {
                    this.pickler.unlinearize(oracleArray.shareBytes(), oracleArray.getImageOffset(), datum, l2, n2, n3, null);
                    object = oracleArray.getLocator() != null ? this.toNumericArrayFromLocator(oracleArray.getLocator(), l2, n2, n3) : oracleArray.getObjArray();
                } else {
                    SQLFeatureNotSupportedException sQLFeatureNotSupportedException = DatabaseError.createUnsupportedFeatureSqlException();
                    sQLFeatureNotSupportedException.fillInStackTrace();
                    SQLFeatureNotSupportedException sQLFeatureNotSupportedException3 = sQLFeatureNotSupportedException;
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, sQLFeatureNotSupportedException3);
                    }
                    throw sQLFeatureNotSupportedException3;
                }
                if (!bl) {
                    oracleArray.setNullObjArray();
                }
            }
            Object object3 = object;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, object3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, null);
            }
            return object3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    private void initPickler() throws SQLException {
        try {
            String string = this.typeNameByUser;
            if (string == null) {
                string = this.getName();
            }
            OracleTypeADT oracleTypeADT = new OracleTypeADT(string, (Connection)this.connection);
            oracleTypeADT.init(this.connection);
            this.pickler = (OracleTypeCOLLECTION)oracleTypeADT.cleanup();
            this.toid = ((OracleTypeADT)this.pickler).getTOID();
            this.pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type: \"" + this.getName() + "\"").fillInStackTrace();
        }
    }

    private OracleType getElementType() throws SQLException {
        OracleType oracleType = ((OracleTypeCOLLECTION)this.pickler).getElementType();
        return oracleType;
    }

    @Override
    public int getTypeCode() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$35, this, new Object[0]);
            }
            int n3 = n2 = 2003;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$35, this, n3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$35, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    public SQLInput toJdbcToSQLInput(ARRAY aRRAY, Map map) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$36, this, aRRAY, map);
            }
            OracleJdbc2SQLInput oracleJdbc2SQLInput = new OracleJdbc2SQLInput(this.toOracleArray(aRRAY, aRRAY, 0L, aRRAY.length(), false), map, this.connection);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$36, this, oracleJdbc2SQLInput);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$36, this, null);
            }
            return oracleJdbc2SQLInput;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$37, this, new Object[]{datumArray});
            }
            ARRAY aRRAY = new ARRAY(this, this.connection, datumArray);
            byte[] byArray = this.pickler.linearize(aRRAY);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$37, this, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$37, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] byArray;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$38, this, new Object[]{objectArray});
            }
            Datum[] datumArray = this.toArray(objectArray);
            byte[] byArray2 = byArray = this.toBytes(datumArray);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$38, this, byArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$38, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    public int length(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$39, this, new Object[]{byArray});
            }
            ARRAY aRRAY = new ARRAY(this, this.connection, byArray);
            int n3 = n2 = this.toLength(aRRAY, aRRAY);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$39, this, n3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$39, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$40, this, new Object[]{byArray});
            }
            Datum[] datumArray = null;
            if (byArray != null) {
                ARRAY aRRAY = new ARRAY(this, this.connection, byArray);
                datumArray = this.toOracleArray(aRRAY, aRRAY, 1L, -1, false);
            }
            Datum[] datumArray2 = datumArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$40, this, datumArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$40, this, null);
            }
            return datumArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    public Datum[] toArray(Object object) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            Datum[] datumArray;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$41, this, object);
            }
            Datum[] datumArray2 = datumArray = this.toOracleArray(object, 1L, -1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$41, this, datumArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$41, this, null);
            }
            return datumArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    public ResultSet toResultSet(byte[] byArray, Map map) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$42, this, byArray, map);
            }
            ResultSet resultSet = null;
            if (byArray != null) {
                ARRAY aRRAY = (ARRAY)this.pickler.unlinearize(byArray, 0L, null, 1, null);
                resultSet = this.toResultSet(aRRAY, aRRAY, 1L, -1, map, false);
            }
            ResultSet resultSet2 = resultSet;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$42, this, resultSet2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$42, this, null);
            }
            return resultSet2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    public ResultSet toResultSet(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$43, this, byArray, l2, n2, map);
            }
            ResultSet resultSet = null;
            if (byArray != null) {
                ARRAY aRRAY = (ARRAY)this.pickler.unlinearize(byArray, 0L, null, 1, null);
                resultSet = this.toResultSet(aRRAY, aRRAY, l2, n2, map, false);
            }
            ResultSet resultSet2 = resultSet;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$43, this, resultSet2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$43, this, null);
            }
            return resultSet2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$43, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    String tagName() {
        return "ArrayDescriptor";
    }

    public static int getCacheStyle(OracleArray oracleArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$45, null, oracleArray);
            }
            int n2 = 2;
            if (oracleArray.getAutoIndexing() && (oracleArray.getAccessDirection() == 2 || oracleArray.getAccessDirection() == 3)) {
                n2 = 1;
            }
            int n3 = n2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$45, null, n3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$45, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$45, null, throwable2);
            }
            throw throwable;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    static {
        try {
            $$$methodRef$$$53 = ArrayDescriptor.class.getDeclaredConstructor(byte[].class, Integer.TYPE, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$52 = ArrayDescriptor.class.getDeclaredConstructor(OracleTypeCOLLECTION.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$51 = ArrayDescriptor.class.getDeclaredConstructor(SQLName.class, OracleTypeCOLLECTION.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$50 = ArrayDescriptor.class.getDeclaredConstructor(SQLName.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$49 = ArrayDescriptor.class.getDeclaredConstructor(String.class, Connection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$48 = ArrayDescriptor.class.getDeclaredConstructor(String.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$47 = ArrayDescriptor.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$46 = ArrayDescriptor.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$45 = ArrayDescriptor.class.getDeclaredMethod("getCacheStyle", OracleArray.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$44 = ArrayDescriptor.class.getDeclaredMethod("tagName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$43 = ArrayDescriptor.class.getDeclaredMethod("toResultSet", byte[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$42 = ArrayDescriptor.class.getDeclaredMethod("toResultSet", byte[].class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$41 = ArrayDescriptor.class.getDeclaredMethod("toArray", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$40 = ArrayDescriptor.class.getDeclaredMethod("toArray", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$39 = ArrayDescriptor.class.getDeclaredMethod("length", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$38 = ArrayDescriptor.class.getDeclaredMethod("toBytes", Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$37 = ArrayDescriptor.class.getDeclaredMethod("toBytes", Datum[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$36 = ArrayDescriptor.class.getDeclaredMethod("toJdbcToSQLInput", ARRAY.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$35 = ArrayDescriptor.class.getDeclaredMethod("getTypeCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$34 = ArrayDescriptor.class.getDeclaredMethod("getElementType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$33 = ArrayDescriptor.class.getDeclaredMethod("initPickler", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$32 = ArrayDescriptor.class.getDeclaredMethod("toNumericArray", OracleArray.class, Datum.class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$31 = ArrayDescriptor.class.getDeclaredMethod("toNumericArrayFromLocator", byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$30 = ArrayDescriptor.class.getDeclaredMethod("toNumericArray", Datum[].class, Long.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$29 = ArrayDescriptor.class.getDeclaredMethod("toJavaArray", OracleArray.class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$28 = ArrayDescriptor.class.getDeclaredMethod("toOracleArray", Object.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$27 = ArrayDescriptor.class.getDeclaredMethod("toLengthFromLocator", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$26 = ArrayDescriptor.class.getDeclaredMethod("makeJavaArray", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$25 = ArrayDescriptor.class.getDeclaredMethod("toResultSetFromImage", OracleArray.class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$24 = ArrayDescriptor.class.getDeclaredMethod("toResultSetFromLocator", byte[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$23 = ArrayDescriptor.class.getDeclaredMethod("toResultSet", Datum[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$22 = ArrayDescriptor.class.getDeclaredMethod("toResultSet", OracleArray.class, Datum.class, Long.TYPE, Integer.TYPE, Map.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$21 = ArrayDescriptor.class.getDeclaredMethod("toResultSet", ARRAY.class, Long.TYPE, Integer.TYPE, Map.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$20 = ArrayDescriptor.class.getDeclaredMethod("toArrayFromLocator", byte[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$19 = ArrayDescriptor.class.getDeclaredMethod("toOracleArrayFromLocator", byte[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$18 = ArrayDescriptor.class.getDeclaredMethod("toJavaArray", OracleArray.class, Datum.class, Long.TYPE, Integer.TYPE, Map.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$17 = ArrayDescriptor.class.getDeclaredMethod("toOracleArray", OracleArray.class, Datum.class, Long.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$16 = ArrayDescriptor.class.getDeclaredMethod("toBytes", OracleArray.class, Datum.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$15 = ArrayDescriptor.class.getDeclaredMethod("toLength", OracleArray.class, Datum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = ArrayDescriptor.class.getDeclaredMethod("descType", StringBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = ArrayDescriptor.class.getDeclaredMethod("descType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = ArrayDescriptor.class.getDeclaredMethod("getMaxLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = ArrayDescriptor.class.getDeclaredMethod("getArrayType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = ArrayDescriptor.class.getDeclaredMethod("getArrayStorage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = ArrayDescriptor.class.getDeclaredMethod("getOracleTypeCOLLECTION", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = ArrayDescriptor.class.getDeclaredMethod("getBaseName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = ArrayDescriptor.class.getDeclaredMethod("getBaseType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = ArrayDescriptor.class.getDeclaredMethod("getKind", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", SQLName.class, byte[].class, Integer.TYPE, byte[].class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", OracleTypeCOLLECTION.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", SQLName.class, Connection.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", SQLName.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", String.class, Connection.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", String.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

