/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.junit;

import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.junit.JUnitFeature;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.RuntimeReflection;
import org.junit.runners.model.TestClass;

@TargetClass(className="org.junit.runners.model.TestClass", onlyWith={JUnitFeature.IsEnabled.class})
public final class Target_org_junit_runners_model_TestClass {
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=OnlyConstructorComputer.class)
    Constructor<?> onlyConstructor;

    @Substitute
    public Constructor<?> getOnlyConstructor() {
        return this.onlyConstructor;
    }

    public static final class OnlyConstructorComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            TestClass clazz = (TestClass)receiver;
            if (clazz.getJavaClass() != null) {
                Constructor constructor = clazz.getOnlyConstructor();
                RuntimeReflection.register((Executable[])new Executable[]{constructor});
                return constructor;
            }
            return null;
        }
    }
}

