/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.thirdparty;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import java.util.function.BooleanSupplier;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.RuntimeReflection;

@AutomaticFeature
public final class ICU4JFeature
implements Feature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return access.findClassByName("com.ibm.icu.impl.ClassLoaderUtil") != null;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        ICU4JFeature.registerShimClass(access, "com.ibm.icu.text.NumberFormatServiceShim");
        ICU4JFeature.registerShimClass(access, "com.ibm.icu.text.CollatorServiceShim");
    }

    private static void registerShimClass(Feature.BeforeAnalysisAccess access, String shimClassName) {
        Class shimClass = access.findClassByName(shimClassName);
        if (shimClass == null) {
            throw VMError.shouldNotReachHere((String)(shimClassName + " not found"));
        }
        RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{shimClass});
    }

    static class Helper {
        static final ClassLoader DUMMY_LOADER = new ClassLoader(null){};

        Helper() {
        }
    }

    static final class IsEnabled
    implements BooleanSupplier {
        IsEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(ICU4JFeature.class);
        }
    }
}

