/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.coherence;

import com.oracle.tools.runtime.ApplicationConsole;
import com.oracle.tools.runtime.LifecycleEventInterceptor;
import com.oracle.tools.runtime.java.AbstractJavaApplication;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

public class ClusterMember
extends AbstractJavaApplication<ClusterMember> {
    public static final String MBEAN_NAME_CLUSTER = "Coherence:type=Cluster";
    public static final String MBEAN_ATTRIBUTE_CLUSTER_SIZE = "ClusterSize";
    public static final String MBEAN_ATTRIBUTE_LOCAL_MEMBER_ID = "LocalMemberId";
    public static final String MBEAN_ATTRIBUTE_ROLE_NAME = "RoleName";
    public static final String MBEAN_ATTRIBUTE_SITE_NAME = "SiteName";

    ClusterMember(Process process, String name, ApplicationConsole console, Properties environmentVariables, Properties systemProperties, long defaultTimeout, TimeUnit defaultTimeoutUnits, Iterable<LifecycleEventInterceptor<ClusterMember>> interceptors) {
        super(process, name, console, environmentVariables, systemProperties, defaultTimeout, defaultTimeoutUnits, interceptors);
    }

    public MBeanInfo getClusterMBeanInfo() {
        try {
            return this.getMBeanInfo(new ObjectName(MBEAN_NAME_CLUSTER));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Could not retrieve the Coherence Cluster MBean", e);
        }
    }

    public int getClusterSize() {
        try {
            return (Integer)this.getMBeanAttribute(new ObjectName(MBEAN_NAME_CLUSTER), MBEAN_ATTRIBUTE_CLUSTER_SIZE, Integer.class);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Could not retrieve the Coherence Cluster MBean Attribute", e);
        }
    }

    public int getLocalMemberId() {
        try {
            return (Integer)this.getMBeanAttribute(new ObjectName(MBEAN_NAME_CLUSTER), MBEAN_ATTRIBUTE_LOCAL_MEMBER_ID, Integer.class);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Could not retrieve the Coherence Cluster MBean Attribute", e);
        }
    }

    public MBeanInfo getServiceMBeanInfo(String serviceName, int nodeId) {
        try {
            return this.getMBeanInfo(new ObjectName(String.format("Coherence:type=Service,name=%s,nodeId=%d", serviceName, nodeId)));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.format("Could not retrieve the Coherence Service MBean [%s]", serviceName), e);
        }
    }

    public String getRoleName() {
        try {
            return (String)this.getMBeanAttribute(new ObjectName(String.format("Coherence:type=Node,nodeId=%d", this.getLocalMemberId())), MBEAN_ATTRIBUTE_ROLE_NAME, String.class);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Could not retrieve the Coherence Cluster Node MBean", e);
        }
    }

    public String getSiteName() {
        try {
            return (String)this.getMBeanAttribute(new ObjectName(String.format("Coherence:type=Node,nodeId=%d", this.getLocalMemberId())), MBEAN_ATTRIBUTE_SITE_NAME, String.class);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Could not retrieve the Coherence Cluster Node MBean", e);
        }
    }
}

