package com.oracle.truffle.api.interop.java;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;

/**
 * This message resolution is generated by {@link com.oracle.truffle.api.interop.java.JavaObjectMessageResolution.ArrayHasSizeNode}
 * It is used by the foreign access factory {@link com.oracle.truffle.api.interop.java.JavaObjectMessageResolutionForeign}
 */
abstract class ArrayHasSizeNodeSub extends com.oracle.truffle.api.interop.java.JavaObjectMessageResolution.ArrayHasSizeNode {
    public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
    @Specialization
    protected Object accessWithTarget(com.oracle.truffle.api.interop.java.JavaObject receiver) {
        return access(receiver);
    }
    private static final class HAS_SIZERootNode extends RootNode {
        protected HAS_SIZERootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Child private ArrayHasSizeNodeSub node = com.oracle.truffle.api.interop.java.ArrayHasSizeNodeSubNodeGen.create();
        @Override
        public Object execute(VirtualFrame frame) {
            Object receiver = ForeignAccess.getReceiver(frame);
            try {
                return node.executeWithTarget(frame, receiver);
            } catch (UnsupportedSpecializationException e) {
                throw UnsupportedTypeException.raise(e.getSuppliedValues());
            }
        }

    }
    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new HAS_SIZERootNode(language);
    }
}
