package com.oracle.truffle.api.interop.java;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import java.util.List;

/**
 * This message resolution is generated by {@link com.oracle.truffle.api.interop.java.JavaObjectMessageResolution.InvokeNode}
 * It is used by the foreign access factory {@link com.oracle.truffle.api.interop.java.JavaObjectMessageResolutionForeign}
 */
abstract class InvokeNodeSub extends com.oracle.truffle.api.interop.java.JavaObjectMessageResolution.InvokeNode {
    public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1, Object o2);
    @Specialization
    protected Object accessWithTarget(com.oracle.truffle.api.frame.VirtualFrame frame, com.oracle.truffle.api.interop.java.JavaObject object, java.lang.String name, java.lang.Object[] args) {
        return access(frame, object, name, args);
    }
    private static final class INVOKERootNode extends RootNode {
        protected INVOKERootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Child private InvokeNodeSub node = com.oracle.truffle.api.interop.java.InvokeNodeSubNodeGen.create();
        @Override
        public Object execute(VirtualFrame frame) {
            try {
              Object receiver = ForeignAccess.getReceiver(frame);
              List<Object> arguments = ForeignAccess.getArguments(frame);
              Object identifier = arguments.get(0);
              Object[] args = new Object[arguments.size() - 1];
              for (int i = 0; i < arguments.size() - 1; i++) {
                args[i] = arguments.get(i + 1);
              }
              return node.executeWithTarget(frame, receiver, identifier, args);
            } catch (UnsupportedSpecializationException e) {
                throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
            }
        }

    }
    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new INVOKERootNode(language);
    }
}
