package com.oracle.truffle.api.interop.java;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;

/**
 * This message resolution is generated by {@link com.oracle.truffle.api.interop.java.JavaObjectMessageResolution.ReadFieldNode}
 * It is used by the foreign access factory {@link com.oracle.truffle.api.interop.java.JavaObjectMessageResolutionForeign}
 */
abstract class ReadFieldNodeSub extends com.oracle.truffle.api.interop.java.JavaObjectMessageResolution.ReadFieldNode {
    public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
    @Specialization
    protected Object accessWithTarget(com.oracle.truffle.api.interop.java.JavaObject object, int index) {
        return access(object, index);
    }
    @Specialization
    protected Object accessWithTarget(com.oracle.truffle.api.interop.java.JavaObject object, java.lang.String name) {
        return access(object, name);
    }
    private static final class ReadRootNode extends RootNode {
        protected ReadRootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Child private ReadFieldNodeSub node = com.oracle.truffle.api.interop.java.ReadFieldNodeSubNodeGen.create();
        @Override
        public Object execute(VirtualFrame frame) {
            Object receiver = ForeignAccess.getReceiver(frame);
            Object identifier = ForeignAccess.getArguments(frame).get(0);
            try {
                return node.executeWithTarget(frame, receiver, identifier);
            } catch (UnsupportedSpecializationException e) {
                throw UnsupportedTypeException.raise(e.getSuppliedValues());
            }
        }

    }
    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new ReadRootNode(language);
    }
}
