/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;

/**
 * Represents a source section load event from a {@link LoadSourceSectionListener}.
 *
 * Instances of {@link LoadSourceSectionEvent} should be neither stored, cached nor hashed. The
 * equality and hashing behavior is undefined.
 *
 * @see LoadSourceSectionListener
 * @since 0.15
 */
public final class LoadSourceSectionEvent {

    private final SourceSection sourceSection;
    private final Node node;

    LoadSourceSectionEvent(SourceSection sourceSection, Node node) {
        this.sourceSection = sourceSection;
        this.node = node;
    }

    /**
     * Returns the loaded source section that caused this event.
     *
     * @since 0.15
     */
    public SourceSection getSourceSection() {
        return sourceSection;
    }

    /**
     * Returns the instrumentable Truffle node that caused this event.
     *
     * @since 0.15
     */
    public Node getNode() {
        return node;
    }

}
