// CheckStyle: start generated
/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;

@GeneratedBy(ArrayReadNode.class)
@SuppressFBWarnings("SA_LOCAL_SELF_COMPARISON")
final class ArrayReadNodeGen extends ArrayReadNode implements SpecializedNode {

    @CompilationFinal private boolean excludeNumber_;
    @Child private BaseNode_ specialization_;

    private ArrayReadNodeGen() {
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return specialization_.getNodeCost();
    }

    @Override
    protected Object executeWithTarget(VirtualFrame frameValue, JavaObject arg0Value, Object arg1Value) {
        return specialization_.execute(frameValue, arg0Value, arg1Value);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static ArrayReadNode create() {
        return new ArrayReadNodeGen();
    }

    @GeneratedBy(ArrayReadNode.class)
    private abstract static class BaseNode_ extends SpecializationNode {

        @CompilationFinal protected ArrayReadNodeGen root;

        BaseNode_(ArrayReadNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ArrayReadNodeGen) root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[] {null, null};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object arg0Value, Object arg1Value) {
            return this.execute((VirtualFrame) frameValue, (JavaObject) arg0Value, arg1Value);
        }

        public abstract Object execute(VirtualFrame frameValue, JavaObject arg0Value, Object arg1Value);

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object arg0Value, Object arg1Value) {
            if (arg0Value instanceof JavaObject && arg1Value instanceof Number) {
                Number arg1Value_ = (Number) arg1Value;
                Class<?> clazz1 = (arg1Value_.getClass());
                if ((arg1Value_.getClass() == clazz1)) {
                    if (!root.excludeNumber_) {
                        SpecializationNode s = NumberNode_.create(root, clazz1);
                        if (countSame(s) < (3)) {
                            return s;
                        }
                    }
                }
                root.excludeNumber_ = true;
                return NumberGenericNode_.create(root);
            }
            return null;
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_) this.next;
        }

    }
    @GeneratedBy(ArrayReadNode.class)
    private static final class UninitializedNode_ extends BaseNode_ {

        UninitializedNode_(ArrayReadNodeGen root) {
            super(root, 2147483647);
        }

        @Override
        public Object execute(VirtualFrame frameValue, JavaObject arg0Value, Object arg1Value) {
            return uninitialized(frameValue, arg0Value, arg1Value);
        }

        static BaseNode_ create(ArrayReadNodeGen root) {
            return new UninitializedNode_(root);
        }

    }
    @GeneratedBy(methodName = "doNumber(JavaObject, Number, Class<>)", value = ArrayReadNode.class)
    private static final class NumberNode_ extends BaseNode_ {

        private final Class<?> clazz;

        NumberNode_(ArrayReadNodeGen root, Class<?> clazz) {
            super(root, 1);
            this.clazz = clazz;
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arg0Value, Object arg1Value) {
            if (newNode.getClass() == NumberGenericNode_.class) {
                removeSame("Contained by doNumberGeneric(JavaObject, Number)");
            }
            return super.merge(newNode, frameValue, arg0Value, arg1Value);
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arg0Value, Object arg1Value) {
            if (arg0Value instanceof JavaObject && arg1Value instanceof Number) {
                Number arg1Value_ = (Number) arg1Value;
                if ((arg1Value_.getClass() == this.clazz)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object execute(VirtualFrame frameValue, JavaObject arg0Value, Object arg1Value) {
            if (arg1Value instanceof Number) {
                Number arg1Value_ = (Number) arg1Value;
                if ((arg1Value_.getClass() == this.clazz)) {
                    return ArrayReadNode.doNumber(arg0Value, arg1Value_, this.clazz);
                }
            }
            return getNext().execute(frameValue, arg0Value, arg1Value);
        }

        static BaseNode_ create(ArrayReadNodeGen root, Class<?> clazz) {
            return new NumberNode_(root, clazz);
        }

    }
    @GeneratedBy(methodName = "doNumberGeneric(JavaObject, Number)", value = ArrayReadNode.class)
    private static final class NumberGenericNode_ extends BaseNode_ {

        NumberGenericNode_(ArrayReadNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute(VirtualFrame frameValue, JavaObject arg0Value, Object arg1Value) {
            if (arg1Value instanceof Number) {
                Number arg1Value_ = (Number) arg1Value;
                return ArrayReadNode.doNumberGeneric(arg0Value, arg1Value_);
            }
            return getNext().execute(frameValue, arg0Value, arg1Value);
        }

        static BaseNode_ create(ArrayReadNodeGen root) {
            return new NumberGenericNode_(root);
        }

    }
}
