package com.oracle.truffle.api.interop.java;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import java.util.List;

/**
 * This message resolution is generated by {@link com.oracle.truffle.api.interop.java.JavaFunctionMessageResolution.ExecuteNode}
 * It is used by the foreign access factory {@link com.oracle.truffle.api.interop.java.JavaFunctionMessageResolutionForeign}
 */
abstract class ExecuteNodeSub extends com.oracle.truffle.api.interop.java.JavaFunctionMessageResolution.ExecuteNode {
    public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
    @Specialization
    protected Object accessWithTarget(com.oracle.truffle.api.frame.VirtualFrame frame, com.oracle.truffle.api.interop.java.JavaFunctionObject function, java.lang.Object[] args) {
        return access(frame, function, args);
    }
    private static final class EXECUTERootNode extends RootNode {
        protected EXECUTERootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Child private ExecuteNodeSub node = com.oracle.truffle.api.interop.java.ExecuteNodeSubNodeGen.create();
        @Override
        public Object execute(VirtualFrame frame) {
            try {
              Object receiver = ForeignAccess.getReceiver(frame);
              List<Object> arguments = ForeignAccess.getArguments(frame);
              Object[] args = new Object[arguments.size()];
              for (int i = 0; i < arguments.size(); i++) {
                args[i] = arguments.get(i);
              }
              return node.executeWithTarget(frame, receiver, args);
            } catch (UnsupportedSpecializationException e) {
                throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
            }
        }

    }
    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new EXECUTERootNode(language);
    }
}
