package com.oracle.truffle.api.interop.java;
import com.oracle.truffle.api.interop.ForeignAccess.Factory18;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.RootNode;

/**
 * This foreign access factory is generated by {@link com.oracle.truffle.api.interop.java.JavaObjectMessageResolution}.
 * You are supposed to use it for the receiver object {@link com.oracle.truffle.api.interop.java.JavaObject}.
 */
final class JavaObjectMessageResolutionForeign implements Factory18, Factory {
  public static final ForeignAccess ACCESS = ForeignAccess.create(new JavaObjectMessageResolutionForeign(), null);
  public static ForeignAccess createAccess() { return ForeignAccess.create(new JavaObjectMessageResolutionForeign(), null); }

  private JavaObjectMessageResolutionForeign() { }

  @Override
  public boolean canHandle(TruffleObject obj) {
    return com.oracle.truffle.api.interop.java.JavaObject.isInstance(obj);
  }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(com.oracle.truffle.api.interop.java.NullCheckNodeSub.createRoot(com.oracle.truffle.api.interop.java.JavaInteropLanguage.class));
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(com.oracle.truffle.api.interop.java.ArrayHasSizeNodeSub.createRoot(com.oracle.truffle.api.interop.java.JavaInteropLanguage.class));
    }
    @Override
    public CallTarget accessGetSize() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(com.oracle.truffle.api.interop.java.ArrayGetSizeNodeSub.createRoot(com.oracle.truffle.api.interop.java.JavaInteropLanguage.class));
    }
    @Override
    public CallTarget accessUnbox() {
      return null;
    }
    @Override
    public CallTarget accessRead() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(com.oracle.truffle.api.interop.java.ReadFieldNodeSub.createRoot(com.oracle.truffle.api.interop.java.JavaInteropLanguage.class));
    }
    @Override
    public CallTarget accessWrite() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(com.oracle.truffle.api.interop.java.WriteFieldNodeSub.createRoot(com.oracle.truffle.api.interop.java.JavaInteropLanguage.class));
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(com.oracle.truffle.api.interop.java.InvokeNodeSub.createRoot(com.oracle.truffle.api.interop.java.JavaInteropLanguage.class));
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(com.oracle.truffle.api.interop.java.NewNodeSub.createRoot(com.oracle.truffle.api.interop.java.JavaInteropLanguage.class));
    }
    @Override
    public CallTarget accessKeys() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(com.oracle.truffle.api.interop.java.PropertiesNodeSub.createRoot(com.oracle.truffle.api.interop.java.JavaInteropLanguage.class));
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }
}
