package com.oracle.truffle.api.interop.java;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;

/**
 * This message resolution is generated by {@link com.oracle.truffle.api.interop.java.JavaObjectMessageResolution.NullCheckNode}
 * It is used by the foreign access factory {@link com.oracle.truffle.api.interop.java.JavaObjectMessageResolutionForeign}
 */
abstract class NullCheckNodeSub extends com.oracle.truffle.api.interop.java.JavaObjectMessageResolution.NullCheckNode {
    public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
    @Specialization
    protected Object accessWithTarget(com.oracle.truffle.api.interop.java.JavaObject object) {
        return access(object);
    }
    private static final class IS_NULLRootNode extends RootNode {
        protected IS_NULLRootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Child private NullCheckNodeSub node = com.oracle.truffle.api.interop.java.NullCheckNodeSubNodeGen.create();
        @Override
        public Object execute(VirtualFrame frame) {
            Object receiver = ForeignAccess.getReceiver(frame);
            try {
                return node.executeWithTarget(frame, receiver);
            } catch (UnsupportedSpecializationException e) {
                throw UnsupportedTypeException.raise(e.getSuppliedValues());
            }
        }

    }
    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new IS_NULLRootNode(language);
    }
}
