// CheckStyle: start generated
/*
 * Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;

@GeneratedBy(ToJavaNode.class)
@SuppressFBWarnings("SA_LOCAL_SELF_COMPARISON")
final class ToJavaNodeGen extends ToJavaNode implements SpecializedNode {

    @CompilationFinal private boolean excludeCached_;
    @Child private BaseNode_ specialization_;

    private ToJavaNodeGen() {
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return specialization_.getNodeCost();
    }

    @Override
    public Object execute(VirtualFrame frameValue, Object arg0Value, Class<?> arg1Value) {
        return specialization_.execute(frameValue, arg0Value, arg1Value);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static ToJavaNode create() {
        return new ToJavaNodeGen();
    }

    @GeneratedBy(ToJavaNode.class)
    private abstract static class BaseNode_ extends SpecializationNode {

        @CompilationFinal protected ToJavaNodeGen root;

        BaseNode_(ToJavaNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ToJavaNodeGen) root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[] {null, null};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object arg0Value, Object arg1Value) {
            return this.execute((VirtualFrame) frameValue, arg0Value, (Class<?>) arg1Value);
        }

        public abstract Object execute(VirtualFrame frameValue, Object arg0Value, Class<?> arg1Value);

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object arg0Value, Object arg1Value) {
            if (arg1Value instanceof Class<?>) {
                Class<?> arg1Value_ = (Class<?>) arg1Value;
                if ((arg0Value == null)) {
                    return NullNode_.create(root);
                }
                Class<?> cachedOperandType2 = (arg0Value.getClass());
                Class<?> cachedTargetType2 = (arg1Value_);
                if ((arg0Value != null) && (arg0Value.getClass() == cachedOperandType2) && (arg1Value_ == cachedTargetType2)) {
                    if (!root.excludeCached_) {
                        SpecializationNode s = CachedNode_.create(root, cachedOperandType2, cachedTargetType2);
                        if (countSame(s) < (3)) {
                            return s;
                        }
                    }
                }
                if ((arg0Value != null)) {
                    root.excludeCached_ = true;
                    return GenericNode_.create(root);
                }
            }
            return null;
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_) this.next;
        }

    }
    @GeneratedBy(ToJavaNode.class)
    private static final class UninitializedNode_ extends BaseNode_ {

        UninitializedNode_(ToJavaNodeGen root) {
            super(root, 2147483647);
        }

        @Override
        public Object execute(VirtualFrame frameValue, Object arg0Value, Class<?> arg1Value) {
            return uninitialized(frameValue, arg0Value, arg1Value);
        }

        static BaseNode_ create(ToJavaNodeGen root) {
            return new UninitializedNode_(root);
        }

    }
    @GeneratedBy(methodName = "doNull(Object, Class<>)", value = ToJavaNode.class)
    private static final class NullNode_ extends BaseNode_ {

        NullNode_(ToJavaNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute(VirtualFrame frameValue, Object arg0Value, Class<?> arg1Value) {
            if ((arg0Value == null)) {
                return root.doNull(arg0Value, arg1Value);
            }
            return getNext().execute(frameValue, arg0Value, arg1Value);
        }

        static BaseNode_ create(ToJavaNodeGen root) {
            return new NullNode_(root);
        }

    }
    @GeneratedBy(methodName = "doCached(VirtualFrame, Object, Class<>, Class<>, Class<>)", value = ToJavaNode.class)
    private static final class CachedNode_ extends BaseNode_ {

        private final Class<?> cachedOperandType;
        private final Class<?> cachedTargetType;

        CachedNode_(ToJavaNodeGen root, Class<?> cachedOperandType, Class<?> cachedTargetType) {
            super(root, 2);
            this.cachedOperandType = cachedOperandType;
            this.cachedTargetType = cachedTargetType;
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arg0Value, Object arg1Value) {
            if (newNode.getClass() == GenericNode_.class) {
                removeSame("Contained by doGeneric(VirtualFrame, Object, Class<>)");
            }
            return super.merge(newNode, frameValue, arg0Value, arg1Value);
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arg0Value, Object arg1Value) {
            if (arg1Value instanceof Class<?>) {
                Class<?> arg1Value_ = (Class<?>) arg1Value;
                if ((arg0Value != null) && (arg0Value.getClass() == this.cachedOperandType) && (arg1Value_ == this.cachedTargetType)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object execute(VirtualFrame frameValue, Object arg0Value, Class<?> arg1Value) {
            if ((arg0Value != null) && (arg0Value.getClass() == this.cachedOperandType) && (arg1Value == this.cachedTargetType)) {
                return root.doCached(frameValue, arg0Value, arg1Value, this.cachedOperandType, this.cachedTargetType);
            }
            return getNext().execute(frameValue, arg0Value, arg1Value);
        }

        static BaseNode_ create(ToJavaNodeGen root, Class<?> cachedOperandType, Class<?> cachedTargetType) {
            return new CachedNode_(root, cachedOperandType, cachedTargetType);
        }

    }
    @GeneratedBy(methodName = "doGeneric(VirtualFrame, Object, Class<>)", value = ToJavaNode.class)
    private static final class GenericNode_ extends BaseNode_ {

        GenericNode_(ToJavaNodeGen root) {
            super(root, 3);
        }

        @Override
        public Object execute(VirtualFrame frameValue, Object arg0Value, Class<?> arg1Value) {
            if ((arg0Value != null)) {
                return root.doGeneric(frameValue, arg0Value, arg1Value);
            }
            return getNext().execute(frameValue, arg0Value, arg1Value);
        }

        static BaseNode_ create(ToJavaNodeGen root) {
            return new GenericNode_(root);
        }

    }
}
